/*****************************************************************************
 * memo7.c: Demonstrate an action proc with arguments.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/StaticText.h>
#include "libXs.h"

void
quit(w, event, params, num_params)
  Widget  w;
  XEvent *event;
  String *params;
  int    *num_params;
{
  if(*num_params == 1)
    sleep(atoi(params[0]));
  XtCloseDisplay(XtDisplay(w));
  exit(0);
}

static XtActionsRec actionsTable [] = {
  {"bye",   quit},
};

static char defaultTranslations[] =  "<Key>q:  bye(10)";

main(argc, argv)
  int   argc;
  char *argv[];
{
  Widget          toplevel, msg_widget;
  Arg             wargs[1];
  int             n;
  String          message;
  XtTranslations  trans_table;

  /*
   * Initialize Intrinsics
   */
  toplevel = OlInitialize(argv[0], "Memo", NULL, 0, &argc, argv);
  /*
   * Register the new actions, and compile 
   * translations table
   */
  XtAddActions(actionsTable, XtNumber(actionsTable));
  trans_table =
        XtParseTranslationTable(defaultTranslations); 
  /*
   * If a message is given on the command-line,
   * use it as the XtNstring argument for the widget
   */
  n = 0;
  if ((message = xs_concat_words(argc - 1, &argv[1])) != NULL){
    XtSetArg(wargs[n], XtNstring, message); n++;
  }
  /*
   * Create the message widget.
   */
  msg_widget = XtCreateManagedWidget("msg", staticTextWidgetClass,
                                     toplevel, wargs, n);
  /*
   * Merge the program-defined translations with 
   * existing translations.
   */
  XtOverrideTranslations(msg_widget, trans_table);
  /*
   * Realize all widgets and enter the event loop.
   */
  XtRealizeWidget(toplevel);
  XtMainLoop();
}
