/*-------------------------------------------------------------*/
/*  File:  ol_hello.c 
 *
 *  OLIT version of the "Hello, World!" program
 *  with an exit button.  Uses OLIT's Form, 
 *  OblongButton, and StaticText widgets.
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/Form.h>
#include <Xol/StaticText.h>
#include <Xol/OblongButt.h>

typedef struct APP_DATA   /* Application's data   */
{
    char   *mtext;        /* Message string       */
    char   *etext;        /* Label on exit button */
} APP_DATA, *P_APP_DATA;

/* Command-line options specific to this application */

static XrmOptionDescRec options[] =
{
    {"-mtext", "*mtext", XrmoptionSepArg, NULL},
    {"-etext", "*etext", XrmoptionSepArg, NULL}
};

/* Resources specific to this application */

static XtResource resources[] =
{
    {"mtext", "Mtext", XtRString, sizeof(String),
     XtOffset(P_APP_DATA, mtext), XtRString, "Hello, World!"},
     
    {"etext", "Etext", XtRString, sizeof(String),
     XtOffset(P_APP_DATA, etext), XtRString, "Quit"}
};

/* Room for setting up arguments passed to widgets */
static Arg args[10];

/* Callback function */

static void quit_action();

/*-------------------------------------------------------------*/
void main(argc, argv)
int  argc;
char **argv;
{
    APP_DATA data;
    
    Widget main_widget, form_widget, hello_message, exit_button;

/* Create and initialize the top-level widget */
    main_widget = OlInitialize(argv[0], "Ol_hello", options, 
                               XtNumber(options), &argc, argv);

/* Get the resources from the resource file */
    XtGetApplicationResources(main_widget, &data, resources,
                              XtNumber(resources), NULL, 0);
                              
    printf("mtext = %s\netext = %s\n", data.mtext, data.etext);

/* Next, create the Form widget that will hold the 
 * OblongButton and the StaticText widgets
 */
    form_widget = XtCreateManagedWidget("Form", 
                      formWidgetClass, main_widget, NULL, 0);

/* Create the exit button */
    exit_button = XtVaCreateManagedWidget("Exit", 
                      oblongButtonWidgetClass, form_widget, 
                      XtNlabel,     data.etext,
                      NULL);

/* Install the callback function for this OblongButton */
    XtAddCallback(exit_button, XtNselect, quit_action, NULL);

/* Now, create the message text */
    hello_message = XtVaCreateManagedWidget("Hello", 
                      staticTextWidgetClass, form_widget, 
                      XtNstring,        data.mtext,
                      XtNyRefWidget,    exit_button,
                      XtNyAddHeight,    True,
                      XtNxResizable,    True,
                      XtNyResizable,    True,
                      XtNyAttachBottom, True,
                      XtNxAttachRight,  True,
                      NULL);

/* Realize the widgets and start processing events */
    XtRealizeWidget(main_widget);
    XtMainLoop();
}
/*-------------------------------------------------------------*/
/*  q u i t _ a c t i o n
 *
 *  Function to be called when user presses and releases button
 *  in the "Exit" OblongButton.
 */
static void quit_action(w, client_data, call_data)
Widget    w;
XtPointer client_data;
XtPointer call_data;
{
    XtCloseDisplay(XtDisplay(w));
    exit(0);
}
