.\" @(#)cmdtool.1 1.27 90/06/19 SMI; 
.\" @(#)cmdtool.1 1.25 90/02/26 SMI;
.\" Updated 6/8/90 
.TH CMDTOOL 1  "11 June 1990"
.SH NAME
.B cmdtool 
\- run a shell (or other program) in an OpenWindows enhanced terminal window
.SH SYNOPSIS
.B cmdtool
[
.B \-C
]
[
.B \-M
.I bytes
]
[
.B \-P
.I count
]
[
.B \-B
.I boldstyle
]
[
.B \-I
.I command
]
[
.I generic-tool-arguments
]
[
.I program
[ 
.I program-arguments
]
]
.SH AVAILABILITY
This command is available with the
OpenWindows user environment.
For information about installing OpenWindows, refer to the
.I OpenWindows Installation and Start-Up Guide.
.SH DESCRIPTION
.IX cmdtool "" "\fLcmdtool\fR \(em shell or program with XView text facility"
.IX "shell window" "\fLcmdtool\fR"
.LP
.B cmdtool
is the standard
.I OpenWindows
support facility for shells and other programs.
When invoked,
.B cmdtool
runs a program (usually a shell) in a text-based command window.
Characters typed on the keyboard are inserted at the caret.  If the
program is a shell, that shell accepts and runs commands in the
usual manner.  
.B cmdtool
also supports programs that perform cursor motions directly, such
as
.BR vi (1).
.LP
The text of the current command line can be edited using normal
.BR textedit (1)
functions.
The command window displays a log of the
session, which can be scrolled through using the scrollbar
(unless the escape command mode is in effect).
This log can be edited, and saved by choosing the
.RB ` "Store as New File" '
item in the text facility's pop-up menu.
.SH OPTIONS
.TP 15
.B \-C
Console 
.BR cmdtool .
Redirect system console output to this shelltool.
Display console messages in this
.BR cmdtool ,
which might otherwise appear in unexpected places on the 
workstation screen.  Since a
.B cmdtool
window can be scrolled, console error messages can be recorded for
later examination.
.TP
.BI \-M " bytes"
Set the log to wrap-around after the indicated
number of
.IR bytes .
.TP
.BI \-P " count"
Checkpoint the log after every set of
.I count
editing operations.
.TP
.BI \-B " boldstyle"
Set the style for displaying bold text to
.IR boldstyle .
.I boldstyle
can be a string specifying one of the choices for the
.B term.boldstyle
default, see
.BR "Defaults Options" ,
below, or it may be a numerical value for one of those choices,
from 0 to 8, corresponding to the placement of the choice in the list.
.TP
.BI \-I " command"
Pass
.I command
to the shell. 
.SM SPACE
characters within the command must be escaped.
.TP
.I generic-tool-arguments
.B cmdtool
accepts the generic tool arguments
listed in
.BR xview (1).
.HP
.I program
[
.I program-arguments
]
.br
If a
.I program
argument is present,
.B cmdtool
runs it and passes any remaining arguments to that
.IR program .
If no
.I program
is given,
.B cmdtool
runs the program indicated by the
.B \s-1SHELL\s0
environment variable, or
.B /bin/sh
by default.
.SH USAGE
.SS .Xdefaults File Options
.LP
You can specify a number of defaults using the options
in the 
.B .Xdefaults
file that effect the behavior of 
.BR  cmdtool .
The ones of interest are those that begin with
.BR text , term ,
or 
.BR keyboard .
See
.BR xview (1)
for more detailed information.
.SS cmdtool Windows
.LP
The window created by 
.B cmdtool
is based on the text facility that is described in the 
.B textedit
man page.
The user is given a prompt at which to type commands and pop-up
menus from which to select command options.
.LP
.B cmdtool
windows support cursor motions, using an
.B /etc/termcap
entry called
.BR sun-cmd .
Command windows automatically set the
.B \s-1TERM\s0
environment variable to
.BR sun-cmd .
So, if you
.BR rlogin (1C)
to a machine that does not have an entry for
.B sun-cmd
in its
.B /etc/termcap
file, the error message
.RB ` "Type sun-cmd unknown" '
r
.RB ` "set \s-1TERM\s0=sun" '.
Programs written using the
.BR curses (3X)
or 
.BR curses (3V)
library packages will work in a command window, but programs
hard-coded for
.BR sun -type
terminals may not. 
When supporting a program that performs
cursor motions, the command window automatically takes on the
characteristics of a tty window (as with
.BR shelltool (1)).
When that program terminates or sleeps, the full command window
functionality is restored.
.LP
.B cmdtool
supports programs that use
.SM CBREAK
and
.SM NO ECHO
terminal modes. 
This support is normally invisible to the user.
However, programs that use
.SM RAW
mode, such as
.BR rlogin (1C)
and
.BR script (1),
inhibit command-line editing with the mouse.
In this case, however, tty-style
.SM ERASE,
word-kill and line-kill characters can still be used to edit the
current command line.
.SS The cmdtool Menu
.LP
The
.B cmdtool
window menu is called the
.B Term Pane
menu and contains the following options and their submenus:
.TP 10
.PD 0
.B History 
Creates a a list of commands used during the
cmdtool session.
.RS
.TP 10
.B Mode
.RS
.TP 10
.B Editable
You can edit the contents of the window.
.TP
.B Read Only
You can only read from the window.
.RE
.TP
.B Store Log as new file
Create a new file that contains the contents of the log.
.TP
.B Clear log
Clears all entries from the log.
.RE
.TP
.B Edit
Provides a set of editing functions for this window.
.RS
.TP 10
.B Again
Repeats the last action.
.TP
.B Undo
.RS
.TP 10
.B Undo Last Edit
Undoes the last edit made in
.B cmdtool .
.TP
.B Undo All Edits
Undoes all edits made during this session of
.B cmdtool .
.RE
.TP
.B Copy
Makes a copy of the selected text and places 
it on the clipboard.
.TP
.B Paste
Pastes a copy of the text stored on the 
clipboard at the cursor location.
.TP
.B Cut
Deletes the selected text.RE
.TP

Provides a set of find and replace functions.
.RS
.TP 10
.B Find and Replace
Brings up a pop-up menu containing text fields 
and command buttons that allow you to search 
forward and backward through the file being 
edited for specific text strings. 
Allows you to specify options for the 
replacement of text.
.TP
.B Find Selection
.RS
.TP 10
.B Forward
Searches forward to find a selected text string.
.TP
.B Backward
Searches backward to find a selected text string.
.RE
.TP
.B Find Marked Text
Brings up a pop-up menu that allows you to 
find text that is included between specified 
bracket pairs. 
Also allows you to insert or remove bracket 
pairs around selected text.
.TP
.B Replace |>field<| >
Allows you to replace selected text forward 
and backward throughout the file.
.RE
.RE
.TP 10
.B Extras
A user-definable pull-right menu controlled by the
.B /usr/lib/.text_extras_menu
file.
This can be overridden in two ways:
.br
1) Change the value of the .Xdefaults parameter 
.B text.extrasMenuFilename 
to the correct file path.
.br
2) Set the environment variable 
.B \s-1EXTRASMENU\s0
to the file desired.
.br
Note that option 1 overrides option 2 if both are
used.
For more information see the
.I "DeskSet Environment Reference Guide" .
.TP
.B File Editor
.RS
.TP 10
.B Enable
Allows you to edit files from within
.B cmdtool.
.TP
.B Disable
Turns off the ability to edit files from
within 
.B cmdtool.
.RE
.TP
.B Scrolling
.RS
.TP 10
.B Enables Scrolling
Enables scrolling within
.B cmdtool.
.TP
.B Disable Scrolling
Turns off the ability to scroll within
.B cmdtool.
Once scrolling in 
.B cmdtool is disabled, it's functionality is
identical to
.B shelltool
and a more restricted menu appears. Selecting the
.B Enable Scrolling
option from the restricted menu restores the full menu
and functionality of
.B cmdtool.
.R.RE
.SS User Defined Keyboard Remapping
.
The file 
.B ~/.textswrc
specifies filter programs that are assigned to
(available) function keys.
These filters are applied to the contents of the
primary selection.
Their output is entered at the caret.
.SS Accelerators
.LP
Text facility accelerators that are especially useful in
command windows are described here.  See 
.br
.BR textedit (1)
for more information.
.TP 18
.SM CTRL-RETURN
Position the caret at the bottom, and scroll it into view
as determined by 
.BR Text.LowerContext .
.TP 
.PD 0
\s-1CAPS\s0-lock
.TP
Toggle between all-upper-case keyboard input, and mixed-case.
.PD
.SH FILES
.PD 0
.TP 20
.BI /tmp/tty.txt. pid
log file
.TP
.B ~/.textswrc
.TP
.B ~/.ttyswrc
.TP
.B usr/lib/.text_extras_menu
.TP
.B $HOME/.TextExtraMenu
.TP
.B /etc/termcap
.TP
.B /usr/bin/sh
.PD
.SH "SEE ALSO"
.BR rlogin (1C),
.BR script (1),
.BR shelltool (1),
.BR textedit (1),
.BR vi (1),
.BR xview (1),
.BR curses (3V),
.BR curses (3X)
.LP
.I "OpenWindows User's Guide" 
.SH BUGS
.LP
Typing ahead while
.B cmdtool 
changes between its scrollable and cursor motion modes
will sometimes freeze
.B cmdtool .
.LP
Full terminal emulation is not complete.
Some manifestations of this deficiency are:
.TP 3
\(bu
File completion in the C shell does not work.
.TP
\(bu
Enhanced display of text is not supported.
