/*****************************************************************************
 * libXs.h: the header file.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#define XtRVerlevel "Verlevel"

typedef enum {
    LEVEL1,
    LEVEL2,
    LEVEL3,
    LEVEL4,
} verlevel;

typedef struct _bitmap_struct {
    unsigned char *bitmap;
    Dimension width;
    Dimension height;
} xs_bitmap_struct;

extern Widget    xs_create_button ();
extern void      xs_invert_widget ();
extern String    xs_concat_words ();
Boolean          xs_cvt_str_to_verlevel();
extern XImage   *xs_create_image ();
extern Widget    xs_create_pixmap_button ();
extern Widget    xs_create_pixmap_browser ();
void             xs_insert_string();
extern GC        xs_create_xor_gc();
