/*****************************************************************************
 * flfontchooser.c: Demonstrate the FlatExclusives and 
 *                  FlatNonexclusives widgets.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/ControlAre.h>
#include <Xol/FExclusive.h>
#include <Xol/FNonexclus.h>
#include <Xol/Caption.h>
#include <Xol/RectButton.h>
#include <Xol/StaticText.h>
#include "flfontchooser.h"

static Widget st, font, style, fontcolor, bgcolor, scale;
static fontchoice *fc;

main(argc, argv)
  int argc;
  char *argv[];
{
  Widget     toplevel, con, create_fl_ex_nonex();
  void       font_callback(), scale_callback(), 
             fontcolor_callback(), bgcolor_callback(),
             style_callback(), default_choice(), set_font();

  /*
   * Initialize the fontchoice structure
   */
  fc      = (fontchoice *)XtMalloc(sizeof(fontchoice));
  default_choice(fc);
  toplevel = OlInitialize(argv[0], "Flfontchooser", NULL, 0, 
                          &argc, argv);
  con = XtVaCreateManagedWidget("control", 
                                controlAreaWidgetClass,
                                toplevel, 
                                XtNalignCaptions, TRUE,
                                XtNlayoutType,    OL_FIXEDCOLS,
                                XtNmeasure,       1,
                                NULL);
  /*
   * Create FlatExclusives and FlatNonexclusives widgets
   */
  font      = create_fl_ex_nonex(con, fontItems, fonts, 
                XtNumber(fonts), "Font:", 
                flatExclusivesWidgetClass, font_callback);
  style     = create_fl_ex_nonex(con, styleItems, styles, 
                XtNumber(styles), "Style:", 
                flatNonexclusivesWidgetClass, style_callback);
  fontcolor = create_fl_ex_nonex(con, fontColorItems, 
                colors, XtNumber(colors), 
                "Font Color:", flatExclusivesWidgetClass, 
                fontcolor_callback);
  bgcolor   = create_fl_ex_nonex(con, bgColorItems, colors, 
                XtNumber(colors), "Background Color:", 
                flatExclusivesWidgetClass, bgcolor_callback);
  scale     = create_fl_ex_nonex(con, scaleItems, scales, 
                XtNumber(scales),
                "Scale:", flatExclusivesWidgetClass, 
                scale_callback);
  /*
   * Create the StaticText widget used to display the font
   */
  st = XtVaCreateManagedWidget("st", staticTextWidgetClass, 
                               con, 
                               XtNborderWidth, 4,
                               NULL);
  set_font(st);
  XtRealizeWidget(toplevel);
  XtMainLoop();
}

Widget
create_fl_ex_nonex(parent, flitems, names, number, 
                           label, class, callback)
  Widget      parent;
  FlatItems  *flitems;
  char       *names[];
  int         number;
  String      label;
  WidgetClass class;
  void        (*callback)();
{
  Widget caption, fl_ex_nonex;
  int    i;

  /* Create Exclusives widgets */
  caption = XtVaCreateManagedWidget("", captionWidgetClass, 
                       parent, 
                       XtNlabel, label,
                       NULL);
  for(i=0;i<number;i++) {
    (flitems[i]).label = (XtArgVal)names[i];
    (flitems[i]).selectProc = (XtArgVal)callback;
    if(class == flatNonexclusivesWidgetClass)
      (flitems[i]).unselectProc = (XtArgVal)callback;
    else
      (flitems[i]).unselectProc = (XtArgVal)NULL;
    (flitems[i]).clientData = (XtArgVal)names[i];
  }
  fl_ex_nonex = XtVaCreateManagedWidget("", class, caption, 
                       XtNitems, flitems,
                       XtNnumItems, number,
                       XtNitemFields, FlatFields,
                       XtNnumItemFields, XtNumber(FlatFields),
                       NULL);
  return(fl_ex_nonex);
}

void
font_callback(w, client_data, call_data)
  Widget    w;
  XtPointer client_data, call_data;
{
  void set_font();

  fc->font = (String)client_data;
  set_font(st);
}

void
style_callback(w, client_data, call_data)
  Widget    w;
  XtPointer client_data, call_data;
{
  OlFlatCallData *olfcd = (OlFlatCallData *)call_data;
  static Boolean italic = FALSE, bold = FALSE;
  void set_font();

  /*
   * Get the current state of the buttons
   */
  if(olfcd->item_index == BOLDINDEX)
    OlVaFlatGetValues(w, BOLDINDEX, XtNset, &bold, NULL);
  if(olfcd->item_index == ITALICINDEX)
    OlVaFlatGetValues(w, ITALICINDEX, XtNset, &italic, NULL);
  fc->italic = italic;
  fc->bold = bold;
  set_font(st);
}

void
scale_callback(w, client_data, call_data)
  Widget w;
  XtPointer client_data, call_data;
{
  void set_font();

  fc->scale = (String)client_data;
  set_font(st);
}

void
fontcolor_callback(w, client_data, call_data)
  Widget    w;
  XtPointer client_data, call_data;
{
  void set_font();

  fc->fontcolor = (String)client_data;
  set_font(st);
}

void
bgcolor_callback(w, client_data, call_data)
  Widget    w;
  XtPointer client_data, call_data;
{
  void set_font();

  fc->bgcolor = (String)client_data;
  set_font(st);
}

void
default_choice(fchoice)
  fontchoice *fchoice;
{
  fchoice->font       = fonts[0];
  fchoice->bold       = FALSE;
  fchoice->italic     = FALSE;
  fchoice->fontcolor  = colors[0];
  fchoice->bgcolor    = colors[0];
  fchoice->scale      = scales[0];
}

void
set_font(w)
  Widget w;
{
  char   fontname[64];

  /*
   * Create the string for the font name
   */
  sprintf(fontname, "%s%s%s%s-%s",
                fc->font,
                ((fc->bold || fc->italic) ? "-" : ""),
                (fc->bold ? "bold" : ""),
                (fc->italic ? "italic" : ""),
                fc->scale);
  /*
   * Set the values from the fontchoice structure
   */
  XtVaSetValues(w,
                XtNstring, fontname,
                XtVaTypedArg, XtNfont, XtRString,
                fontname, strlen(fontname)+1,
                XtVaTypedArg, XtNfontColor, XtRString,
                fc->fontcolor, strlen(fc->fontcolor)+1,
                XtVaTypedArg, XtNbackground, XtRString,
                fc->bgcolor, strlen(fc->bgcolor)+1,
                NULL);
}
