/*****************************************************************************
 * rmtest4.c: demonstrate dynamic resources.
 *
 *         From:
 *                   The X Window System, 
 *            Programming and Applications with Xt
 *                   OPEN LOOK Edition
 *         by
 *              Douglas Young & John Pew
 *              Prentice Hall, 1991
 *
 *              Example described on pages: 
 *
 *
 *  Copyright 1991 by Prentice Hall
 *  All Rights Reserved
 *
 * This code is based on the OPEN LOOK Intrinsics Toolkit (OLIT) and 
 * the X Window System
 *
 * Permission to use, copy, modify, and distribute this software for 
 * any purpose and without fee is hereby granted, provided that the above
 * copyright notice appear in all copies and that both the copyright notice
 * and this permission notice appear in supporting documentation.
 *
 * Prentice Hall and the authors disclaim all warranties with regard to 
 * this software, including all implied warranties of merchantability and 
 * fitness.
 * In no event shall Prentice Hall or the authors be liable for any special,
 * indirect or consequential damages or any damages whatsoever resulting from 
 * loss of use, data or profits, whether in an action of contract, negligence 
 * or other tortious action, arising out of or in connection with the use 
 * or performance of this software.
 *
 * OPEN LOOK is a trademark of UNIX System Laboratories.
 * X Window System is a trademark of the Massachusetts Institute of Technology
 ****************************************************************************/

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>
#include <Xol/StaticText.h>
#include "libXs.h"

static char *levels[] = { "LEVEL1", "LEVEL2", "LEVEL3", "LEVEL4" };

typedef struct {
   Pixel    fg, bg;
   float    delay;
   verlevel  verbose;
   Position x, y;
} ApplicationData, *ApplicationDataPtr;

static XtResource resources[] = {
  { XtNforeground, XtCForeground, XtRPixel, sizeof (Pixel),
    XtOffset(ApplicationDataPtr, fg), XtRString, "Black" },
  { XtNbackground, XtCBackground, XtRPixel, sizeof (Pixel),
    XtOffset(ApplicationDataPtr, bg), XtRString, "White" },
  { "delay", "Delay", XtRFloat, sizeof (float),
    XtOffset(ApplicationDataPtr, delay), XtRString,"2.5" },
  { "verbose", "Verbose", XtRVerlevel, sizeof (verlevel),
    XtOffset(ApplicationDataPtr,verbose), XtRString, "LEVEL4"},
  { XtNx, XtCX, XtRPosition, sizeof (Position),
    XtOffset(ApplicationDataPtr, x), XtRImmediate, (XtPointer)25 },
  { XtNy, XtCY, XtRPosition, sizeof (Position),
    XtOffset(ApplicationDataPtr, y), XtRImmediate, (XtPointer)33 },
  };

static XrmOptionDescRec options[] = { 
  {"-verbose", "*verbose", XrmoptionSepArg, NULL},
  {"-delay",   "*delay",   XrmoptionSepArg, NULL}
};

static Widget toplevel;

main(argc, argv)
  int   argc;
  char *argv[];
{
  Widget          msg_widget;
  int             n;
  Arg             wargs[1];
  void            dynamic_callback();
  ApplicationData data;

  toplevel = OlInitialize(argv[0], "Rmtest4", options, 
                          XtNumber(options), &argc, argv);
  /*
   *   Add the string to float type-converter.
   */
  XtSetTypeConverter(XtRString, XtRVerlevel, xs_cvt_str_to_verlevel,
                     (XtConvertArgList)NULL, 0,
                     XtCacheAll, (XtDestructor)NULL);
  /*
   *  Retrieve the resources.
   */
  XtGetApplicationResources(toplevel, &data, resources, 
                            XtNumber(resources), NULL, 0);
  /*
   * Print the result.
   */
  printf("fg=%d, bg=%d, delay=%.2f, verbose=%s, x=%d, y=%d\n", 
         data.fg, data.bg, data.delay, levels[data.verbose], 
         data.x, data.y);
  n = 0;
  XtSetArg(wargs[n], XtNstring, (XtArgVal) "MESSAGE"); n++;
  msg_widget = XtCreateManagedWidget("msgwidget", 
                                     staticTextWidgetClass,
                                     toplevel, wargs, n);
  OlRegisterDynamicCallback(dynamic_callback, &data);
  XtRealizeWidget(toplevel);
  XtMainLoop();
}

void
dynamic_callback(datap)
  XtPointer datap;
{
  ApplicationDataPtr data = (ApplicationDataPtr)datap;

  XtGetApplicationResources(toplevel, data, resources, 
                            XtNumber(resources), NULL, 0);
  printf("fg=%d, bg=%d, delay=%.2f, verbose=%s, x=%d, y=%d\n", 
         data->fg, data->bg, data->delay, levels[data->verbose], 
         data->x, data->y);
}
