/*-------------------------------------------------------------*/
/*  File:  inp_cb.c 
 *
 *  Demonstrates input callbacks. Run this program in the
 *  foreground and type at the keyboard. When you press newline,
 *  the text appears in the window.
 *
 */
#include <stdio.h> 

#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/Text.h>

typedef struct XINPUT_DATA
{
    FILE   *stream;
    Widget widget;
} XINPUT_DATA;

#define MAXCHR 255

static XINPUT_DATA xpinfo;

/* Input callback */
static void read_input();

static char input[MAXCHR] = "Testing input callback.";

void (*txt_insert)();
/*-------------------------------------------------------------*/
void main(argc, argv)
int  argc;
char **argv;
{
    Widget main_widget, w;

/* Create and initialize the top-level widget */
    main_widget = OlInitialize(argv[0], "Ol_main", NULL,
                               0, &argc, argv);

/* Now create a Text widget to display input read from file */
    w = XtVaCreateManagedWidget("text", 
                      textWidgetClass, main_widget,
                      XtNstring,    input,
                      XtNwidth,     200,
                      XtNheight,    200,
                      NULL);

/* Get pointer to text insertion function of the Text widget */
    XtVaGetValues(w, XtNtextInsert, &txt_insert, NULL);
    
/* Set up structure with information to be used by 
 * the input callback and register the callback.
 */
    xpinfo.widget = w;
    xpinfo.stream = stdin;
    XtAddInput(fileno(stdin), XtInputReadMask, 
               read_input, &xpinfo);

/* Realize the widgets and start processing events */
    XtRealizeWidget(main_widget);
    XtMainLoop();
}
/*-------------------------------------------------------------*/
/*  r e a d _ i n p u t
 *
 *  The "input callback" function. This function is called
 *  whenever input is available from the specified file.
 */
static void read_input(client_data, fid, id)
XtPointer client_data;
int       *fid;
XtInputId *id;
{
    XINPUT_DATA *p_xp = (XINPUT_DATA *)client_data;
    
    if(fgets(input, MAXCHR, p_xp->stream) == NULL)
    {
        perror("fgets");
        exit(1);
    }

/* Insert this line into the Text widget */
    (*txt_insert)(p_xp->widget, input);
}


