/*-------------------------------------------------------------*/
/*  File:  slist.c 
 *
 *  Demonstrates the use of ScrollingList widget
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/Caption.h>
#include <Xol/ScrollingL.h>

/* Prepare item list as an array of OlListItem structures. The
 * OlListItem structure is defined as follows:
 *
 *     typedef struct _OlListItem 
 *     {
 *        OlDefine    label_type;
 *        XtPointer   label;
 *        XImage *    glyph;
 *        OlBitMask   attr;
 *        XtPointer   tag;
 *      } OlListItem;
 */
 
static OlListItem list_items[] =
{
    {OL_STRING, "BulletinBoard",     NULL, 0, 0},
    {OL_STRING, "Caption",           NULL, 0, 0},
    {OL_STRING, "CheckBox",          NULL, 0, 0},
    {OL_STRING, "ControlArea",       NULL, 0, 0},
    {OL_STRING, "Exclusives",        NULL, 0, 0},
    {OL_STRING, "FlatCheckbox",      NULL, 0, 0},
    {OL_STRING, "FlatExclusives",    NULL, 0, 0},
    {OL_STRING, "FlatNonexclusives", NULL, 0, 0},
    {OL_STRING, "Form",              NULL, 0, 0},
    {OL_STRING, "FooterPanel",       NULL, 0, 0},
    {OL_STRING, "MenuButton",        NULL, 0, 0},
    {OL_STRING, "Nonexclusives",     NULL, 0, 0},
    {OL_STRING, "OblongButton",      NULL, 0, 0},
    {OL_STRING, "RectButton",        NULL, 0, 0},
    {OL_STRING, "ScrolledWindow",    NULL, 0, 0},
    {OL_STRING, "ScrollingList",     NULL, 0, 0},
    {OL_STRING, "Slider",            NULL, 0, 0},
    {OL_STRING, "StaticText",        NULL, 0, 0},
    {OL_STRING, "Stub",              NULL, 0, 0},
    {OL_STRING, "Text",              NULL, 0, 0},
    {OL_STRING, "TextEdit",          NULL, 0, 0},
    {OL_STRING, "TextField",         NULL, 0, 0}
};

static char* list_title = "Some OPEN LOOK Widgets";

/* Pointer to "Add Item" function of ScrollingList widget*/
static OlListToken (*slist_add_item)();

/* Callback */
static void item_selected();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w, sl;
    int i;

/* Create a Caption widget */
    w = XtVaCreateManagedWidget("Caption1",
                      captionWidgetClass, parent,
                      XtNlabel,       list_title,
                      XtNposition,    OL_TOP,
                      XtNalignment,   OL_CENTER,
                      NULL);

/* Now create the ScrollingList as a child of the Caption */
    sl = XtVaCreateManagedWidget("SList1",
                      scrollingListWidgetClass, w,
                      XtNviewHeight,  10,
                      NULL);

/* Get the pointer to the "Add Item" function of 
 * ScrollingList widget
 */
    XtVaGetValues(sl, XtNapplAddItem, &slist_add_item, NULL);

/* Now add the items to the ScrollingList */
    for(i = 0; i < XtNumber(list_items); i++)
    {
        (*slist_add_item) (sl, NULL, NULL, list_items[i]); 
    }

/* Add callback for ScrollingList */
    XtAddCallback(sl, XtNuserMakeCurrent, item_selected, NULL);

    return w;
}
/*-------------------------------------------------------------*/
static void item_selected(w, client_data, call_data)
Widget      w;
XtPointer   client_data, call_data;
{
    OlListToken token = (OlListToken)call_data;
    OlListItem  *p_selected = OlListItemPointer(token);
    
    printf("%s SELECTED\n", p_selected->label);
}
