/*-------------------------------------------------------------*/
/*  File:  popmenu.c 
 *
 *  Demonstrates a the MenuShell widget
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/StaticText.h>
#include <Xol/Menu.h>
#include <Xol/MenuButton.h>
#include <Xol/OblongButt.h>

static char message[] = "Press the MENU mouse button here to \
pop up a MenuShell widget";

/* Labels for the OblongButtons used in pop-up menu */
static char* choices[] =
{
    "Undo", "Cut", "Copy", "Paste", "Paginate"
};

/* Callback */
static void button_select();
/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w, pm, menu, b;
    int    i;
    
    w = XtVaCreateManagedWidget("Stext", 
                      staticTextWidgetClass, parent,
                      XtNstring,    message,
                      XtNwidth,     150,
                      NULL);

/* Create the MenuShell widget. Notice that you have to use the
 * XtVaCreatePopupShell function, not XtVaCreateManagedWidget.
 * Primitive widgets such as StaticText can be the parent of
 * a pop-up shell widget such as MenuShell.
 */
    pm = XtVaCreatePopupShell("PopupMenu", 
                      menuShellWidgetClass, w,
                      XtNpushpin,     OL_OUT,
                      XtNtitle,       "Text",
                      NULL);

/* Get the menu pane's ID */
    XtVaGetValues(pm, XtNmenuPane, &menu, NULL);
    

/* Add the OblongButton widgets to the menu pane */
    for(i = 0; i < XtNumber(choices); i++)
    {
        b = XtVaCreateManagedWidget(choices[i],
                    oblongButtonWidgetClass, menu,
                    XtNlabel,   choices[i],
                    NULL);

/* Make the first menu item the default */
        if(i == 0) XtVaSetValues(b, XtNdefault, True, NULL);

/* Add callback to each oblong button. In this case, we are
 * using a single callback, but you can have a separate
 * callback for each button.
 */        
        XtAddCallback(b, XtNselect, button_select, 
                      (XtPointer)choices[i]);
    }
    return w;
}
/*-------------------------------------------------------------*/
static void button_select(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
    printf("%s SELECTED\n", (char*) client_data);
}


