/*-------------------------------------------------------------*/
/*  File:  non_excl.c
 *
 *  Demonstrates the use of RectButton widgets in a
 *  Nonexlusives widget.
 *
 */
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <Xol/OpenLook.h>

#include <Xol/RectButton.h>
#include <Xol/Nonexclusi.h>

/* Labels for the RectButtons */
static char* choices[] =
{
    "Xlib", "OPEN LOOK Widgets", "Motif Widgets"
};

/* Callbacks */
static void button_set();
static void button_unset();

/*-------------------------------------------------------------*/
Widget MakeWidgets(parent)
Widget parent;
{
    Widget w, b;
    int i;

/* Create the Nonexclusives widget */    
    w = XtVaCreateManagedWidget("ManyOfMany", 
                      nonexclusivesWidgetClass, parent,
                      XtNlayoutType,    OL_FIXEDCOLS,
                      NULL);

/* Add the RectButton widgets */
    for(i = 0; i < XtNumber(choices); i++)
    {
        b = XtVaCreateManagedWidget("RButton",
                    rectButtonWidgetClass, w,
                    XtNlabel,   choices[i],
                    NULL);
        XtAddCallback(b, XtNselect, button_set, 
                      (XtPointer)choices[i]);
        XtAddCallback(b, XtNunselect, button_unset, 
                      (XtPointer)choices[i]);
    }
    return w;
}
/*-------------------------------------------------------------*/
static void button_set(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
    printf("%s SET\n", (char*) client_data);
}
/*-------------------------------------------------------------*/
static void button_unset(w, client_data, call_data)
Widget    w;
XtPointer client_data, call_data;
{
    printf("%s UNSET\n", (char*) client_data);
}

