.\" $XConsortium: Xnest.man,v 1.3 94/04/17 20:30:03 dpw Exp $
.\" Copyright (c) 1993, 1994  X Consortium
.\" 
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.TH XNEST 1 "Release 6" "X Version 11"
.SH NAME
Xnest \- a nested X server
.SH SYNOPSIS
.B Xnest
[-options]
.SH DESCRIPTION
\fIXnest\fP is a client and a server.  \fIXnest\fP is a client of the
real server which manages windows and graphics requests on its behalf.
\fIXnest\fP is a server to its own clients.  \fIXnest\fP manages
windows and graphics requests on their behalf.  To these clients
\fIXnest\fP appears to be a conventional server.
.SH OPTIONS
\fIXnest\fP supports all standard options of the sample server
implementation.  For more details, please see the manual page on your
system for \fIXserver\fP.  The following additional arguments are
supported as well.
.TP 4
.B \-display \fIstring\fP
This option specifies the display name of the real server that
\fIXnest\fP should try to connect with.  If it is not provided on the
command line \fIXnest\fP will read the \fIDISPLAY\fP environment
variable in order to find out the same information.
.TP 4
.B \-sync
This option tells \fIXnest\fP to synchronize its window and graphics
operations with the real server.  This is a useful option for
debugging, but it will slow down the performance considerably.  It
should not be used unless absolutely necessary.
.TP 4
.B \-full
This option tells \fIXnest\fP to utilize full regeneration of real
server objects and reopen a new connection to the real server each
time the nested server regenerates.  The sample server implementation
regenerates all objects in the server when the last client of this
server terminates.  When this happens, \fIXnest\fP by default
maintains the same top level window and the same real server
connection in each new generation.  If the user selects full
regeneration, even the top level window and the connection to the real
server will be regenerated for each server generation.
.TP 4
.B \-class \fIstring\fP
This option specifies the default visual class of the nested server.
It is similar to the \fI-cc\fP option from the set of standard options
except that it will accept a string rather than a number for the
visual class specification.  The string must be one of the following
six values: \fIStaticGray\fP, \fIGrayScale\fP, \fIStaticColor\fP,
\fIPseudoColor\fP, \fITrueColor\fP, or \fIDirectColor\fP.  If both,
\fI-class\fP and \fI-cc\fP options are specified, the last instance of
either option assumes precedence.  The class of the default visual of
the nested server need not be the same as the class of the default
visual of the real server; although, it has to be supported by the
real server.  See \fIxdpyinfo\fP for a list of supported visual
classes on the real server before starting \fIXnest\fP.  If the user
chooses a static class, all the colors in the default colormap will be
preallocated.  If the user chooses a dynamic class, colors in the
default colormap will be available to individual clients for
allocation.
.TP 4
.B \-depth \fIint\fP
This option specifies the default visual depth of the nested server.
The depth of the default visual of the nested server need not be the
same as the depth of the default visual of the real server; although,
it has to be supported by the real server.  See \fIxdpyinfo\fP for a
list of supported visual depths on the real server before starting
\fIXnest\fP.
.TP 4
.B \-sss
This option tells \fIXnest\fP to use the software screen saver.  By
default \fIXnest\fP will use the screen saver that corresponds to the
hardware screen saver in the real server.  Of course, even this screen
saver is software generated since \fIXnest\fP does not control any
actual hardware.  However, it is treated as a hardware screen saver
within the sample server code.
.TP 4
.B \-geometry \fIW+H+X+Y\fP
This option specifies geometry parameters for the top level
\fIXnest\fP windows.  These windows corresponds to the root windows of
the nested server.  The width and height specified with this option
will be the maximum width and height of each top level \fIXnest\fP
window.  \fIXnest\fP will allow the user to make any top level window
smaller, but it will not actually change the size of the nested server
root window.  As of yet, there is no mechanism within the sample
server implementation to change the size of the root window after
screen initialization.  In order to do so, one would probably need to
extend the X protocol.  Therefore, it is not likely that this will be
available any time soon.  If this option is not specified \fIXnest\fP
will choose width and height to be 3/4 of the dimensions of the root
window of the real server.
.TP 4
.B \-bw \fIint\fP
This option specifies the border width of the top level \fIXnest\fP
window.  The integer parameter must be a positive number.  The default
border width is 1.
.TP 4
.B \-name \fIstring\fP
This option specifies the name of the top level \fIXnest\fP window.
The default value is the program name.
.TP 4
.B \-scrns \fIint\fP
This option specifies the number of screens to create in the nested
server.  For each screen, \fIXnest\fP will create a separate top level
window.  Each screen is referenced by the number after the dot in the
client display name specification.  For example, \fIxterm -display
:1.1\fP will open an \fIxterm\fP client in the nested server with the
display number \fI:1\fP on the second screen.  The number of screens
is limited by the hard coded constant in the server sample code which
is usually 3.
.TP 4
.B \-install
This option tells \fIXnest\fP to do its own colormap installation by
bypassing the real window manager.  For it to work properly the user
will probably have to temporarily quit the real window manager.  By
default \fIXnest\fP will keep the nested client window whose colormap
should be installed in the real server in the
\fIWM\_COLORMAP\_WINDOWS\fP property of the top level \fIXnest\fP
window.  If this colormap is of the same visual type as the root
window of the nested server, \fIXnest\fP will associate this colormap
with the top level \fIXnest\fP window as well.  Since this does not
have to be the case, window managers should look primarily at the
\fIWM\_COLORMAP\_WINDOWS\fP property rather than the colormap
associated with the top level \fIXnest\fP window.  Unfortunately,
window managers are not very good at doing that yet so this option
might come in handy.
.SH USAGE 
Starting up \fIXnest\fP is as simple as starting up \fIxclock\fP from
a terminal emulator.  If a user wishes to run \fIXnest\fP on the same
workstation as the real server, it is important that the nested server
is given its own listening socket address.  Therefore, if there is a
server already running on the user's workstation, \fIXnest\fP will
have to be started up with a new display number.  Since there is
usually no more than one server running on a workstation, specifying
\fIXnest :1\fP on the command line will be sufficient for most users.
For each server running on the workstation the display number needs to
be incremented by one.  Thus, if you wish to start another
\fIXnest\fP, you will need to type \fIXnest :2\fP on the command line.
.PP
To run clients in the nested server each client needs to be given the
same display number as the nested server.  For example, \fIxterm
-display :1\fP will start up an \fIxterm\fP in the first nested server
and \fIxterm -display :2\fP will start an \fIxterm\fP in the second
nested server from the example above.  Additional clients can be
started from these \fIxterm\fPs in each nested server.
.SH XNEST AS A CLIENT
\fIXnest\fP behaves and looks to the real server and other real
clients as another real client.  It is a rather demanding client,
however, since almost any window or graphics request from a nested
client will result in a window or graphics request from \fIXnest\fP to
the real server.  Therefore, it is desirable that \fIXnest\fP and the
real server are on a local network, or even better, on the same
machine.  As of now, \fIXnest\fP assumes that the real server supports
the shape extension.  There is no way to turn off this assumption
dynamically.  \fIXnest\fP can be compiled without the shape extension
built in, and in that case the real server need not support it.  The
dynamic shape extension selection support should be considered in
further development of \fIXnest\fP.
.PP
Since \fIXnest\fP need not use the same default visual as the the real
server, the top level window of the \fIXnest\fP client always has its
own colormap.  This implies that other windows' colors will not be
displayed properly while the keyboard or pointer focus is in the
\fIXnest\fP window, unless the real server has support for more than
one installed colormap at any time.  The colormap associated with the
top window of the \fIXnest\fP client need not be the appropriate
colormap that the nested server wants installed in the real server.
In the case that a nested client attempts to install a colormap of a
different visual from the default visual of the nested server,
\fIXnest\fP will put the top window of this nested client and all
other top windows of the nested clients that use the same colormap
into the \fIWM\_COLORMAP\_WINDOWS\fP property of the top level
\fIXnest\fP window on the real server.  Thus, it is important that the
real window manager that manages the \fIXnest\fP top level window
looks at the \fIWM\_COLORMAP\_WINDOWS\fP property rather than the
colormap associated with the top level \fIXnest\fP window.  Since most
window managers appear to not implement this convention properly as of
yet, \fIXnest\fP can optionally do direct installation of colormaps
into the real server bypassing the real window manager.  If the user
chooses this option, it is usually necessary to temporarily disable
the real window manager since it will interfere with the \fIXnest\fP
scheme of colormap installation.
.PP
Keyboard and pointer control procedures of the nested server change
the keyboard and pointer control parameters of the real server.
Therefore, after \fIXnest\fP is started up, it will change the
keyboard and pointer controls of the real server to its own internal
defaults.  Perhaps there should be a command line option to tell
\fIXnest\fP to inherit the keyboard and pointer control parameters
from the real server rather than imposing its own.  This is a future
consideration.
.SH XNEST AS A SERVER
\fIXnest\fP as a server looks exactly like a real server to its own
clients.  For the clients there is no way of telling if they are
running on a real or a nested server.
.PP
As already mentioned, \fIXnest\fP is a very user friendly server when
it comes to customization.  \fIXnest\fP will pick up a number of
command line arguments that can configure its default visual class and
depth, number of screens, etc.  In the future, \fIXnest\fP should read
a customization input file to provide even greater freedom and
simplicity in selecting the desired layout.  Unfortunately, there is
no support for backing store and save under as of yet, but this should
also be considered in the future development of \fIXnest\fP.
.PP
The only apparent intricacy from the users' perspective about using
\fIXnest\fP as a server is the selection of fonts.  \fIXnest\fP
manages fonts by loading them locally and then passing the font name
to the real server and asking it to load that font remotely.  This
approach avoids the overload of sending the glyph bits across the
network for every text operation, although it is really a bug.  The
proper implementation of fonts should be moved into the \fIos\fP
layer. The consequence of this approach is that the user will have to
worry about two different font paths - a local one for the nested
server and a remote one for the real server - since \fIXnest\fP does
not propagate its font path to the real server.  The reason for this
is because real and nested servers need not run on the same file
system which makes the two font paths mutually incompatible.  Thus, if
there is a font in the local font path of the nested server, there is
no guarantee that this font exists in the remote font path of the real
server.  \fIXlsfonts\fP client, if run on the nested server will list
fonts in the local font path and if run on the real server will list
fonts in the remote font path.  Before a font can be successfully
opened by the nested server it has to exist in local and remote font
paths.  It is the users' responsibility to make sure that this is the
case.
.SH BUGS
Won't run well on servers supporting different visual depths.
Still crashes randomly.  Probably has some memory leaks.
.SH AUTHOR
Davor Matic, MIT X Consortium

