.\" Copyright 1994 NEC Corporation, Tokyo, Japan.
.\"
.\" Permission to use, copy, modify, distribute and sell this software
.\" and its documentation for any purpose is hereby granted without
.\" fee, provided that the above copyright notice appear in all copies
.\" and that both that copyright notice and this permission notice
.\" appear in supporting documentation, and that the name of NEC
.\" Corporation not be used in advertising or publicity pertaining to
.\" distribution of the software without specific, written prior
.\" permission.  NEC Corporation makes no representations about the
.\" suitability of this software for any purpose.  It is provided "as
.\" is" without express or implied warranty.
.\"
.\" NEC CORPORATION DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
.\" INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN
.\" NO EVENT SHALL NEC CORPORATION BE LIABLE FOR ANY SPECIAL, INDIRECT OR
.\" CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
.\" USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
.\" OTHER TORTUOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
.\" PERFORMANCE OF THIS SOFTWARE.

.\" $Id: canvert.man,v 1.2 1994/01/27 10:46:05 misao Exp $
.TH CANNASTAT 1
.SH "NAME"
canvert \- Convert files of old Canna version into new format
.SH "SYNOPSIS"
.B "canvert [\-d \fIdicnama\fP | \-c] \-o \fIold\fP \-n \fInew\fP"
[\-p] [\-t] [\-a]
.SH "DESCRIPTION"
\fIcanvert\fP converts the files of old Canna format into a new format.
.SH "OPTION"
.PP
.IP "\-d \fIdicname\fP" 12
Convert a binary format doctionary named \fIdicname\fP in a dictionary
file \fIold\fP into new binary format with a name \fInew\fP.
.IP "\-c"
Convert old format customizing file \fIold\fP into new format with a
name \fInew\fP.
.IP "\-o \fIold\fP"
To specify the old/source binary dictionary file name or customizing file name.
.IP "\-n \fInew\fP"
To specify the new/target file name.
.SH "EXAMPLE"
.IP (1) 4
.nf
% canvert -d iroha.mwd -o iroha.d -n canna.d
Converts old format binary dictionary iroha.mwd into new binary
dictionary canna.d.
.fi
.IP (2) 4
.nf
% canvert -c -o .iroha -n .canna
Converts old customizing file .iroha into .canna.
.fi
.SH "SEE ALSO"
.PP
dpbindic(1), dicar(1)
