char x9700xver[] = "@(#)x9700.c	1.2";		/* SCCS */

# include <stdio.h>


# define MAXLINES	140
# define MAXBUFS	(2*MAXLINES)
# define MAXWIDTH	160
# define MAXMASKS	10
# define ESC		033
# define REVLINE	-2
# define SUP		0
# define NORM		1
# define SUB		2
# define ERR		-1
# define PARAM		1
# define NOPARAM	0

# define FILES		0
# define HINDENT	1
# define LENGTH		2
# define MASK		3
# define LMASK		4
# define ORIENTATION	5
# define STYLE		6
# define T		7
# define VINDENT	8
# define PMASK		9
# define SIMPLEX	10
# define DUPLEX		11

# define NEL(x)		(sizeof(x)/sizeof(x[0]))

struct	buf
{
	int		font ;
	int		count ;
	char		line[MAXWIDTH] ;
	struct	buf	*next ;
} ;

struct	mask
{
	char		*name ;
	int		page_no ;
	char		orientation ;
} ;

char	fonts[] =
{
	'R' ,
	'I' ,
	'B' ,
	'L' ,
} ;

struct
{
	int	low ;
	int	high ;
} franges[4][6] =
/*	R	I	B	L	sub	sup	*/
{
	1,1,	2,2,	3,3,	5,5,	7,7,	8,8,
	1,4,	1,4,	1,4,	1,4,	1,4,	1,4,
	1,2,	1,2,	1,2,	1,2,	1,2,	1,2,
} ;

int	translit[256][3] =
{
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	'\b',   '\b',   '\b',
	'\t',   '\t',   '\t',
	'\n',   '\n',   '\n',
	' ' ,   ' ' ,   ' ' ,
	'\f',   '\f',   '\f',
	'\r',   '\r',   '\r',
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	' ' ,   ' ' ,   ' ' ,
	'!' ,   '!' ,   '!' ,
	'"' ,   '"' ,   '"' ,
	'#' ,   '#' ,   '#' ,
	'$' ,   '$' ,   '$' ,
	'%' ,   '%' ,   '%' ,
	'&' ,   '&' ,   '&' ,
	'\'' ,   '\'' ,   '\'' ,
	0xc7,   '(' ,   '(' ,
	0xce,   ')' ,   ')' ,
	'*' ,   '*' ,   '*' ,
	0xc8,   '+' ,   '+' ,
	',' ,   ',' ,   ',' ,
	0xd1,   '-' ,   '-' ,
	'.' ,   '.' ,   '.' ,
	'/' ,   '/' ,   '/' ,
	0xd8,   '0' ,   '0' ,
	0xd9,   '1' ,   0xbb,
	0xda,   '2' ,   0xbc,
	0xdb,   '3' ,   0xbd,
	0xdc,   '4' ,   '4' ,
	0xdd,   '5' ,   '5' ,
	0xde,   '6' ,   '6' ,
	0xdf,   '7' ,   '7' ,
	0xe0,   '8' ,   '8' ,
	0xe1,   '9' ,   '9' ,
	':' ,   ':' ,   ':' ,
	';' ,   ';' ,   ';' ,
	'<' ,   '<' ,   '<' ,
	'=' ,   '=' ,   '=' ,
	'>' ,   '>' ,   '>' ,
	'?' ,   '?' ,   '?' ,
	'@' ,   '@' ,   '@' ,
	'A' ,   'A' ,   'A' ,
	'B' ,   'B' ,   'B' ,
	'C' ,   'C' ,   'C' ,
	'D' ,   'D' ,   'D' ,
	'E' ,   'E' ,   'E' ,
	'F' ,   'F' ,   'F' ,
	'G' ,   'G' ,   'G' ,
	'H' ,   'H' ,   'H' ,
	'I' ,   'I' ,   'I' ,
	'J' ,   'J' ,   'J' ,
	'K' ,   'K' ,   'K' ,
	'L' ,   'L' ,   'L' ,
	'M' ,   'M' ,   'M' ,
	'N' ,   'N' ,   'N' ,
	'O' ,   'O' ,   'O' ,
	'P' ,   'P' ,   'P' ,
	'Q' ,   'Q' ,   'Q' ,
	'R' ,   'R' ,   'R' ,
	'S' ,   'S' ,   'S' ,
	'T' ,   'T' ,   'T' ,
	'U' ,   'U' ,   'U' ,
	'V' ,   'V' ,   'V' ,
	'W' ,   'W' ,   'W' ,
	'X' ,   'X' ,   'X' ,
	'Y' ,   'Y' ,   'Y' ,
	'Z' ,   'Z' ,   'Z' ,
	'[' ,   '[' ,   '[' ,
	'\\' ,   '\\' ,   '\\' ,
	']' ,   ']' ,   ']' ,
	'^' ,   '^' ,   '^' ,
	'_' ,   '_' ,   '_' ,
	'`' ,   '`' ,   '`' ,
	'a' ,   'a' ,   'a' ,
	'b' ,   'b' ,   'b' ,
	'c' ,   'c' ,   'c' ,
	'd' ,   'd' ,   'd' ,
	'e' ,   'e' ,   'e' ,
	'f' ,   'f' ,   'f' ,
	'g' ,   'g' ,   'g' ,
	'h' ,   'h' ,   'h' ,
	'i' ,   'i' ,   'i' ,
	'j' ,   'j' ,   'j' ,
	'k' ,   'k' ,   'k' ,
	'l' ,   'l' ,   'l' ,
	'm' ,   'm' ,   'm' ,
	'n' ,   'n' ,   0xc5,
	'o' ,   'o' ,   'o' ,
	'p' ,   'p' ,   'p' ,
	'q' ,   'q' ,   'q' ,
	'r' ,   'r' ,   'r' ,
	's' ,   's' ,   's' ,
	't' ,   't' ,   't' ,
	'u' ,   'u' ,   'u' ,
	'v' ,   'v' ,   'v' ,
	'w' ,   'w' ,   'w' ,
	'x' ,   'x' ,   'x' ,
	'y' ,   'y' ,   'y' ,
	'z' ,   'z' ,   'z' ,
	'{' ,   '{' ,   '{' ,
	'|' ,   '|' ,   '|' ,
	'}' ,   '}' ,   '}' ,
	'~' ,   '~' ,   '~' ,
	0177 , 0177 , 0177 ,
	0200 , 0200 , 0200 , 
	0201 , 0201 , 0201 , 
	0202 , 0202 , 0202 , 
	0203 , 0203 , 0203 , 
	0204 , 0204 , 0204 , 
	0205 , 0205 , 0205 , 
	0206 , 0206 , 0206 , 
	0207 , 0207 , 0207 , 
	0210 , 0210 , 0210 , 
	0211 , 0211 , 0211 , 
	0212 , 0212 , 0212 , 
	0213 , 0213 , 0213 , 
	0214 , 0214 , 0214 , 
	0215 , 0215 , 0215 , 
	0216 , 0216 , 0216 , 
	0217 , 0217 , 0217 , 
	0220 , 0220 , 0220 , 
	0221 , 0221 , 0221 , 
	0222 , 0222 , 0222 , 
	0223 , 0223 , 0223 , 
	0224 , 0224 , 0224 , 
	0225 , 0225 , 0225 , 
	0226 , 0226 , 0226 , 
	0227 , 0227 , 0227 , 
	0230 , 0230 , 0230 , 
	0231 , 0231 , 0231 , 
	0232 , 0232 , 0232 , 
	0233 , 0233 , 0233 , 
	0234 , 0234 , 0234 , 
	0235 , 0235 , 0235 , 
	0236 , 0236 , 0236 , 
	0237 , 0237 , 0237 , 
	0240 , 0240 , 0240 , 
	0241 , 0241 , 0241 , 
	0242 , 0242 , 0242 , 
	0243 , 0243 , 0243 , 
	0244 , 0244 , 0244 , 
	0245 , 0245 , 0245 , 
	0246 , 0246 , 0246 , 
	0247 , 0247 , 0247 , 
	0250 , 0250 , 0250 , 
	0251 , 0251 , 0251 , 
	0252 , 0252 , 0252 , 
	0253 , 0253 , 0253 , 
	0254 , 0254 , 0254 , 
	0255 , 0255 , 0255 , 
	0256 , 0256 , 0256 , 
	0257 , 0257 , 0257 , 
	0260 , 0260 , 0260 , 
	0261 , 0261 , 0261 , 
	0262 , 0262 , 0262 , 
	0263 , 0263 , 0263 , 
	0264 , 0264 , 0264 , 
	0265 , 0265 , 0265 , 
	0266 , 0266 , 0266 , 
	0267 , 0267 , 0267 , 
	0270 , 0270 , 0270 , 
	0271 , 0271 , 0271 , 
	0272 , 0272 , 0272 , 
	0273 , 0273 , 0273 , 
	0274 , 0274 , 0274 , 
	0275 , 0275 , 0275 , 
	0276 , 0276 , 0276 , 
	0277 , 0277 , 0277 , 
	0300 , 0300 , 0300 , 
	0301 , 0301 , 0301 , 
	0302 , 0302 , 0302 , 
	0303 , 0303 , 0303 , 
	0304 , 0304 , 0304 , 
	0305 , 0305 , 0305 , 
	0306 , 0306 , 0306 , 
	0307 , 0307 , 0307 , 
	0310 , 0310 , 0310 , 
	0311 , 0311 , 0311 , 
	0312 , 0312 , 0312 , 
	0313 , 0313 , 0313 , 
	0314 , 0314 , 0314 , 
	0315 , 0315 , 0315 , 
	0316 , 0316 , 0316 , 
	0317 , 0317 , 0317 , 
	0320 , 0320 , 0320 , 
	0321 , 0321 , 0321 , 
	0322 , 0322 , 0322 , 
	0323 , 0323 , 0323 , 
	0324 , 0324 , 0324 , 
	0325 , 0325 , 0325 , 
	0326 , 0326 , 0326 , 
	0327 , 0327 , 0327 , 
	0330 , 0330 , 0330 , 
	0331 , 0331 , 0331 , 
	0332 , 0332 , 0332 , 
	0333 , 0333 , 0333 , 
	0334 , 0334 , 0334 , 
	0335 , 0335 , 0335 , 
	0336 , 0336 , 0336 , 
	0337 , 0337 , 0337 , 
	0340 , 0340 , 0340 , 
	0341 , 0341 , 0341 , 
	0342 , 0342 , 0342 , 
	0343 , 0343 , 0343 , 
	0344 , 0344 , 0344 , 
	0345 , 0345 , 0345 , 
	0346 , 0346 , 0346 , 
	0347 , 0347 , 0347 , 
	0350 , 0350 , 0350 , 
	0351 , 0351 , 0351 , 
	0352 , 0352 , 0352 , 
	0353 , 0353 , 0353 , 
	0354 , 0354 , 0354 , 
	0355 , 0355 , 0355 , 
	0356 , 0356 , 0356 , 
	0357 , 0357 , 0357 , 
	0360 , 0360 , 0360 , 
	0361 , 0361 , 0361 , 
	0362 , 0362 , 0362 , 
	0363 , 0363 , 0363 , 
	0364 , 0364 , 0364 , 
	0365 , 0365 , 0365 , 
	0366 , 0366 , 0366 , 
	0367 , 0367 , 0367 , 
	0370 , 0370 , 0370 , 
	0371 , 0371 , 0371 , 
	0372 , 0372 , 0372 , 
	0373 , 0373 , 0373 , 
	0374 , 0374 , 0374 , 
	0375 , 0375 , 0375 , 
	0376 , 0376 , 0376 , 
	0377 , 0377 , 0377 , 
} ;

char		*prog_name ;
int		font ;
struct	mask	mask[MAXMASKS] ;
int		mask_count ;
char		*format ;
float		hindent ;
char		*hunit ;
int		vindent ;
int		t ;
int		half_mode ;
int		findexes ;
int		page_length ;
int		upage_length ;
char		*orientation ;
char		*uorientation ;
char		*duplex ;
FILE		*fp ;
int		col ;
int		line_no ;
int		next_buf ;
int		state ;
int		shade ;
int		too_wide ;
int		did_files ;
struct	buf	*page[MAXLINES] ;
struct	buf	pool[MAXBUFS] ;

main(argc,argv)
int	argc ;
char	*argv[] ;
{
	static	struct
	{
		char	*name ;
		int	value ;
		int	param ;
        } tab[] =
	{
		"-1" ,	SIMPLEX ,	NOPARAM ,
		"-2" ,	DUPLEX ,	NOPARAM ,
		"-f" ,	FILES ,		PARAM ,
		"-h" ,	HINDENT ,	PARAM ,
		"-lk" ,	LMASK ,		PARAM ,
		"-l" ,	LENGTH ,	PARAM ,
		"-k" ,	MASK ,		PARAM ,
		"-o" ,	ORIENTATION ,	PARAM ,
		"-pk",	PMASK ,		PARAM ,
		"-s" ,	STYLE ,		PARAM ,
		"-T" ,	T ,		PARAM ,
		"-v" ,	VINDENT ,	PARAM ,
		"" ,	FILES ,		PARAM ,
	} ;
	int		i ;
	int		j ;
	int		k ;
	char		*style ;
	char		*param ;
	char		*file_name ;
	int		mask_page ;
	int		getline() ;
	char		*f_lookup() ;
	char		*m_lookup() ;
	char		*a2i() ;
	char		*a2f() ;

	prog_name = argv[0] ;
	hindent = 1.0 ;
	hunit = "POS" ;
	vindent = 0 ;
	uorientation = "" ;
	style = "vintage" ;
	t = 0 ;
	upage_length = 0 ;
	mask_count = 0 ;
	duplex = "NO" ;
	did_files = 0 ;

	for ( i=1 ; i<argc ; i++ )
	{
		for ( j=0 ; j<NEL(tab) ; j++ )
			if ( tab[j].param == PARAM )
			{
				if ( strncmp(tab[j].name,argv[i],strlen(tab[j].name)) == 0 )
				{
					if ( argv[i][strlen(tab[j].name)] == '\0' )
						if ( ++i < argc )
							param = argv[i] ;
						else
							error("missing parameter for %s\n",tab[j].name) ;
					else
						param = &argv[i][strlen(tab[j].name)] ;
					break ;
				}
			}
			else
				if ( strcmp(tab[j].name,argv[i]) == 0 )
					break ;

		switch(tab[j].value)
		{
			case DUPLEX :
				duplex = "YES" ;
				break ;

			case FILES :
				did_files = 1 ;
				if ( strcmp(tab[j].name,"-f") == 0  ||  param[0] != '-' )
					file_name = param ;
				else if ( strcmp(param,"-") == 0 )
					file_name = NULL ;
				else
					error("usage: %s [-1|-2] [-h horzindent] [-[p|l]k mask [n]] [-l pageleng] [-o orient] [-s style] [-T c] [-v vertindent] [[-f] file] ...\n",prog_name) ;
				format = f_lookup(style) ;
				process(file_name) ;
				break ;

			case HINDENT :
				param = a2f(param,&hindent) ;
				if ( strcmp(param,"c") == 0 )
					hunit = "CM" ;
				else if ( strcmp(param,"i") == 0 )
					hunit = "IN" ;
				else if ( strcmp(param,"") == 0 )
				{
					hunit = "POS" ;
					hindent += 1.0 ;
				}
				else
					error("bad horizontal indent specification: %s\n",param) ;
				break ;

			case LENGTH :
				if ( *a2i(param,&upage_length) != '\0' )
					error("bad page length specification: %s\n",param) ;
				if ( upage_length > MAXLINES )
					error("page length %d larger than max %d\n",upage_length,MAXLINES) ;
				break ;

			case MASK :
			case LMASK :
			case PMASK :
				if ( i+1 < argc  &&  *a2i(argv[i+1],&mask_page) == '\0' )
					i++ ;
				else
					mask_count = mask_page = 0 ;
				for ( k=0 ; k<mask_count ; k++ )
					if ( mask[k].page_no == mask_page )
						break ;
				if ( k == MAXMASKS )
					error("too many masks\n") ;
				if ( k == mask_count )
					mask_count++ ;
				mask[k].name = m_lookup(param) ;
				mask[k].page_no = mask_page ;
				mask[k].orientation = tab[j].value ;
				break ;

			case ORIENTATION :
				uorientation = param ;
				break ;

			case SIMPLEX :
				duplex = "NO" ;
				break ;

			case STYLE :
				style = param ;
				break ;

			case T :
				if ( strcmp(param,"X") == 0 )
					t = 1 ;
				else
					t = 0 ;
				break ;

			case VINDENT :
				if ( *a2i(param,&vindent) != '\0' )
					error("bad vertical indent specification: %s\n",param) ;
				break ;

			default :
				error("internal error\n") ;
		}
	}
	if ( did_files == 0 )
	{
		format = f_lookup(style,orientation) ;
		process(NULL) ;
	}
	printf(" *DJDETEST* FORMAT=PDE1,FORMS=NONE,MARGIN=(1,POS),DUPLEX=NO,FONTINDEX=NONE,DATA=(0,159),END,;\n") ;
	printf("A \n") ;
	exit(0) ;
}
int
get_char()
{
        static  char    tm[2][3][11] =
        {
/*             \n      D      U      B      R      I      L      X     ESC     SI     SO

/*  sup   */   'A' ,  'A' ,  'B' ,  'E' ,  'E' ,  'E' ,  'E' ,  'F' ,  'F' ,  'C' ,  'G' ,
/*  norm  */   'A' ,  'B' ,  'B' ,  'E' ,  'E' ,  'E' ,  'E' ,  'F' ,  'F' ,  'C' ,  'G' ,
/*  sub   */   'A' ,  'B' ,  'D' ,  'E' ,  'E' ,  'E' ,  'E' ,  'F' ,  'F' ,  'C' ,  'G' ,

/*  sup   */   SUP ,  NORM , NORM , SUP ,  SUP ,  SUP ,  SUP ,  SUP ,  SUP ,  SUP ,  SUP ,
/*  norm  */   NORM , SUP ,  SUB ,  NORM , NORM , NORM , NORM , NORM , NORM , NORM , NORM ,
/*  sub   */   SUB ,  NORM , NORM , SUB ,  SUB ,  SUB ,  SUB ,  SUB ,  SUB ,  SUB ,  SUB ,
        } ;
	int	oldstate ;
	int	action ;
	int	c ;
	int	i ;
	int	class ;

	while ( (c=fgetc(fp)) == ESC )
	{
		c = fgetc(fp) ;
		class = classf(c) ;
		oldstate = state ;
		action = tm[0][oldstate][class] ;
		state = tm[1][oldstate][class] ;
		switch(action)
		{
			case 'A' :
				c = REVLINE ;
				break ;

			case 'B' :
				continue ;

			case 'C' :
				shade++ ;
				continue ;

			case 'D' :
				c = '\n' ;
				break ;

			case 'E' :
				for ( i=0 ; i<NEL(fonts) ; i++ )
					if ( c == fonts[i] )
						break ;
				if ( i == NEL(fonts) )
					error("internal error: 0%o\n",c) ;
				font = i ;
				continue ;

			case 'F' :
				c = fgetc(fp) | 0200 ;
				break ;

			case 'G' :
				shade-- ;
				continue ;

			default :
				error("machine seized\n") ;
		}
		break ;
	}
	return(c) ;
}
putpage(page_no)
int	page_no ;
{
	int		line ;
	int		i ;
	int		carriage ;
	int		carr2 ;
	int		bottom ;
	int		low ;
	int		high ;
	int		findex ;
	struct	buf	*bufp ;
	char		*form_name() ;

	printf(" *DJDETEST* FORMAT=%s,FORMS=%s,MARGIN=(%.2f,%s),DUPLEX=%s,BOF=250,FONTINDEX=0,DATA=(1,159),END;\n",
	format,form_name(page_no),hindent,hunit,duplex) ;
	carr2 = 'A' ;
	for ( i=0 ; i<vindent ; i++ )
	{
		printf("%c1\n",carr2) ;
		carr2 = ' ' ;
	}
	for ( bottom=page_length-1 ; bottom>0 ; bottom-- )
		if ( page[bottom] != NULL )
			break ;
	for ( line=0 ; line<=bottom ; line++ )
	{
		carriage = carr2 ;
		if ( page[line] == NULL )
			printf("%c1\n",carriage) ;
		else
			for ( bufp=page[line] ; bufp!=NULL ; bufp=bufp->next )
			{
				low = franges[findexes][bufp->font].low ;
				high = franges[findexes][bufp->font].high ;
				for ( findex=low ; findex<=high ; findex++ )
				{
					printf("%c%X",carriage,findex) ;
					carriage = '+' ;
					for ( i=0 ; i<bufp->count ; i++ )
						putchar(bufp->line[i]) ;
					putchar('\n') ;
				}
			}
		carr2 = ' ' ;
	}
}
error(msg,v1,v2)
char	*msg ;
int	v1 ;
int	v2 ;
{
	fprintf(stderr,"%s: ",prog_name) ;
	fprintf(stderr,msg,v1,v2) ;
	exit(1) ;
}
classf(c)
int	c ;
{
	static	char	tab[] =
	{
		'\n' , 'D' , 'U' , 'B' , 'R' , 'I' , 'L' ,'X' , '\033' , '\017' , '\016' ,
	} ;
	int	i ;

	for ( i=0 ; i<NEL(tab) ; i++ )
		if ( c == tab[i] )
			return(i) ;
	error("unknown escape sequence: 0%o\n",c) ;
}
char *
m_lookup(p)
char	*p ;
{
	static	struct
	{
		char	*name ;
		char	*value ;
	} tab[] =
	{
		"blogo" ,	"BLOGO" ,
		"memop" ,	"MEMOP" ,
		"memov" ,	"MEMOV" ,
		"prin1" ,	"PRIN1" ,
		"prin2" ,	"PRIN2" ,
		"prin3" ,	"PRIN3" ,
		"sdisc" ,	"SDISC" ,
		"vgraf" ,	"VGRAF" ,
		"wdisc" ,	"WDISC" ,
		"wlogo" ,	"WLOGO" ,
		"bprop" ,	"BPROP" ,
		"bprno" ,	"BPRNO" ,
		"bprpv" ,	"BPRPV" ,
		"aprop" ,	"APROP" ,
		"aprco" ,	"APRCO" ,
		"arest" ,	"AREST" ,
		"spriv" ,	"SPRIV" ,
		"snotc" ,	"SNOTC" ,
		"none" ,	NULL ,
		"" ,		NULL ,
	} ;
	int	i ;

	for ( i=0 ; i<NEL(tab) ; i++ )
		if ( strcmp(tab[i].name,p) == 0 )
			return(tab[i].value) ;
	error("bad mask name: %s\n",p) ;
}
char *
f_lookup(p)
char	*p ;
{
	static	struct
	{
		char	*style ;
		char	*uorientation ;
		char	*orientation ;
		char	*format ;
		int	length ;
		int	half_mode ;
		int	findexes ;
	} tab[] =
	{
		"elit" ,	"" ,		"P" ,	"ELITP"	,	71 ,	0 ,	0 ,
		"elit" ,	"land" ,	"L" ,	"ELITL"	,	51 ,	0 ,	0 ,
		"elit" ,	"landscape" ,	"L" ,	"ELITL"	,	51 ,	0 ,	0 ,
		"elit" ,	"port" ,	"P" ,	"ELITP"	,	71 ,	0 ,	0 ,
		"elit" ,	"portrait" ,	"P" ,	"ELITP"	,	71 ,	0 ,	0 ,
		"elite"	,	"" ,		"P" ,	"ELITP"	,	71 ,	0 ,	0 ,
		"elite"	,	"land" ,	"L" ,	"ELITL"	,	51 ,	0 ,	0 ,
		"elite"	,	"landscape" ,	"L" ,	"ELITL"	,	51 ,	0 ,	0 ,
		"elite"	,	"port" ,	"P" ,	"ELITP"	,	71 ,	0 ,	0 ,
		"elite"	,	"portrait" ,	"P" ,	"ELITP"	,	71 ,	0 ,	0 ,
		"goth" ,	"" ,		"P" ,	"GOTHP"	,	66 ,	0 ,	0 ,
		"goth" ,	"land" ,	"L" ,	"GOTHL"	,	51 ,	0 ,	0 ,
		"goth" ,	"landscape" ,	"L" ,	"GOTHL"	,	51 ,	0 ,	0 ,
		"goth" ,	"port" ,	"P" ,	"GOTHP"	,	66 ,	0 ,	0 ,
		"goth" ,	"portrait" ,	"P" ,	"GOTHP"	,	66 ,	0 ,	0 ,
		"goth24" ,	"" ,		"P" ,	"GO24VP" ,	33 ,	0 ,	1 ,
		"goth24" ,	"land" ,	"L" ,	"GO24VL" ,	25 ,	0 ,	1 ,
		"goth24" ,	"landscape" ,	"L" ,	"GO24VL" ,	25 ,	0 ,	1 ,
		"goth24" ,	"port" ,	"P" ,	"GO24VP" ,	33 ,	0 ,	1 ,
		"goth24" ,	"portrait" ,	"P" ,	"GO24VP" ,	33 ,	0 ,	1 ,
		"gothic" ,	"" ,		"P" ,	"GOTHP"	,	66 ,	0 ,	0 ,
		"gothic" ,	"land" ,	"L" ,	"GOTHL"	,	51 ,	0 ,	0 ,
		"gothic" ,	"landscape" ,	"L" ,	"GOTHL"	,	51 ,	0 ,	0 ,
		"gothic" ,	"port" ,	"P" ,	"GOTHP"	,	66 ,	0 ,	0 ,
		"gothic" ,	"portrait" ,	"P" ,	"GOTHP"	,	66 ,	0 ,	0 ,
		"mini" ,	"" ,		"P" ,	"MINIP"	,	137 ,	0 ,	0 ,
		"mini" ,	"land" ,	"L" ,	"MINIL"	,	106 ,	0 ,	0 ,
		"mini" ,	"landscape" ,	"L" ,	"MINIL"	,	106 ,	0 ,	0 ,
		"mini" ,	"port" ,	"P" ,	"MINIP"	,	137 ,	0 ,	0 ,
		"mini" ,	"portrait" ,	"P" ,	"MINIP"	,	137 ,	0 ,	0 ,
		"pica" ,	"" ,		"P" ,	"PICAP"	,	66 ,	0 ,	0 ,
		"pica" ,	"land" ,	"L" ,	"PICAL"	,	51 ,	0 ,	0 ,
		"pica" ,	"landscape" ,	"L" ,	"PICAL"	,	51 ,	0 ,	0 ,
		"pica" ,	"port" ,	"P" ,	"PICAP"	,	66 ,	0 ,	0 ,
		"pica" ,	"portrait" ,	"P" ,	"PICAP"	,	66 ,	0 ,	0 ,
		"subsup" ,	"" ,		"P" ,	"SUBSUP" ,	71 ,	1 ,	0 ,
		"subsup" ,	"port" ,	"P" ,	"SUBSUP" ,	71 ,	1 ,	0 ,
		"subsup" ,	"portrait" ,	"P" ,	"SUBSUP" ,	71 ,	1 ,	0 ,
		"times14" ,	"" ,		"P" ,	"TR14P"	,	46 ,	0 ,	0 ,
		"times14" ,	"land" ,	"L" ,	"TR14L"	,	36 ,	0 ,	0 ,
		"times14" ,	"landscape" ,	"L" ,	"TR14L"	,	36 ,	0 ,	0 ,
		"times14" ,	"port" ,	"P" ,	"TR14P"	,	46 ,	0 ,	0 ,
		"times14" ,	"portrait" ,	"P" ,	"TR14P"	,	46 ,	0 ,	0 ,
		"times28" ,	"" ,		"P" ,	"TR28VP" ,	23 ,	0 ,	1 ,
		"times28" ,	"land" ,	"L" ,	"TR28VL" ,	18 ,	0 ,	1 ,
		"times28" ,	"landscape" ,	"L" ,	"TR28VL" ,	18 ,	0 ,	1 ,
		"times28" ,	"port" ,	"P" ,	"TR28VP" ,	23 ,	0 ,	1 ,
		"times28" ,	"portrait" ,	"P" ,	"TR28VP" ,	23 ,	0 ,	1 ,
		"vint" ,	"" ,		"P" ,	"VINTP"	,	71 ,	0 ,	0 ,
		"vint" ,	"land" ,	"L" ,	"VINTL"	,	55 ,	0 ,	0 ,
		"vint" ,	"landscape" ,	"L" ,	"VINTL"	,	55 ,	0 ,	0 ,
		"vint" ,	"port" ,	"P" ,	"VINTP"	,	71 ,	0 ,	0 ,
		"vint" ,	"portrait" ,	"P" ,	"VINTP"	,	71 ,	0 ,	0 ,
		"vint20" ,	"" ,		"P" ,	"VI20VP" ,	35 ,	0 ,	1 ,
		"vint20" ,	"land" ,	"L" ,	"VI20VL" ,	27 ,	0 ,	1 ,
		"vint20" ,	"landscape" ,	"L" ,	"VI20VL" ,	27 ,	0 ,	1 ,
		"vint20" ,	"port" ,	"P" ,	"VI20VP" ,	35 ,	0 ,	1 ,
		"vint20" ,	"portrait" ,	"P" ,	"VI20VP" ,	35 ,	0 ,	1 ,
		"vintage" ,	"" ,		"P" ,	"VINTP"	,	71 ,	0 ,	0 ,
		"vintage" ,	"land" ,	"L" ,	"VINTL"	,	55 ,	0 ,	0 ,
		"vintage" ,	"landscape" ,	"L" ,	"VINTL"	,	55 ,	0 ,	0 ,
		"vintage" ,	"port" ,	"P" ,	"VINTP"	,	71 ,	0 ,	0 ,
		"vintage" ,	"portrait" ,	"P" ,	"VINTP"	,	71 ,	0 ,	0 ,
		"xerox"	,	"" ,		"L" ,	"BELLL"	,	77 ,	0 ,	0 ,
		"xerox"	,	"land" ,	"L" ,	"BELLL"	,	77 ,	0 ,	0 ,
		"xerox"	,	"landscape" ,	"L" ,	"BELLL"	,	77 ,	0 ,	0 ,
		"xerox"	,	"port" ,	"P" ,	"BELLP"	,	99 ,	0 ,	0 ,
		"xerox"	,	"portrait" ,	"P" ,	"BELLP"	,	99 ,	0 ,	0 ,
		"xerox18" ,	"" ,		"L" ,	"XR18L" ,	34 ,	0 ,	2 ,
		"xerox18" ,	"land" ,	"L" ,	"XR18L" ,	34 ,	0 ,	2 ,
		"xerox18" ,	"landscape" ,	"L" ,	"XR18L" ,	34 ,	0 ,	2 ,
		"xerox18" ,	"port" ,	"P" ,	"XR18P" ,	44 ,	0 ,	2 ,
		"xerox18" ,	"portrait" ,	"P" ,	"XR18P" ,	44 ,	0 ,	2 ,
		"xrox" ,	"" ,		"L" ,	"BELLL"	,	77 ,	0 ,	0 ,
		"xrox" ,	"land" ,	"L" ,	"BELLL"	,	77 ,	0 ,	0 ,
		"xrox" ,	"landscape" ,	"L" ,	"BELLL"	,	77 ,	0 ,	0 ,
		"xrox" ,	"port" ,	"P" ,	"BELLP"	,	99 ,	0 ,	0 ,
		"xrox" ,	"portrait" ,	"P" ,	"BELLP"	,	99 ,	0 ,	0 ,
	} ;
	int	i ;

	for ( i=0 ; i<NEL(tab) ; i++ )
		if ( strcmp(tab[i].style,p) == 0  &&  strcmp(tab[i].uorientation,uorientation) == 0 )
		{
			if ( upage_length == 0 )
				page_length = tab[i].length ;
			else
				page_length = upage_length ;
			orientation = tab[i].orientation ;
			half_mode = tab[i].half_mode ;
			findexes = tab[i].findexes ;
			return(tab[i].format) ;
		}
	error("unsupported style/orientation combination: (%s/%s)\n",p,uorientation) ;
}
process(file_name)
char	*file_name ;
{
	int	c ;
	int	i ;
	int	page_no ;
	int	page_dirty ;
	FILE	*fopen() ;
	
	if ( file_name == NULL )
		fp = stdin ;
	else
	{
		fp = fopen(file_name,"r") ;
		if ( fp == NULL )
			error("can't open %s\n",file_name) ;
	}

	next_buf = 0 ;
	col = 0 ;
	line_no = 0 ;
	page_no = 1 ;
	for ( i=0 ; i<page_length ; i++ )
		page[i] = NULL ;
	page_dirty = 0 ;
	state = NORM ;
	font = 0 ;
	shade = 0 ;
	too_wide = 0 ;

	while ( (c=get_char()) != EOF )
	{
		page_dirty = 1 ;
		switch(c)
		{
			case '\b' :
				if ( col > 0 )
					col-- ;
				break ;

			case '\t' :
				do
				{
					if ( shade > 0 )
						put_shade() ;
					col++ ;
				} while ( col % 8 != 0 ) ;
				break ;

			case ' ' :
				if ( shade > 0 )
					put_shade() ;
				col++ ;
				break ;

			case '\r' :
				col = 0 ;
				break ;

			case '\n' :
				if ( t == 0 )
					col = 0 ;
				if ( ++line_no == page_length )
				{
					putpage(page_no) ;
					line_no = 0 ;
					page_no++ ;
					page_dirty = 0 ;
					next_buf = 0 ;
					for ( i=0 ; i<page_length ; i++ )
						page[i] = NULL ;
				}
				break ;

			case '\f' :
				putpage(page_no) ;
				line_no = 0 ;
				page_no++ ;
				page_dirty = 0 ;
				next_buf = 0 ;
				for ( i=0 ; i<page_length ; i++ )
					page[i] = NULL ;
				break ;

			case REVLINE :
				if ( --line_no < 0 )
					error("attempt to back off page\n") ;
				break ;

			default :
				if ( shade > 0 )
					put_shade() ;
				put_char(c) ;
				col++ ;
				break ;
		}
	}
	if ( page_dirty )
		putpage(page_no) ;

	if ( fp != stdin )
		fclose(fp) ;
		
	if ( too_wide == 1 )
		if ( file_name == NULL )
			warning("standard input wider than %d, line(s) truncated\n",MAXWIDTH) ;
		else
			warning("file %s wider than %d, line(s) truncated\n",file_name,MAXWIDTH) ;
}
put_char(c)
int	c ;
{
	int		loc_font ;
	struct	buf	*cur_buf ;

	if ( col >= MAXWIDTH )
	{
		too_wide = 1 ;
		return ;
	}
		
	switch(half_mode)
	{
		case 0 :
			loc_font = font ;
			c = translit[c][state] ;
		break ;

		case 1 :
			if ( state == SUB )
				loc_font = 4 ;
			else if ( state == SUP )
				loc_font = 5 ;
			else
				loc_font = font ;
			break ;

		default :
			error("internal error: %d\n",half_mode) ;
	}

	for ( cur_buf=page[line_no] ; cur_buf!=NULL ; cur_buf = cur_buf->next )
		if
		(
			loc_font == cur_buf->font  &&
			( col >= cur_buf->count  ||  cur_buf->line[col] == ' ' )
		)
			break ;
	if ( cur_buf == NULL )
	{
		if ( next_buf >= MAXBUFS )
			error("page too dense\n") ;
		cur_buf = &pool[next_buf] ;
		cur_buf->font = loc_font ;
		cur_buf->count = 0 ;
		cur_buf->next = page[line_no] ;
		page[line_no] = cur_buf ;
		next_buf++ ;
	}

	while ( col >= cur_buf->count )
		cur_buf->line[cur_buf->count++] = ' ' ;
	cur_buf->line[col] = c ;
}
put_shade()
{
	int	save_font ;
	int	save_state ;
	int	level ;
	static	int	tab[] =
	{
		'\0' ,
		0xe9 ,
		0xe8 ,
		0xc4 ,
	} ;

	level = shade ;
	if ( level > 0 )
	{
		save_font = font ;
		save_state = state ;
		font = 0 ;
		state = NORM ;
		if ( level >= NEL(tab) )
			level = NEL(tab) - 1 ;
		put_char(tab[level]) ;
		font = save_font ;
		state = save_state ;
	}
}
char *
form_name(page_no)
int	page_no ;
{
	int		i ;
	int		j ;
	static	char	buf[7] ;

	j = -1 ;
	for ( i=0 ; i<mask_count ; i++ )
		if ( mask[i].page_no == page_no  ||  mask[i].page_no == 0 )
			j = i ;
	if ( j == -1  ||  mask[j].name == NULL )
		return("NONE") ;
	switch(mask[j].orientation)
	{
		case PMASK :
			sprintf(buf,"%sP",mask[j].name) ;
			break ;

		case LMASK :
			sprintf(buf,"%sL",mask[j].name) ;
			break ;

		case MASK :
			sprintf(buf,"%s%s",mask[j].name,orientation) ;
			break ;

		default :
			error("internal error (bad mask orientation %d)\n",mask[j].orientation) ;
	}
	return(buf) ;
}
char	*
a2i(p,valp)
char	*p ;
int	*valp ;
{
	for ( *valp=0 ; '0'<=*p && *p<='9' ; ++p )
		*valp = 10 * *valp + *p - '0' ;
	return(p) ;
}
char	*
a2f(p,valp)
char	*p ;
float	*valp ;
{
	float	pot ;

	for ( *valp=0 ; '0'<=*p && *p<='9' ; ++p )
		*valp = 10 * *valp + *p - '0' ;
	if ( *p == '.' )
	{
		p++ ;
		for ( pot=0.1 ; '0'<=*p && *p<='9' ; ++p )
		{
			*valp += pot * (*p-'0') ;
			pot /= 10 ;
		}
	}
	return(p) ;
}
warning(msg,v1,v2,v3)
char	*msg ;
int	v1 ;
int	v2 ;
int	v3 ;
{
	fprintf(stderr,"%s: ",prog_name) ;
	fprintf(stderr,msg,v1,v2,v3) ;
}
