char rofxver[] = "@(#)roff.c	1.1";		/* SCCS */

#include <stdio.h>
#include "define.h"
#include "extern.h"

/*	Roff Text Formatter
	Author: M. D. McIlroy
	Additional contributions:
		R. A. Faulkner
		N-P. Nelson
		Molly Wagner
	Bell Telephone Laboratories
*/

char endlabel[4][Namewidth];
#define Fnlabel endlabel[0]
#define Iglabel endlabel[1]
#define Ixlabel endlabel[2]
#define Atlabel endlabel[3]

Roff(argv)  /* Here is the main program */
char **argv;
{
	InitRegs();
#ifdef LinePr
	if( Dev==Printer ) {Write(Form); Write('\n'); Wflush();}
#endif
	for( ; *argv && Roffopen(*argv); argv++) {
		while( Readline() )
			if( (Rawchar[1]&Ulmask)==Cc ) Control();
			else Text();
	}
	Break();
	Eject();
	Done(0);
	/*NOTREACHED*/
}

InitRegs()  /* Initialize registers */
{
#include <time.h>
	struct regvec *z;
	struct tm *times;
	long tvec;
	static char *Months[] = {
		"January", "February", "March", "April", "May", "June", "July",
		"August", "September", "October", "November", "December" };

	PnReg = Getreg("%");  /* page number register */
	LnReg = Getreg("#");  /* line number register */
	NlReg = Getreg("%#");	/* lines on page */
	time(&tvec);
	times = localtime(&tvec);
	Getreg("sec")->Value = times->tm_sec;
	Getreg("min")->Value = times->tm_min;
	Getreg("hour")->Value = times->tm_hour;
	Getreg("day")->Value = times->tm_mday;
	Getreg("mon")->Value = times->tm_mon + 1;
	z = Getreg("amon");	/* ascii month name */
	z->Style = 0;
	z->Rdef = Macalloc(strlen(Months[times->tm_mon]));
	strcpy((z->Rdef)->Dstring, Months[times->tm_mon]);
	Getreg("year")->Value = times->tm_year;
}

Roffopen(s)
char *s;
{
	FILE *file;
	if ( strcmp(s, "-") == 0)
		file = stdin;
	else {
		file = fopen(s, "r");
		if( !file ) {
			Cannot(s);
			return(0);
		}
	}
	Pushcall(file);
	return(1);
}

Control()
{
	short Req, i;
	char Lab[Namewidth];

	if( Nr<3 ) { Text(); return; }

	Deuline();

	Req = Request();

	if( Req==lit(e,n) || Req==lit(E,N) ) {
		Label(Lab);
		if( Labmatch(Lab,Ig) ) Ig = 0;
		if( Labmatch(Lab,Ix) ) Ix = 0;
	}

	if( Ig ) return;  /* Ignored input lines */
	if( Ix ) { Writex(); return; }  /* Index file */

	if( Rq>Ll ) {    /* save requests */
		if( Rqbuf==0 ) Rqbuf = (short *)Caloc(Rqmax+1,sizeof(*Rqbuf));
		for( i = 1; i<=3; i++ ) {
			if( NRq<Rqmax )
				Rqbuf[++NRq] = Rawchar[i];
			else Rqbuf[Rqmax-1] = Rqbuf[Rqmax] = '.'; }}

	Lab[0] = Rawchar[2];
	Lab[1] = SpTab(Rawchar[3])? 0 : Rawchar[3];
	Lab[2] = 0;
	if( Macro(Lab,false) ) return;  /* Case sensitive for user macros */
#define EITHERCASE(a) a|lit(\040,\040) /* ASCII only */
	DoControl(EITHERCASE(Req));  /* Case insensitive for built-in requests */
}

Request()
{
	return( Rawchar[2]<<BYTE | Rawchar[3] );
}
 
DoControl(Req)
short Req;
{
	short i;
	char Lab[Namewidth];
	struct diversion *div;

	switch( Req ) {

		case lit(a,b): abort(lit(A,B)); return;   /* abort */

		case lit(j,u):
		case lit(a,d): Break(); Ad = true; return;

		case lit(a,f): AsgnF(4); return;

		case lit(n,r):
		case lit(a,n): AsgnN(4); return;

		case lit(a,r): PnReg->Style = '1'; return;

		case lit(a,t): Label(At=Atlabel);
			if( At[0]!=Skip )
				Define();
			At = 0;
			return;

		case lit(b,c): Spcget(&Bch); return;

		case lit(b,f): Bf = Number(0); return;

		case lit(b,o):
#ifdef LinePr
			if (!x9700)
#endif
			 Oscnt = Min(Number(0),5); return;

		case lit(b,p): Break(); if( !Top ) Eject(); return;

		case lit(b,r): Break(); return;

		case lit(c,c): Spcget(&Cc); return;

		case lit(c,e): Break(); Ce = Number(0); return;

		case lit(c,o): Break(); Mcflush();
			Co = Number(Co); return;

		case lit(d,i): Break();
			Label(At=Atlabel);
			if(At[0]!=0) {
				div = (struct diversion *)Caloc(1,sizeof(struct diversion));
				div->Nextdiv = Div;
				Div = div;
				strncpy(Div->Lab,At,Namewidth);
				Div->Fna = Fn; Fn = 0;
				Div->Ncol = Ncol; Ncol = 1;
				Div->Nla = Nl; Nl = 0;
				Topbot();
				Top = Bottom = false;
			}
			At = 0;
			return;

		case lit(d,s): Linesp(2); return;

		case lit(e,f): Sethead(Ef); return;

		case lit(e,h): Sethead(Eh); return;

		case lit(e,n): if( Labmatch(Label(Lab),Fn) ) {
				Break();
				Exch();
			} else if(Div && Labmatch(Label(Lab),Div->Lab)) {
				Break();
				Enddiv();
			}
			return;

		case lit(e,p):  Break(); if( !Top || ((Np&1 ) !=0) ) {
				 NNp = (NNp+1)&-2; Eject();
			}
			return;

		case lit(f,i): Break(); Fi = true; return;

		case lit(f,l): fflush(otfile); return;

		case lit(f,n): if(Fn) return;
			for(div=Div; div!=0; div=div->Nextdiv)
				if(div->Fna)
					return;
			Exch();
			Label(Fn=Fnlabel);
			if( Fbuf==0 ) Fbuf = (char *)Caloc(Fsize+1,sizeof(*Fbuf));
			if( Char==0 ) Char = (short *)Caloc(2*Maxline+Slop+1,sizeof(*Char));
			Setdiv();
			return;

		case lit(f,o): Sethead(Of); Sethead(Ef); return;

		case lit(f,s): Sethead(Fs); return;

		case lit(h,c): Spcget(&Hych); return;

		case lit(h,e): Sethead(Oh); Sethead(Eh); return;

		case lit(h,p): Hp = Number(Hp); return;

		case lit(h,y): Hy = Number(Hy); return;

		case lit(i,c): Spcget(&Ich); return;

		case lit(i,g): Label(Ig=Iglabel); return;

		case lit(i,n): In = Number(In);
			if( Nc == 0 ) Un = In; return;

		case lit(i,x): Label(Ix=Ixlabel); return;

		/* case lit(j,u): see 'ad' */

		case lit(l,i): for( i = Number(0); i>0; i--)
				if( Readline() ) Text(); else break; return;

		case lit(l,l): El = Max(1,Number(El));
			if(Ncol==1) El1 = El;
			if( Nc==0 ) Ll = El; return;

		case lit(l,s): Linesp(Max(1,Number(Ls))); return;

		case lit(l,v): Leave(Number(0)); return;

		case lit(m,1): Margin(&Ma1); return;
		case lit(m,2): Margin(&Ma2); return;
		case lit(m,3): Margin(&Ma3); return;
		case lit(m,4): Margin(&Ma4); return;
		case lit(m,5): Margin(&Ma5); return;
		case lit(m,6): Margin(&Ma6); return;

		case lit(m,c): if(Div) return;
			Break(); Mcflush();
			/* Use single-column line length in El1
			   to determine column widths and offset, in such
			   a way as to right-justify right column if possible.
			*/
			Ncol = Max(1,Number(0));
			if (Ncol==1) {Ll = El = El1; return;}
			El = Max(1, (El1-4*(Ncol-1))/Ncol); /* 4 is nominal gutter width */
			Co = Max(1, (El1-El*Ncol)/(Ncol-1)) + El;
			Ll = El;
			if( Mcbuf==0 ) Mcbuf = (char *)Caloc(Mcsize+1,sizeof(*Mcbuf));
			Setdiv();
			return;

		case lit(m,g): Setmerge(); return;

		case lit(n,0): Break(); Lnt=0; return;
		case lit(n,1): Break(); Lnt=1; return;
		case lit(n,2): Break(); Lnt=2; Lno=0; return;

		case lit(n,e): Need(Number(0)); return;

		case lit(n,f): Break(); Fi = false; return;

		case lit(n,j):
		case lit(n,a): Break(); Ad = false; return;

		case lit(n,p): Nskip = Nrp+Number(0); return;

		case lit(n,u): Uf = false; return;

		case lit(o,c): Spcget(&Osch); return;

		case lit(o,f): Sethead(Of); return;

		case lit(o,h): Sethead(Oh); return;

		case lit(o,p):  Break(); if( !Top || ((Np&1)!=1) ) {
				NNp = (NNp&-2)+1; Eject();
			}
			return;

		case lit(p,a): Break(); NNp = Number(Np); Eject(); return;

		case lit(p,c): Spcget(&Pc); return;

		case lit(p,l): if( Div ) return;
			Pl = Number(Pl); Topbot(); return;

		case lit(p,n): Nskip = 0; return;

		case lit(p,o): Break(); Mcflush();
			Po = Number(Po); return;

		case lit(p,r): Rq = Number(Rq); return;

		case lit(p,s): Sq = Number(Sq); return;

		case lit(p,t): Npause = Number(0); return;

		case lit(q,c): Spcget(&Qch); return;

		case lit(r,o): PnReg->Style = 'i'; return;

		case lit(s,k): NNp = Number(NNp); return;

		case lit(s,o): if( Nr>4 ) Source();
			return;

		case lit(s,p): if(Search()=='-') Overlay();
			else SpReq(Number(0));
			return;

		case lit(s,s): Linesp(1); return;

		case lit(t,a): Tabset(); return;

		case lit(t,c): for( i=4; i<Nr && Rawchar[i]==' '; i++) ;
			if( Rawchar[i]==Tabpad ) return;
			Spcget(&Tch); return;

		case lit(t,i): Break(); Un = Number(In); return;

		case lit(t,r): Translate(); return;

		case lit(u,c): Spcget(&Ulch); return;

		case lit(u,f): Uf = true; return;

		case lit(u,l): Ul = Number(0); Us = false; return;

		case lit(u,s): Ul = Number(0); Us = true; return;

		case lit(w,s): Ws = Number(Ws); return;

		default: Text(); return;
	}
}

Text()
{
	short c,i;
	short Bc,Fflag;

	if( Ig ) return;  /* Ignoring input lines */
	if( Ix ) { Writex(); return; }  /* Index file */
	while( Nr>=1 && SpTab(Rawchar[Nr]) ) Nr--;
	Rawchar[++Nr] = ' ';
	while( Rawchar[1]==Form ) {
		Break(); if( !Top ) Eject();
		for( i = 1; i<Nr; i++ ) Rawchar[i] = Rawchar[i+1];
		if( --Nr<=1 ) return;
	}
	if( Nr<=1 ) { SpReq(1); return; }
	if( SpTab(Rawchar[1]) ) Break();
	for( i=Nc-1; i>0 && Rquote(Char[i]); i--) ;
	c = Char[i]&Ulmask;
	if( Nc>1 &&  (
		 c ==  '.' ||
		 c ==  '?' ||
		 c ==  '!' ||
		 c ==  ':'  )
		) Char[++Nc] = ' ';  /* extra blank after sentence */
	if( Seqno==0 ) Seqno = InLno;  /* input line number */
	c = Rawchar[1]&Ulmask;  /* check on underlining of first character */
	if( Uf && Width[c]==1 && c!=Hych ) Rawchar[1] |= Ulbit;
	if( Ul>0 || Bf>0 ) {
		Bc = ' ';
		for( i=1; i<Nr; i++ ) {
			c = Rawchar[i]&Ulmask;
			if( Ul>0 && ( (Us&&Width[c]==1) || Numeric(c) || Alpha(c) )
				&& c!=Hych && Bc!=Prefix ) Rawchar[i] |= Ulbit;
			if( Bf>0 && Width[c]==1 && !SpTab(c)
				&& c!=Hych && Bc!=Prefix ) Rawchar[i] |= Bfbit;
			Bc = c;
		}
		if( Ul>0 ) Ul--;
		if( Bf>0 ) Bf--;
	}
	i = Min(Nr,2*Maxline-Nc);
	if( Hych != Skip )
		Trnsl(Hych,Ohc,Rawchar+1,Nr);
	memcpy(Char+Nc+1,Rawchar+1,i*sizeof(*Char));
	Nc += i;
	Fflag = false;
	while( Char[Nc-1]==Form || (Fflag&&SpTab(Char[Nc-1])) ) {
		Nc--;
		Fflag = true;
	}
	Char[Nc] = ' ';    /* insurance */
	if( Ce > 0 ) Center();
	else if( Fi ) Fill();
	else Break();
	if( Seqno==0 && Nc!=0 ) Seqno = InLno;
	if( Fflag ) { Break(); if( !Top ) Eject(); }
}

Done(code)
{
	fclose(otfile);
	if(Divovfl) Errprint(".di", " overflowed\n");
	if(Mcovfl) Errprint(".mc", " overflowed\n");
	if(Fnovfl) Errprint(".fn", " overflowed\n");
	if(Atovfl) Errprint(".at", " overflowed\n");
	if (Online) mesg_rest();
	exit(code);
	/*NOTREACHED*/
}

Fatalerr(s1)
char *s1;
{
	Errprint(s1, ", can't continue\n");
	Done(1);
	/* NOTREACHED */
}

Errprint(s1, s2)
char *s1, *s2;
{
	cerror(s1);
	fputs(s2, stderr);
	++Error;
}
