char rawxver[] = "@(#)rawnl.c	1.1";		/* SCCS */

#include <stdio.h>
#include "define.h"
#include "extern.h"

/* Miscellaneous routines, alphabetic order */

Rawnl(n)
short n;
{
	if( Fn||Ncol==1 ) Nl += n;
	Pp = 0;
	while(n-- > 0) {Write('\n');}
}

Readline()
{
	register c;
	short Lineend=false, At_or_Ix=At||Ix;
	short Underline=false, Boldface=false, Ul_or_Bf=false;
	short LNr = 0, Ne = 0, LNe = 0;

	Nr = 0;
	do {
		c = Nextch(c);
		if( c==Eof || c==Ich ) {
			 c = Testchar(c);
			if( c==Eof ) return(false);
		}
		if( At_or_Ix ) {
			if( c=='\n' ) {
				Rawchar[++Nr] = ' ';
				break;
			}
			Rawchar[++Nr] = c;
			continue;
		}
		if(Special(c)) {  /* Fast test for all specials */
			switch(c) {
			default:
				if( c==Tch) goto casetab;
				else if( c==Bch ) {
					c = '\b';
					break;
				} else if( c==Ulch ) {
					Underline = !Underline;
					Ul_or_Bf = Underline|Boldface;
					continue; }
				else if( c==Osch ) {
					Boldface = !Boldface;
					Ul_or_Bf = Underline|Boldface;
					continue; }
				else break;
			case '\n':
				Lineend = true;
			casetab:
			case '\t':
				LNe = Ne = Dotab(LNr,Ne,LNe,Lineend);
				if( Lineend ) return(true);
				LNr = Nr;
				continue;
			case Prefix:	/* 1-char escapes only */
				Rawchar[++Nr] = c;
				c = Getrch(1);
				if( c==Eof ) return(false);
				Rawchar[++Nr] = c;
				continue;
			}
		}
		Rawchar[++Nr] = c;
		if( Ul_or_Bf ) {
			if(Width[c]==1 && !SpTab(c) && c !=Hych) {
				if(Underline) Rawchar[Nr] |= Ulbit;
				if(Boldface)  Rawchar[Nr] |= Bfbit;
			}
		}
		if( c!= Hych ) Ne += Width[c];
	} while( Nr<Maxline );
	return(true);
}

struct regvec *
Scanreg(Lvs)
short *Lvs;
{
	char Reg[Namewidth];

	Getname(Lvs,Reg);
	return(Reg[0]==0? 0: Getreg(Reg));
}

Search()
{
	short Junk = 4;

	return( Lsearch(&Junk) );
}

Setdiv()
{
	Fn_Dv_Mc = Fn || Div || Ncol>1;
}

Sethead(Hd)
struct header **Hd;
{
	short i=4,n,c,j,k,d;
	struct header *Head;

	n = Lnumber(0,&i);
	if(!( 1<=n && n<=Nhead )) n = 1;
	Head = Hd[n];
	if( Head==0 ) Head = Hd[n] = (struct header *)Caloc(1,sizeof(*Head));
	c = Lsearch(&i);
	j = k = 0;
	if( c!=Skip ) {
		i = i-1;
		while( j<4 && i<Nr && k<Maxline ) {
			d = Rawchar[i];
			if( d==c ) { j++; d = Quotemark; }
			else if( d=='%' ) d = Pagemark;
			Head->Ht[++k] = d; i++;
		}
	}
	if( j==k ) {
		cfree(Head,1,sizeof(*Head));
		Hd[n] = 0;
		return;
	}
	while( j++ < 4 )
		Head->Ht[++k] = Quotemark;
	Head->Hi = In;
	Head->Hl = El1; /* Use single col line length */
	Head->Hc = k;
}

Setmerge()
{
	short n;

	n = Max(1,Min(Number(0),Nmerge));
	if( !Readline() ) return;
	Detab();
	Domerge(n);
}

Source()
{
	short i,c;
	char filename[81], *str;
	FILE *Roffopen();
 
	Detab();
	str = filename;
	i=4;
	if( (c = Lsearch(&i))==Skip ) return;
	if ( c== '<' ) {
		str += sprintf(str, Pathname);
		i++;
	}
	for( i--; i<=Nr; i++) {
		if( SpTab(c=Rawchar[i]) || Width[c]!=1 || str>=filename+80 || c=='>' ) break;
		*str++ = c;
	}
	if (c == '>') c = Rawchar[++i];
	*str = 0;
	Roffopen(filename);
}
 
Space(n)
short n;
{
	short m,j,i;

	if( Top ) Heading();
	if( Ncol==1 || Fn ) {
		m = Nl + n + ( Fn&&Fnc==0? Ma5+Ma6: 0 ) + (Mclines+Ncol-1)/Ncol;
		if( m+Lv <= Bl ) { n += Lv; Lv=0; }
		if( m > Bl || /* room on page? in fn buffer? */
			Fn&&(Fnc+n+Max(Mc,Po+In+Nc)>=Fsize) ) {
			Eject(); return;
		}
		if( Fn&&Fnc==0 ) {
			j = Min(Ma5,Nhead);
			Rawnl(Ma5-j);
			for( i = j; i>=1; i-- ) Title(Fs[i]);
			Rawnl(Ma6);
		}
	}
	else {
		if( n+Mclines >= (Bl-Nl)*Ncol ) {
			Eject();
			return;
		}
	}
	Newline(n);
}

Spacing()
{
	short i = 0;

	do { Space(Ls-1);
		if( Mclines >= (Bl-Nl)*Ncol ) Eject();
		i=i+1;
	} while( Top && (i<3) );
}

Spcget(Chp)
short *Chp;
{
	register c = Search(), i;

	if( c==Cc && c!=Skip ) return;
	if( c==Skip ) Attrib[*Chp] &= ~SPEC;
	else Attrib[c] |= SPEC;
	for(i=0; i<NSpch; i++)
		if( c==Spch[i] ) Spch[i] = Skip;
	*Chp = c;
}

SpReq(n)
short n;
{
	short m;

	if( Fi && Ws>0 && Ce<=0 && !Bottom && !Fn && Ncol==1 ) {
		m = Ma4;
		if( Ma4>Ls ) Ma4 = Ma4-Ls;
		Topbot();
		BBreak();
		Ma4 = m;
		Topbot();
	}
	else BBreak();
	if( n>=0 ) {
		if( Top ) Heading();
		if( Bl>Nl ) Space(Min(n,Bl-Nl));
	}
	if( Fi && Ws>0 && Ce<=0 && !Top && !Fn && Ncol==1 && (Ws+1)*Ls+Nl>Bl
		&& Bl>Nl ) Space(Bl-Nl);
	if( Nl>=Bl ) Bottom = true;
}

Subst()   /* substitute contents of register */
{
	short c,i;
	struct regvec *z;
	char Reg[Namewidth+1];

	c = Getrch(1);
	if( c==Ich ) return(c);
	Labclear(Reg);
	if( c == '(' ) {  /* register name in parentheses */
		for( i=0; i<=Namewidth; i++ ) {
			c = Getrch(0);
			if( !NRchar(c) ) break;
			Reg[i] = c;
		}
		if( c != ')' ) Labclear(Reg);
	}
	else if( NRchar(c) ) Reg[0] = c;
	if( Reg[0]==0 ) return(c);
	z = Getreg(Reg);
	/* get as good a page or line number as possible */
	if( z==PnReg )
		z->Value = Nc>0&&Nl+Ls>Bl? NNp:Np;
	if( z==LnReg )
		z->Value = Nc>0? (Lnt!=2&&Nl+Ls>Bl?1:Lno+1): Lno;
	if( z==NlReg )
		z->Value = Nl;
	Macro(Reg,true);
	return(Eof);
}

Tabset()	/* Define tab settings */
{
	short i,j,n,c,Tmax;

	if( Tab==0 ) Tab = (char *)Caloc(Maxline+1,sizeof(*Tab));
	if( Search()!=Skip ) {  /* scan the .ta line for tab stops */
		for( j=1; j<=Maxline; j++ ) Tab[j] = ' ';
		for( j=4; j<Nr; j++ )  /* commas are the same as blanks */
			 if( Rawchar[j]==',' ) Rawchar[j]=' ';
		i = 4;
		n = c = Tmax = 0;
		while( i < Nr ) {
			n = Min(Lnumber(n,&i),Maxline);
			Tmax = Max(n,Tmax);
			c = Rawchar[i++];
			Tab[n] = Alpha(c)? c: 'l';
		}
		for( j = Tmax+1; j<=Maxline; j++ ) Tab[j] = 'l';
	}
	else {  /* use next input line as image of tab stops */
		for( i = 1; i<=Maxline; i++ ) Tab[i] = 'l';
		if( !Readline() ) return;
		Detab();
		for( i = 1; i<Nr; i++ ) Tab[i] = Rawchar[i];
	}
	Tab[1] = 'l';
}

Testchar(c)
register short c;
{
	for(;;) {
		if( c==EOF ) c = Eof;
		if( c==Eof ) if( Callstack ) c=Popup(); else break;
		if( c==Ich ) c = Subst();
		if( c!=Eof ) break;
		c = Nextch(c);
	}
	return(c);
}

Title(Head)
struct header *Head;
{
	short i,j,k,Ncp,h,d,c,Cond;
	short D[4];   /* D[i]==gap before ith subfield */
	short H[4];   /* H[i]==width of ith subfield */
	short Px[Nwidth+1];

	if( Head ) {
		i = 1;
		j = 0;
		H[1] = H[2] = H[3] = 0;
		PnReg->Value = Np;
		Ncp = Pagen(PnReg,Px);
		for( k = 1; k<=Head->Hc; k++ ) {
			 h = Head->Ht[k]&Ulmask;
			if( h==Quotemark ) j = j+1;
			else if( h==Pagemark ) H[j] += Ncp;
			else H[j] += Width[h];
		}
		d = Head->Hl - Head->Hi - H[2];
		D[1] = Head->Hi+Po;
		D[2] = H[2]>0? Max(0,d/2-H[1]): 0;
		D[3] = d - H[1] - D[2] - H[3];
		for( k = 1; k<=3; k++ ) {
			 /* avoid trailing blanks */
			Cond=true;
			for( j = k; j<=3; j++) if( H[j]>0 ) { Cond=false; break; }
			if( Cond ) break;
			for( j = 1; j<=D[k]; j++ )
				{Writeraw(' ');}
			while( i<Head->Hc ) {
				i = i+1;
				c = Head->Ht[i]&Ulmask;
				if( c == Quotemark ) break;
				if( c==Pagemark) for( j=1; j<=Ncp; j++)
					{Writeraw(Conv[Px[j]]);}
				else {Writeraw(Conv[c]);}
			}
		}
	}
	Rawnl(1);
}

Topbot()
{
	Bl = Div? 10000:
	   Max(Ma1+Ma2+Ls+Ma5+Ma6,   /* bottom line */
		Pl-Ma4-Ma3-(Ls1-1) - (Fn||Fnc!=0?  Ls2-1:0));
	Bottom = Nl>=Bl;
	Setdiv();
}

Translate()
{
	short i = 4,c,d;

	if( Lsearch(&i)==Skip ) return;
	i = i-1;
	while( i<Nr ) {
		c = Rawchar[i];
		if( Width[c]==1 )
			for(;;) { d = Rawchar[i+1];
				if( Width[d]==1 ) {
					Conv[c] = d;
					i += 2;
					break;
				}
				i++;
			}
		else i = i+1;
	}
}

Trnsl(a,b,lin,n)  /* Translate a into b everywhere in lin */
short a, b, *lin, n;
{
	register short *C1, *C2;

	C2 = lin+n;
	for( C1=lin; C1<C2; C1++ ) {
		if( *C1 == a ) *C1 = b;
	}
}

UlFlush()	/* Insert backspaces and chars for Italic */
{
	short i;

	for( i=0; i<Ulcount; i++ )
		{Writeraw('\b');}
	for( i=0; i<Ulcount; i++ )
		{Writeraw(Div?Ulbuf[i]:Conv[Ulbuf[i]]);}
	Ulcount = 0;
}

Wflush()	/* Move line in Wbuf to tty or Line Printer buffer */
{
	static short Ppos;
	register short *Chr;
	short *End = Wbuf+Wcount;

	for( Chr=Wbuf; Chr<End; Chr++ ) {
		if( *Chr&Bfbit ) {	/* Boldface */
			if( Bfcount >= Bfbsize ) BfFlush();
			Bfbuf[Bfcount++] = *Chr&Ulmask;
			*Chr &= Bfmask;
		}
		else if( Bfcount!=0 ) BfFlush();
		if( *Chr&Ulbit ) {	/* Italic (underline) */
			if( Ulcount >= Ulbsize ) UlFlush();
			Ulbuf[Ulcount++] = *Chr&Ulmask;
			*Chr = '_';
		}
		else if( Ulcount!=0 ) UlFlush();
		if( Mc ) {
			Ppos += Width[*Chr];
			if( Mc>=Ppos && SpTab((*Chr)) ) *Chr= Mg[0][Ppos]&Ulmask;
		}
		{Writeraw(Div?*Chr:Conv[*Chr]);}
	}
	Ppos = Pp;
	Wcount = 0;
}

Writex()	/* Write to Index file */
{
	short i;

	if( ixfile==0 ) return;
	Detab();
	for( i=1; i<Nr; i++) putc(Rawchar[i],ixfile);
	putc('\n',ixfile);
}
 
#ifdef LinePr
WriteLP(c) 	/* Put character in Line Printer buffer */
{
	if ( c != '\n' && lpos < LPLENGTH*3+2 ) {
		outbuf[lpos++] = c;
		return;
		}
	if (x9700 && lpos == 0)
		outbuf[lpos++] = ' '; /* Can't send empty line to X9700 */
	if (!x9700 && lpos>1 || x9700 && strncmp(outbuf, "*DJDETEST*", 10))
		/* Scan for overstrikes if non-null print line */
		FlushP();
	else
		/* Avoid font designation on DJDETEST */
		fputr(outbuf, lpos, otfile);
	lpos = 0;
	if( c!='\n' ) outbuf[lpos++]=c;
}

FlushP()	/* Print Line Printer line in proper font */
{
	int font, bscnt=0, i, istart=1, l, c;
	static struct { int cnt; char *S} str[] = {
		0, strI,
		0, strB,
		0, strO
		};
	char *s = outbuf;
 
	outbuf[lpos] = '\0';
	if (x9700) istart = 2; /* Leave room for X9700 font designation */

	i = istart;
 
	do {
		l = strbrk(s, "\b");
		if (l > LPLENGTH - i) l = LPLENGTH - i; /* watch output length */
		strncpy(strR+i, s, l); /* Regular (Roman) font */
		i += l;
		if ((s += l) >= outbuf+lpos || i>LPLENGTH) break; /* done with scan */
		if (bscnt == 0) /* If this is first backspace of call, initialize */
			for (font=0; font<3; font++) {
				str[font].cnt = 0;
				memset(str[font].S+istart, ' ', LPLENGTH-istart);
			}
		bscnt = strspn(s, "\b");
		i -= bscnt; s += bscnt; /* input moves forward, output backwards on backspace */
		if (strspn(strR+i, "_") == bscnt)
			font = 0; /* Overstruck underscore means Italic */
		else if (strncmp(strR+i, s, bscnt) == 0)
			font = 1; /* Overstrike by same text means Bold */
		else font = 2; /* otherwise, really overstrike */
		strncpy(str[font].S+i, s, bscnt); /* append to appropriate buffer */
		if (x9700 && font!=2)
			memset(strR+i, ' ', bscnt); /* Erase Roman if other used */
		i += bscnt; s += bscnt;
		str[font].cnt = i; /* high-water mark, this font */
	} while (s < outbuf+lpos && i<LPLENGTH);
 
	fputr(strR, i, otfile); /* always print Roman font */
	if (bscnt) /* nonzero if any other fonts */
		for (font=0; font<3; font++)
			if ((i = str[font].cnt) > istart) {
				/* I'd like to do fputr if I could:
				fputr(str[font].S, i, otfile); */
				putc('\b', otfile); /* first char is slew */
				for (l=1; l<i; l++) /* But must account for zero-width chars */
					putc( Width[c=strR[l]] ? str[font].S[l] : c, otfile);
				putc('\n', otfile);
			}
}
#endif
