char mainxver[] = "@(#)main.c	1.1";		/* SCCS */


#include <stdio.h>
#include "define.h"
#include "extern.h"

/* Main program, argument processor and initializers */

main(argc,argv)
char **argv;
{
	extern char **Roffargs();

	argv = Roffargs(argc,argv); /* Process command line options */
	Roff(argv); /* Call the real main program */
	/* NOTREACHED */
}

#ifdef unix
/* Command line option processor for UNIX
   Also, all system-dependent code is here
*/
#include <sys/types.h>
#include <sys/stat.h>
#include <signal.h>
 
extern char _sobuf[];
struct stat statb;
extern char *ttyname();
char Ttyname[32];
 
char **
Roffargs(argc,argv)
char **argv;
{
	FILE *tfile;
	int nfiles = 0, realfiles = 0;
	extern char *malloc();
	char **Files;

	Online = isatty(fileno(otfile));
	if (Online) tty = fopen("/dev/tty","r");
	mesg_off();
	setbuf(otfile,_sobuf);
	Files = (char**)malloc((argc+1)*sizeof(char*));
	for( ; argc>1; argv++,argc--) {
		if(*argv[1]=='-') {
			switch(argv[1][1]) {
			case 'x':	/* -x indexfile */
				if(argv[1][2]) 
					*argv[1] += 2;
				else if(argc>1)
					argc--,argv++;
				ixfile = fopen(argv[1],"w");
				if( !ixfile ) Cannot(argv[1]);
				continue;
			case 'm':	/* -mfile macrofile */
				Files[nfiles] = malloc(strlen(&argv[1][1])+strlen(Pathname)+1);
				strcpy(Files[nfiles],Pathname);
				strcat(Files[nfiles],&argv[1][1]);
				nfiles++;
				continue;
			case 'o':
				if(argv[1][2])
					Olist = &argv[1][2];
				continue;
			case 's':	/* -sn stop after each n pages printed */
				Stop = atoi(&argv[1][2]);
				if( Stop<=0 ) Stop = 1;
				continue;
			default:
				fputs(Roffname,stderr);
				fputs(" unknown option\n",stderr);
				continue;
			case 0:	/* argument is "-" for stdin */
				Files[nfiles++] = "-";
				continue;
			}
		} else {
			Files[nfiles++] = argv[1];
			realfiles++;
		}
	}
	if(!realfiles)
		Files[nfiles++] = "-";
	Files[nfiles] = 0;
	return(&Files[0]);
}

Interrupt()
{
	Done(1);
	/*NOTREACHED*/
}

mesg_off()
{
	strcpy(Ttyname,ttyname(fileno(otfile)));
	stat(Ttyname,&statb);
	if(Online)
		chmod(Ttyname,statb.st_mode&0444);
	signal(SIGINT,Interrupt);
	signal(SIGPIPE,Interrupt);
	signal(SIGTERM,Interrupt);
}

mesg_rest()
{
	chmod(Ttyname,statb.st_mode);
}

Cannot(s)
char *s;
{
	fputs(Roffname, stderr);
	fputs(s,stderr);
	fputs(" cannot open\n", stderr);
}

fprompt(prchrs)
char *prchrs;
{
	fputs(prchrs, stdout);
}

cerror(s)
char *s;
{
	fputs("Roff: ", stderr);
	fputs(s, stderr);
}
#endif
#ifdef gcos
/*
   Command line option processor for GCOS
   Also, all system-dependent code is here
   This version supports Common Environment Syntax;
   all command-line filenames and Roff requests
   are written to an in-memory stdin.
*/
#include <argscan.h>
#define MAC_FILE	"CC/SROFF/M%s"
#define BADEXIT	2

extern int x_btch;
int Runjob = 0, Nstr = 256, filearg;
char *rargv[] = { "-", NULL };
char *bargv[10] = {"jrun"}, **bargv1 = bargv+2;
FILE *mustopen();
char *Str, *MStr, *EndStr;

	char **
Roffargs(argc, argv)
	int argc;
	char **argv;
{
	extern void setindex(), setmacros(), setpause(), setrunjob(), setpage(),
		setquiet(),  setout(), setopt(), setjrun(), setolist();
	static struct Arg optstr[] = { /* Normal options for command line */
		"^ix=?*",	setindex,
		"^ot=?*",	setout,
		"+[0-9]*",	setpage,
		"^ol=?*",	setolist,
		"^-m?*",	setmacros,
		"^+m?*",	setmacros,
		"^m=*",	setmacros,
		"^+p*",	setpause,
		"^-p*",	setpause,
		"^p=*",	setpause,
		"^+q",	setquiet,
		"^-q",	setquiet,
		NULL
	};
	static struct Arg boptstr[] = { /* For & option only */
		"+[0-9]*",	setopt,
		"^ol=?*",	setopt,
		"^-m?*",	setopt,
		"^+m?*",	setopt,
		"^m=?*",	setopt,
		"^+q",	setquiet,
		"^-q",	setquiet,
		"^+r",	setrunjob,
		"^-r",	setrunjob,
		"^(*)",	setjrun,
		"???*=*",	setjrun,
		"-?*",	setjrun,
		NULL
	};
	char  *s, *insname(), **argv2=argv;
	extern int interrupt();
	int col=3, arglen;

	if ( !intss() ) x_btch = 0; /* Avoid & if already batch */
	signal(2,interrupt);
	if (x_btch) { /* Preparing JCL for batch only */
		if (inquire(stdout, _TTY))
			freopen(bargv[1] = "**sroff*", "w", stdout);
		fputs("$ :", stdout); /* Reconstruct command line as JCL comment */
		while(*argv2){
			arglen = strlen(*argv2) + 1;
			if ( col + arglen > 72 ) {
				col = 3;
				fputs("\n$ :", stdout);
			}
			fputs(*argv2++, stdout);
			putchar(' ');
			col += arglen;
		}
		putchar('\n');
		if (strncmp(strlwr(argv[0]), "srof", 4))
			fputs("$\tSELECT\tCC/TEST/SROFF\n", stdout);
		else
			fputs("$\tSELECT\tCC/COMMAND/SROFF\n", stdout);
		fputs("sroff\n", stdout);
	}
	else { /* Really running Roff, in TSS or batch */
		Str = MStr = malloc(Nstr); /* String for ".so"s */
		EndStr = MStr + Nstr;
	}
 
	argc = argscan(argc, argv, x_btch ? boptstr : optstr);
 
	while (--argc > 0) { /* Recast command-line arguments as ".xx text" */
		if (gmatch(*++argv, "??=*"))
			setopt(argv); /* Roff request */
		else { /* filename */
			if ((s = insname(*argv)) == NULL) continue;
			++filearg;
			if (x_btch)
				printf("%s\n", s);
			else {
				if (Str + strlen(s) + 6 >= EndStr) extStr();
				addStr(s);
			}
		}
	}
 
	if (filearg == 0) /* Were any source files specified */
		if (x_btch)
			Errprint("no source files.","\n");
		else	if (inquire(stdin, _TTY))
				addStr("*src");
			else addStr(inquire(stdin,_FILENAME));
	if (Error && !Runjob)
		exit(BADEXIT);
	if (x_btch) {
		if (bargv[1] == 0) exit(0); /* stdout captured */
		fclose(stdout);
		execv("jrun", bargv); /* Done, no return from here */
	}
	if (inquire(otfile, _TTY)) {
		Online = true;
		mesg_off();
 		if (Npause != 0) {
			if (Npause < 0) Npause = 0;
			prompt(""); /* BELL */
		}
	}
	if (!inquire(otfile,_TTY)) ckLP();
	freopen(MStr, "mr", stdin);
	return(rargv);
}

	void
setindex(argv)
	char **argv;
{
	ixfile = mustopen(*argv+3, "w");
}

	void
setpage()
{
	Fatalerr("+n not supported; type ol=m,n for pages m through n");
}

	void
setolist(argv)
	char **argv;
{
	Olist = *argv + 3;
}

	void
setopt(argv)
	char **argv;
{
	/* Roff: Recast "xx=text" option as ".xx text" */
	/* & option: just pass it on */
	register char *arg = *argv;
 
	if (x_btch)
		printf("%s\n", arg);
	else {
		if (Str + strlen(arg) + 2 >= EndStr) extStr();
		Str += sprintf(Str, ".%2.2s %s\n", arg, arg+3);
	}
}
 
	void
setjrun(argv)
	char **argv;
{
	*bargv1++ = *argv;
}

	void
setmacros(argv)
	char **argv;
{
	char macstr[120], *macname;
 
	macname = *argv+2; /* Skip over `-m' */
	if (Str + sprintf(macstr, MAC_FILE, macname) >= EndStr) extStr();
	if (tolower(macname[0]) == 'x') {
		if (tolower(macname[1]) == 'f') {
			x9700 = true;
			strR[1] = '6'; /* Regular font on X9700 */
			strO[1] = '6';
			strI[1] = '2'; /* Italic font */
			strB[1] = '3'; /* Boldface font */
			}
		}
	insname(macstr);
	addStr(macstr);
}

	void
setpause(argv)
	char **argv;
{
	if (intss() && inquire(stdout, _TTY)) {
		Npause = strtol(*argv+2, (char **)NULL, 10);
		if (Npause == 0)Npause = -1;
		tty = mustopen("","rt");
	}
}

	void
setquiet()
{
}

	void
setrunjob()
{
	++Runjob;
}

	void
setout(argv)
	char **argv;
{
	otfile = mustopen(*argv+3, "w");
}

	char *
insname(s)
	char *s;
{
	FILE *file;
	char *t = NULL;

	if (strcmp(s, "-") == 0)
		if (inquire(stdin, _TTY))
			Errprint("can't read terminal", "\n");
		else t = caddid(inquire(stdin, _FILENAME));
	else if (x_btch && !Runjob) { /* Validate file for batch*/
		if ((file = mustopen(s, "r")) != NULL) {
			t = caddid(inquire(file, _FILENAME));
			if (!inquire(file, _PERM))
				Errprint(s, " -- TSS temp file can't be passed to batch\n");
			fclose(file);
		}
	}
	else t = s; /* Just return argument */
	return (t);
}

	FILE *
mustopen(name, dir)
	char *name, *dir;
{
	FILE *file;

	if ((file = fopen(name, dir)) == NULL )
		Errprint(ffiler(name), "\n");
	return (file);
}
 
unsigned usersw = 0777777777777;
#define hold 0100000000
mesg_off() /* Suppress operator messages while Roffing */
{
	if (!x_btch && intss()) {
		usersw = csetsw(0) & hold;
		if (usersw == 0) csetsw(hold);
	}
}

mesg_rest()
{
	if (usersw == 0 && !x_btch && intss()) cretsw(hold);
}

interrupt()
{
	signal(2,interrupt);
	mesg_rest();
	exit(2);
}
	void
extStr()
{
	int i;
	/* Extend old command-line filename buffer */
 
	i = Str - MStr;
	MStr = realloc(MStr, Nstr *= 2 );
	Str = MStr + i;
	EndStr = MStr + Nstr;
}
 
	void
addStr(s)
	char *s;
{
	if (s != NULL && *s != '\0')
		Str += sprintf(Str, ".so %s\n", s);
}
 
ckLP(){ /* Check for Line Printer output format */
#include <iodef.c>
	SETF(otfile);
	if (strncmp(inquire(otfile,_FILENAME), "p*",2) == 0 || fcb->sysou) {
		Dev = Printer;
		Fudge = 2; /* can't use last 2 lines on MH printers */
		wrfn = WriteLP; /* This routine buffers output for rescan */
		}
}

cannot(s) /* Can't open file */
	char *s;
{
	Errprint(ffiler(s), "\n");
}
#endif
