char adjxver[] = "@(#)adjust.c	1.1";		/* SCCS */

#include <stdio.h>
#include "define.h"
#include "extern.h"

/* Miscellaneous routines, alphabetic order */

Adjust(Nc1,Ne1,Ns)  /* Nc,Ne,Ns = chars,elements,gaps */
short Nc1,Ne1,Ns;
{
	register short *Chr;
	short *End;
	short Pad,p;

	if( !Ad ) {
		memcpy(Wbuf+Wcount,Char+1,Nc1*sizeof(*Char));
		Wcount += Nc1;
		Pp += Ne1;
	}
	else {
		Dir = !Dir;
		Pad = Max(0,Ll-Un-Ne1);   /* total padding required */
		Pp += Ne1+Pad;
		if( Ns<=0 ) Ns = 1;   /* to avoid divide checks */
		End = Char+Nc1;
		for( Chr=Char+1; Chr<=End; Chr++) {
			Wwrite((*Chr));
			if( (*(Chr+1)&Ulmask)==' ' && (*Chr&Ulmask)!=' ' && Pad>0 && Chr<End ) {
				p = Dir? Pad/Ns: (Pad+Ns-1)/Ns;
				Pad -= p;
				while( p-- ) Wwrite(*(Chr+1));
				Ns--;
			}
		}
	}
}

AsgnF(s)	/* Assign Font style to register */
short s;
{
	struct regvec *z;
	short w;

	z = Scanreg(&s);
	if( z==0 ) Text();
	else {
		Makenum(z);
		w = 1;
		if( Lsearch(&s)!=Skip ) {
			s = s-1;
			while( Rawchar[s]=='0' ) { s++; w++; }
		}
		z->Style = Rawchar[s];
		z->Minwidth = Min(w,Nwidth);
	}
}

AsgnN(s)	/* Assign Numeric value to register */
short s;
{
	struct regvec *z;

	z = Scanreg(&s);
	if( z==0 ) Text();
	else {
		Makenum(z);
		z->Value = Lnumber(z->Value,&s);
		if( z==LnReg ) Lno = z->Value;
	}
}
 
BBreak()	/* Move output line to Wbuf */
{
	short i;

	if( Fi ) Fill();
	Dir = false;
	if( Nc==0 ) return;
	Spacing();
	Inblank(Un);
	for( i = 1; i<Nc; i++ ) {Write(Char[i]);}
	Newline(1);
	Un = In;
	Ll = El;
	Nc = 0;
}

BfFlush()	/* Insert backspaces and overstrikes for Boldface */
{
	short i,j;
	for( j=0; j<Oscnt; j++) {
		for( i=0; i<Bfcount; i++ )
			{Writeraw('\b');}
		for( i=0; i<Bfcount; i++ )
			{Writeraw(Div?Bfbuf[i]:Conv[Bfbuf[i]]);}
	}
	Bfcount = 0;
}

Blank(n)
short n;
{
	while( n-- > 0 ) {Write(' ');}
}
 
int *
Caloc(a,b)
{
	int *p;

	p = (int *)calloc(a,b);
	if ( p==NULL ) Fatalerr("Out of Space.");
	return (p);
}

Center()
{
	short i;
	short Ne = 0;

	for( i = 1; i<Nc; i++ ) Ne += Width[Char[i]&Ulmask];
	Spacing();
	Inblank(In+(Ll-In-Ne)/2);
	for( i = 1; i<Nc; i++ ) {Write(Char[i]);}
	Newline(1);
	Nc = 0;
	Ce--;
}

Define()	/* Define macro (user request) */
{
	short i = 0,j,c;
	struct regvec *z;
	struct macrodef *D;
	char Mbuf[Maxdef+1], Lab[Namewidth];

	z = Getreg(At);
	if( z->Style == 0 ) Macrel(z->Rdef);
	while( i<Maxdef && Readline() ) {
		Deuline();
		if( Rawchar[1]==Cc && Request()==lit(e,n) &&
			 Labmatch(z->Name,Label(Lab)) ) break;
		j=1;
		while( j<Nr && i<Maxdef ) {
			c = Rawchar[j++];
			if( c==Pc ) {
				c = Rawchar[j++];
				if( Numeric(c) ) Mbuf[i++] = Param;
			}
			Mbuf[i++] = c;
		}
		Mbuf[i++] = '\n';
	}
	if(i>=Maxdef) Atovfl = 1;
	if( i==0 ) i = 1;
	Mbuf[i-1] = Eof;
	z->Style = 0;
	D = Macalloc(i);
	z->Rdef = D;
	strncpy(D->Dstring,Mbuf,i);
	if( z==PnReg||z==LnReg ) Makenum(z);
}

Detab()	/* Assure string has no pseudo tabs */
{
	short i;
	for( i=1; i<Nr; i++ )
		if( ( Rawchar[i] &= Ulmask ) == Tabpad ) Rawchar[i] = ' ';
}

Deuline()
{
	short i;
	for( i=1; i<Nr; i++ )
		Rawchar[i] &= Ulmask;
}

Divert(c)
short c;
{
	if( Fn ) {
		if(Fnc < Fsize)
			Fbuf[++Fnc] = c;
		else	Fnovfl = 1;
	} else if( Div ) {
		if(Div->Nca < Divsize) 
			Div->Dstring[Div->Nca++] = c;
		else	Divovfl = 1;
	} else if( Ncol>1 ) {
		if(Mcc < Mcsize) {
			Mcbuf[++Mcc] = c;
			if( c=='\n' ) Mclines++;
		} else	Mcovfl = 1;
	} else if( Print ) {Writech(c);}
}

Domerge(n)
short n;
{
	short i,j;
	char *M,*Mu;

	if( Mg==0 ) { /* allocate space for merge patterns */
		Mg = (char **)Caloc(Nmerge+1,sizeof(*Mg));
		Mg[0] = (char *)Caloc(Maxline+1,sizeof(**Mg));  /* unioned patterns */
		for( i = 1; i<=Nmerge; i++ ) Mg[i] = 0; }
	if( Mg[n]==0 ) Mg[n] = (char *)Caloc(Maxline+1,sizeof(**Mg));
	i = 1;
	M = Mg[n];
	Mu = Mg[0];
	for( j=1; j<=Po+In; j++) if( i<Maxline ) M[i++] = ' ';
	for( j=1; j<Nr; j++) if( i<Maxline && Width[Rawchar[j]]==1 ) M[i++]=Rawchar[j];
	M[i] = Eof;
	for( j=0; j<=Maxline; j++ ) Mu[j] = ' ';
	Mc = 0;
	for( j=1; j<=Nmerge; j++ ) {  /*  form the union */
		M = Mg[j];
		i = 0;
		if( M ) for( i=1; M[i] != Eof; i++)
			if( Mu[i]==' ' ) Mu[i] = M[i];
		Mc = Max(Mc,i);
	}
	while( SpTab(Mu[Mc]) && Mc>0 ) Mc--;
	if( Nr<=1 ) { cfree(Mg[n],Maxline+1,sizeof(**Mg)); Mg[n]=0; }
}

Dotab(LNr,Ne,LNe,Lineend)
short LNr,Ne,LNe,Lineend;
{
	short i,j,L,F,t,Delta,G;

	if( Lineend ) while( Nr>=1 ) {
		switch( Rawchar[Nr] ) {
			case ' ':    Nr--; Ne--; continue;
			case Tabpad: LNr = 0;  }
		break;
	}
	if( Lineend && LNr==0 ) {   /* for speed only */
		Rawchar[++Nr] = ' ';
		return(Ne+1);
	}
	i = LNe+1;
	L = Ne-LNe;
	F = 0;
	t = Tab? Lcase[Tab[LNe+1]]: 'l';
	while( t==' ' || t=='r' &&i<Ne || t=='c'&&(i-L/2<=LNe) )
		t = Lcase[Tab[++i]];
	if( t=='r' ) F = i-L+1;
	else if( t=='c' ) F = i - L/2;
	else F = i;   /* Assume Tab[i]=='l' */
	Delta = F - LNe - 1;
	G = LNr + Delta;
	if( Delta>0 ) for(  j = Nr-LNr; j>=1; j-- )
		Rawchar[G+j] = Rawchar[LNr+j];
	for( j = 1; j<=Delta; j++ ) Rawchar[LNr+j] = Tabpad;
	Nr = Nr + Delta + 1;
	if( !Lineend || t=='r' || t=='c' ) for( j = G+1; j<Nr; j++ )
		if( Rawchar[j]==' ' ) Rawchar[j] = Tabpad;
	Rawchar[Nr] = Lineend? ' ': Tabpad;
	return(F + L);
}

Eject()	/* Finish off bottom of page, eject to new */
{
	short n,i,SavNcol;

	if( Div ) return;
	if( Fn ) { Exch(); Eject(); Exch(); return; }
	if( !Top ) {	/* Footnotes, footers always single column */
		if( Ncol>1 ) Mcflush();
		SavNcol = Ncol;
		Ncol = 1;
		Setdiv();
		Rawnl(Bl-Nl+Ls1-1);
		for( i = 1; i<=Fnc; i++ )
			{Writeraw(Fbuf[i]);}
		Fnc = 0;
		Topbot();
		if( Ma3>0 ) {
			n = Min(Ma3,Nhead);
			Rawnl(Pl-Nl-Ma4-n);
			for( i = n; i>=1; i-- )
				Title(Np%2==0? Ef[i]:Of[i]);
			}
#ifdef LinePr
		if( Dev==Printer ) {Write(Form); Write('\n'); Wflush();} else
#endif
		Rawnl(Pl-Nl); /* Space to bottom on tty */
		Ncol = SavNcol;
		Setdiv();
		Pause();  /*  for output to terminal */
	}
	Np = NNp++;
	Top = true;
	Bottom = false;
	Nl = 0;
}

Enddiv()
{
	struct regvec *z;
	struct diversion *div;

	z = Getreg(Div->Lab);
	if(z->Style==0) Macrel(z->Rdef);
	z->Style = 0;
	z->Rdef = Macalloc(Div->Nca);
	Div->Dstring[Div->Nca-1] = Eof;
	strncpy(z->Rdef->Dstring,Div->Dstring,Div->Nca);
	div = Div;
	Div = div->Nextdiv;
	Fn = div->Fna;
	Ncol = div->Ncol;
	Nl = div->Nla;
	Top = Nl==0;
	Topbot();
	cfree(div,1,sizeof(struct diversion));
}

Enterreg(z)
struct regvec *z;
{
	struct reglist *Bigger;
	short N,i,index;

	if( Nregs>=Maxregs ) {
		Bigger = (struct reglist *)Caloc(Maxregs+Moreregs,sizeof(*Bigger));
		for( i=0; i<Nregs; i++) {
			Bigger[i].namehash = Regist[i].namehash;
			Bigger[i].regptr   = Regist[i].regptr;
		}
		if( Regist ) cfree(Regist,Maxregs,sizeof(*Regist));
		Regist = Bigger;
		Maxregs += Moreregs;
	}
	N = Hash(z->Name);
	for( index=0; index<Nregs; index++) if( N <= Regist[index].namehash ) break;
	for( i=Nregs; i>index; i--) {
		Regist[i].namehash = Regist[i-1].namehash;
		Regist[i].regptr   = Regist[i-1].regptr;
	}
	Nregs++;
	if( N<02000 ) Nmacs++;
	Regist[index].namehash = N;
	Regist[index].regptr   = z;
	return;
}

Exch()   /* Exchange body and footnotes */
{
	struct Replicate X;

	X = Xtab;
	Xtab = Extab;
	Extab = X;
	Topbot();
}

Expand()  /* replaces Readch() for macro expansion */
{
	short c,Argq;
	register struct macrodef *D;
	register struct inputsource *z = Callstack; /* For speed only */

	D = z->Mdef;
	Argq = z->Argq;
	for(;;) {
		if( z->Argch ) {  /* we are in an argument */
			c = z->Call[z->Argch++]&Ulmask;
			if(c!='\n' && c!=(z->Quoted?Argq:' '))
				return(c);
			if(z->Quoted &&
			   (z->Call[z->Argch]&Ulmask)==Argq)
				return(z->Call[z->Argch++]);
			z->Argch = 0;
		}
		c = D->Dstring[z->Curch++]&Ulmask;
		if( c == Param )
			z->Argch = Findarg(D->Dstring[z->Curch++]-'0');
		else return(c);
	}
}

Fill()
{
	register c,i;
	short Ne,Ns,Nc1,Ne1;

	while( Un+Nc>=Ll && Nc>0 ) {
		Ne = Ns = Nc1 = Ne1 = 0;   /* Ne,Ns = elements,gaps */
		for( i=1; i<Nc; i++ ) {/* Nc1,Ne1 = characters,elements at last gap */
			c = Char[i];
			if( (Ne += Width[c&Ulmask]) < 0 ) Ne = 0;
			if( Un+Ne > Ll && Nc1 ) break;
			if( SpTab(Char[i+1]) && !SpTab(c) )
				if( Ad || Ne1<Ll-3 ) {   /* no tiny hanging words under Nj */
					if( Nc1 && (Char[Nc1+1]&Ulmask)==' ' ) Ns++;
					Nc1 = i;
					Ne1 = Ne;
			}
		}
		if( Un+Ne <= Ll ) return;
		if( Hy>0 ) Hypho(&Nc1, &Ne1, &Ns);
		Spacing();
		Inblank(Un);
		Adjust(Nc1,Ne1,Ns);
		Newline(1);
		while( (SpTab(c=Char[Nc1+1])||c==Ohc) && Nc1<Nc ) Nc1++;
		Nc -= Nc1;
		memcpy(Char+1,Char+1+Nc1,Nc*sizeof(*Char));
		Un = In;
		Ll = El;
	}
}

Findarg(n)
short n;
{
	short i,j,c,Quoted,Argq;
	char *Callp;

	if(Callstack->Call == 0) return(0);
	Callp = &Callstack->Call[1];
	Argq = Callstack->Argq;
	for(i=1; i<4&&*Callp!='\n'; i++)
		Callp++;
	for(j=1;;j++) {
		do c = *Callp++ & Ulmask; while(c==' ');
		if( c=='\n' ) return(0);
		Callstack->Quoted = Quoted = c==Argq;
		if(j>=n) return(Callp-Callstack->Call-!Quoted);
		do {
			c = *Callp++ & Ulmask;
			if( c=='\n' ) return(0);
			while(Quoted && c==Argq && (*Callp&Ulmask)==Argq)
				Callp++, c = *Callp++ & Ulmask;
		} while(c != (Quoted?Argq:' ') );
	}
}

struct regvec *
Findreg(Reg)	/* Search for register by hash on name */
char *Reg;
{
	short lower, upper, trial, M, N;

	N = Hash(Reg);
	lower=0;
	upper = (N<02000? Nmacs: Nregs) - 1;
	if( upper<0 ) return(0);
	while( lower<upper ) {
		trial = (lower+upper)/2;
		M = Regist[trial].namehash;
		if( N>M ) lower=trial+1;
		else if( N<M ) upper=trial-1;
		else lower=upper=trial;
	}
	while( lower>=0 && N==Regist[lower].namehash ) lower--;
	for( lower++; lower<Nregs && N==Regist[lower].namehash; lower++)
		if( Labmatch((Regist[lower].regptr)->Name,Reg) ) return( Regist[lower].regptr );
	return(0);
}

Getname(Lvs,Reg)
short *Lvs;

char *Reg;
{
	short c,i,j;
	Labclear(Reg);
	c = Lsearch(Lvs);
	if( c=='(' )  {  /* register name in parentheses */
		i = *Lvs; j = 0;
		while( (i<Nr) && (j<Namewidth) && NRchar(Rawchar[i]) ) {
			Reg[j++] = Rawchar[i++]; }
		if( Rawchar[i] != ')' )
			while (i<Nr && Rawchar[++i] != ')');
		*Lvs = i + 1;
		}
	else    /* register name is single character */
		if( NRchar(c) ) Reg[0] = c;
}

Getrch(r)  /* get-a-character, used recursively from Subst() */
short r;
{
	register c;

	do {
		c = Nextch(c);
		if( c==Eof ) if( Callstack ) c=Popup(); else break;
		if( c==Ich && r==0 ) c = Subst(); } while( c==Eof );
	return(c);
}

struct regvec *
Getreg(Reg)
char *Reg;
{
	struct regvec *z;
	short i;

	if( (z=Findreg(Reg))!=0 ) return(z);
	z = (struct regvec *)Caloc(1,sizeof(*z));
	Labclear(z->Name);
	for( i=0; i<Namewidth && Reg[i]; i++) z->Name[i] = Reg[i];
	z->Style = '1';
	z->Minwidth = 1;
	Enterreg(z);
	return(z);
}

Hash(str)
char *str;
{
	char *s;
	short H = 0;

	for( s=str; *s!=0 && s<str+Namewidth; s++) ;
	for( s--; s>=str; s--) H = (H<<2) ^ *s;
	return(H);
}

Heading()
{
	short i, SavNcol;

	if( Fn ) { Exch(); Heading(); Exch(); return; }
	SavNcol = Ncol;	/* Headings always in single column format */
	Ncol = 1;
	Setdiv();
	Print = Nskip<=Nrp;
	Print &= Otest();
	Nrp++;
	Rawnl(Ma1-Fudge);
	Nl = Ma1;  /* in case Fudge was nonzero */
	for( i = 1; i<=Min(Ma2,Nhead); i++ )
		Title(Np%2==0? Eh[i]:Oh[i]);
	Rawnl( Min(Ma1+Ma2,Bl)-Nl );
	Top = false;
	Ncol = SavNcol;
	Setdiv();
	Rawnl( Min(Lv,Bl-Nl) );
	Lv = 0;
	if( Lnt!=2 ) Lno=0;
}
