char mmlintver[] = "@(#)mmlint.c	1.2";		/* SCCS */


#include <stdio.h>

#define TRUE	1
#define	FALSE	0
#define SROFF	0	/* flag to say want sroff cmds */
#define	NROFF	1	/* flag to say want nroff cmds */
#define BOTH	2	/* flag to say nroff&sroff cmds*/
#define NCHDEF	'\\'	/* nroff char esacpe defalut   */
#define CONTROL '.'	/* control char default        */
#define BREAKCH '\''    /* break char default          */
#define NUMCMDS	220	/* number of total format cmds */
#define NUMREG	13	/* number of register names    */
#define USEDEF	200	/* number of user defined cmds */
#define SAME	0	/* both formatters are same    */
#define EQUIV	1	/* there is an equivalent in other formatter */
#define UNIQUE	2	/* there is no equivalent in other formatter */
#define ARGS	3	/* the arguments are different */
#define SCAN	4	/* the scanning of text input is effected */
#define SPECIAL 5	/* this command is  special    */
#define DIFF	6	/* means different in each formatter  */
#define REDEF	7	/* user redefined this command	      */
#define BLANK	1	/* care about blanks from getnext     */
#define NOBL	0	/* ignore blanks in getnext	      */	

FILE *fopen(), *fp;
int  equivfl = 0;	/* output flag for equiv mess */
int  noefl = 0;		/* output flag for no equiv   */
int  retract = FALSE;	/* flag to indicate char putback */	
char rechar;		/* retract char.		 */
char escape;		/* escape char.			 */
char cntrlch;		/* control char. default = '.'   */
char nobreak;		/* the no break control char     */
char qchar = '"';	/* quote char of arguments	 */
char *filename;		/* the file looking at.          */
int  typeflag;		/* the type of formatter conform */
int  linenum = 1;	/* the line # of file reading in */
int  firstcol = 1;	/* indicates at first column of  */
int  lastnew = 1;
int  endit = 0;		/* indicates eof found of file   */
int  firstdef = TRUE;	/* first .de in program		 */
int  firstslash = TRUE; /* first \ not in program yet    */
char defname[8];	/* name of def doing at time     */
char divname[8];	/* diverting def name */
char endname[8];	/* name of yy for .cm xx yy */
int  numuse = 0;	/* current num of user defined   */
int  defdoing = FALSE;  /* TRUE if soing .de or .am	 */
int  divert = FALSE;/* TRUE if doing a .di or .da    */


struct user {		/* this is where user defined commands are kept */
	char cmd[3];
	} usertab[USEDEF];

struct cmdtab {		/* all the sroff(/mm) and nroff(/mm) commands */
	char *cmdname;		/* the actual command name */
	int  cmdtype;		/* type of command S,N, B=both  */
	int  action;		/* the action to do.	   */
	char *cmdequiv;		/* the equivalent command if it exists  */
	} commands[NUMCMDS] = {
		{"! ",NROFF,UNIQUE},
		{". ",NROFF,SPECIAL},
		{"1C",BOTH,SAME},
		{"2C",BOTH,SAME},
		{"AA",SROFF,UNIQUE},
		{"AE",BOTH,SAME},
		{"AF",NROFF,UNIQUE},
		{"AL",BOTH,SAME},
		{"AS",BOTH,ARGS},
		{"AT",NROFF,UNIQUE},
		{"AU",BOTH,ARGS},
		{"AV",BOTH,SAME},
		{"B ",BOTH,ARGS},
		{"BE",NROFF,UNIQUE},
		{"BI",NROFF,UNIQUE},
		{"BL",BOTH,SAME},
		{"BR",NROFF,UNIQUE},
		{"BS",NROFF,UNIQUE},
		{"CS",NROFF,UNIQUE},
		{"DE",BOTH,SAME},
		{"DF",NROFF,UNIQUE},
		{"DL",BOTH,SAME},
		{"DS",BOTH,ARGS},
		{"EC",NROFF,UNIQUE},
		{"EF",BOTH,SAME},
		{"EH",BOTH,SAME},
		{"EN",NROFF,UNIQUE},
		{"EQ",NROFF,UNIQUE},
		{"EX",NROFF,UNIQUE},
		{"FC",BOTH,ARGS},
		{"FE",BOTH,SAME},
		{"FG",NROFF,UNIQUE},
		{"FS",BOTH,SAME},
		{"H ",BOTH,ARGS},
		{"HC",NROFF,UNIQUE},
		{"HM",NROFF,UNIQUE},
		{"HU",BOTH,SAME},
		{"HX",NROFF,UNIQUE},
		{"HY",NROFF,UNIQUE},
		{"HZ",NROFF,UNIQUE},
		{"I ",BOTH,ARGS},
		{"IB",NROFF,UNIQUE},
		{"IR",NROFF,UNIQUE},
		{"LB",NROFF,UNIQUE},
		{"LC",NROFF,UNIQUE},
		{"LE",BOTH,SAME},
		{"LI",BOTH,ARGS},
		{"MC",SROFF,UNIQUE},
		{"MF",SROFF,UNIQUE},
		{"ML",BOTH,SAME},
		{"MT",BOTH,ARGS},
		{"ND",BOTH,SAME},
		{"NE",BOTH,SAME},
		{"NS",BOTH,SAME},
		{"OF",BOTH,SAME},
		{"OH",BOTH,SAME},
		{"OK",NROFF,UNIQUE},
		{"OP",NROFF,UNIQUE},
		{"P ",BOTH,SAME},
		{"PF",BOTH,SAME},
		{"PH",BOTH,SAME},
		{"PM",NROFF,UNIQUE},
		{"PX",NROFF,UNIQUE},
		{"R ",BOTH,SAME},
		{"RB",NROFF,UNIQUE},
		{"RD",NROFF,UNIQUE},
		{"RF",NROFF,UNIQUE},
		{"RI",NROFF,UNIQUE},
		{"RL",BOTH,SAME},
		{"RP",NROFF,UNIQUE},
		{"RS",NROFF,UNIQUE},
		{"S ",NROFF,UNIQUE},
		{"SA",BOTH,SAME},
		{"SG",BOTH,SAME},
		{"SK",NROFF,UNIQUE},
		{"SM",NROFF,UNIQUE},
		{"SP",NROFF,UNIQUE},
		{"TB",NROFF,UNIQUE},
		{"TC",NROFF,UNIQUE},
		{"TE",NROFF,UNIQUE},
		{"TH",NROFF,UNIQUE},
		{"TL",BOTH,ARGS},
		{"TM",BOTH,SAME},
		{"TP",NROFF,UNIQUE},
		{"TS",NROFF,UNIQUE},
		{"TX",NROFF,UNIQUE},
		{"TY",NROFF,UNIQUE},
		{"VL",BOTH,SAME},
		{"VM",NROFF,UNIQUE},
		{"WC",NROFF,UNIQUE},
		{"X ",SROFF,UNIQUE},
		{"ab",SROFF,SAME},
		{"ad ",NROFF,ARGS},
		{"af",BOTH,SAME},
		{"am",NROFF,SPECIAL},
		{"an",SROFF,EQUIV,"nr"},
		{"ar",SROFF,EQUIV,"af % 1"},
		{"as",NROFF,UNIQUE},
		{"at",SROFF,SPECIAL},
		{"bc",SROFF,UNIQUE},
		{"bd",NROFF,UNIQUE},
		{"bf",SROFF,UNIQUE},
		{"bo",SROFF,UNIQUE},
		{"bp",BOTH,ARGS},
		{"br",BOTH,SAME},
		{"c2",NROFF,SCAN},
		{"cc",BOTH,SCAN},
		{"ce",BOTH,SAME},
		{"cf",NROFF,UNIQUE},
		{"ch",NROFF,UNIQUE},
		{"co",BOTH,DIFF},
		{"cs",NROFF,UNIQUE},
		{"cu",NROFF,EQUIV,"us"},
		{"da",NROFF,SPECIAL},
		{"de",NROFF,SPECIAL},
		{"di",BOTH,SPECIAL},
		{"ds",BOTH,SPECIAL},
		{"dt",NROFF,UNIQUE},
		{"ec",NROFF,SCAN},
		{"ef",SROFF,UNIQUE},
		{"eh",SROFF,UNIQUE},
		{"el",NROFF,UNIQUE},
		{"em",NROFF,UNIQUE},
		{"en",SROFF,SPECIAL},
		{"eo",NROFF,SCAN},
		{"ep",SROFF,UNIQUE},
		{"ev",NROFF,UNIQUE},
		{"ex",NROFF,EQUIV,"ab"},
		{"fc",NROFF,UNIQUE},
		{"fi",BOTH,SAME},
		{"fl",BOTH,SAME},
		{"fn",SROFF,UNIQUE},
		{"fo",SROFF,UNIQUE},
		{"fp",NROFF,UNIQUE},
		{"fs",SROFF,UNIQUE},
		{"ft",NROFF,UNIQUE},
		{"hc",BOTH,SAME},
		{"he",SROFF,UNIQUE},
		{"hp",SROFF,UNIQUE},
		{"hw",NROFF,UNIQUE},
		{"hy",BOTH,ARGS},
		{"ic",SROFF,SCAN},
		{"ie",NROFF,UNIQUE},
		{"if",NROFF,UNIQUE},
		{"ig",BOTH,SPECIAL},
		{"in",BOTH,SAME},
		{"it",NROFF,UNIQUE},
		{"ix",SROFF,UNIQUE},
		{"ju",SROFF,EQUIV,"ad r"},
		{"lc",NROFF,UNIQUE},
		{"lg",NROFF,UNIQUE},
		{"li",SROFF,UNIQUE},
		{"ll",BOTH,SAME},
		{"ls",BOTH,SAME},
		{"lt",NROFF,UNIQUE},
		{"lv",SROFF,UNIQUE},
		{"m1",SROFF,UNIQUE},
		{"m2",SROFF,UNIQUE},
		{"m3",SROFF,UNIQUE},
		{"m4",SROFF,UNIQUE},
		{"m5",SROFF,UNIQUE},
		{"m6",SROFF,UNIQUE},
		{"mc",BOTH,DIFF},
		{"mg",SROFF,UNIQUE},
		{"mk",NROFF,UNIQUE},
		{"n0",SROFF,EQUIV,"nm"},
		{"n1",SROFF,EQUIV,"nm +1"},
		{"n2",SROFF,EQUIV,"nm +1"},
		{"na",BOTH,SAME},
		{"ne",BOTH,SAME},
		{"nf",BOTH,SAME},
		{"nh",NROFF,UNIQUE},
		{"nj",SROFF,EQUIV,"na"},
		{"nm",NROFF,ARGS},
		{"np",SROFF,UNIQUE},
		{"nr",BOTH,ARGS},
		{"ns",NROFF,UNIQUE},
		{"nu",SROFF,UNIQUE},
		{"nx",NROFF,SPECIAL},
		{"oc",SROFF,UNIQUE},
		{"of",SROFF,UNIQUE},
		{"oh",SROFF,UNIQUE},
		{"op",SROFF,UNIQUE},
		{"os",NROFF,UNIQUE},
		{"pa",SROFF,EQUIV,"bp"},
		{"pc",BOTH,DIFF},
		{"pi",NROFF,UNIQUE},
		{"pl",BOTH,SAME},
		{"pm",NROFF,UNIQUE},
		{"pn",NROFF,EQUIV,"sk"},
		{"po",BOTH,SAME},
		{"pr",SROFF,UNIQUE},
		{"ps",BOTH,DIFF},
		{"qc",SROFF,SPECIAL},
		{"rd",NROFF,UNIQUE},
		{"rm",NROFF,UNIQUE},
		{"rn",NROFF,UNIQUE},
		{"ro",SROFF,EQUIV,"af % i"},
		{"rr",NROFF,UNIQUE},
		{"rs",NROFF,UNIQUE},
		{"rt",NROFF,UNIQUE},
		{"sk",SROFF,EQUIV,"pn"},
		{"so",BOTH,SPECIAL},
		{"sp",BOTH,SAME},
		{"ss",BOTH,SPECIAL},
		{"sv",NROFF,UNIQUE},
		{"sy",NROFF,UNIQUE},
		{"ta",BOTH,SAME},
		{"tc",BOTH,DIFF},
		{"ti",BOTH,SAME},
		{"tl",NROFF,UNIQUE},
		{"tm",NROFF,UNIQUE},
		{"tr",BOTH,SAME},
		{"uc",SROFF,UNIQUE},
		{"uf",BOTH,DIFF},
		{"ul",BOTH,SAME},
		{"us",SROFF,EQUIV,"cu"},
		{"vs",NROFF,UNIQUE},
		{"wh",NROFF,UNIQUE},
		{"ws",SROFF,UNIQUE}
	       };

struct rtable {		/* the register that are checked (names) */
	char *rname;	/* the register name */
	int regtype;	/* the formatter the register name is in */
	int regact;	/* the action to do */
	char *regequiv;	/* the equivalent register name */
	} regtab[NUMREG] = {
		{"year",SROFF,EQUIV,"yr"},
		{"mon",SROFF,EQUIV,"mo"},
		{"day",SROFF,EQUIV,"dy"},
		{"yr",NROFF,EQUIV,"year"},
		{"mo",NROFF,EQUIV,"mon"},
		{"dy",NROFF,EQUIV,"day"},
		{"%",BOTH,SAME},
		{"#",SROFF,UNIQUE},
		{"%#",SROFF,UNIQUE},
		{"hour",SROFF,UNIQUE},
		{"sec",SROFF,UNIQUE},
		{"amon",SROFF,UNIQUE}
		};


/* this routine scans the input text, it calls routines if there is */
/* a command, or escape character	*/
scan()
{
	char	c;			/* for charcter class      */

	c = getnext(NOBL);
	while (!endit)
		{
		 if ((c == cntrlch) && firstcol) 
			 reccmd();
		 else if ((c == nobreak) && firstcol && (typeflag == SROFF))
			{
			 printf(" line %d:  %c:  is not recognized first column in sroff\n",
				linenum,nobreak);
			 reccmd();
			}
		 else if (c == escape) 
			 regfind();
		 c = getnext(NOBL);	
		 }
}

getnext(mode)	/* return the next char of the input */
int mode;	/* =1 if want to return blanks found */
{
	char c;

	if (lastnew)
	   firstcol = TRUE;
	   else firstcol = FALSE;
	if (retract)
	   { 
	     c = rechar;
	     retract = FALSE;
	    }
	else {
		if ((fscanf(fp,"%c",&c) == EOF))
		  endit = TRUE;
		else if (c == '\n')
			{
			 linenum++;
			 lastnew = TRUE;
			 }
		      else lastnew = FALSE;
	      }
	if (mode)
	    return(c);
	   else if (c == ' ')
		   return(getnext(NOBL));
		   else return(c);
 }


isletter(test)
char test;
{
	 if (test >= 'a' && test <='z' || test >= 'A' && test <= 'Z')
		return(TRUE);
		else return(FALSE);
}

ischarcmd(test)		/* if legal cahr in commands alpha, !, 1, 2 */
char test;
{
	if (test >= 'a' && test <= 'z' || test >= 'A' && test <= 'Z' ||
	    test == '!' || (test >= '1' && test <= '6') || test == '.' ||
	    (test == '$' && defdoing))
		return(TRUE);
		else return(FALSE);
}

/* this routine is called when a command name is to be found */
reccmd()
{
	int i;
	char c;
	char cmd[3];

	i = 0;
	c = getnext(BLANK);
	cmd[1] = ' ';
	cmd[2] = '\0';
	if (typeflag == SROFF)
	   {
            while ((i <= 1) && (ischarcmd(c))) {
            cmd[i] = c;
	    i++;
	    c = getnext(BLANK);
  	    }
    	if (!ischarcmd(c) && i <= 1 && !lastnew && c != ' ')
	   {
	    if (lastnew)
		printf(" line %d:  ",linenum-1);
		else printf(" line %d:  ",linenum);
  	    printf("%c:  illegal command name char in sroff\n",c);
 	    cmd[0] = '\0';
           }
            if (i == 2 && c != ' ' && c != '\n')
	       {
	        retract = TRUE;
	        rechar = c;
	       }
	   }
	else {	/* the type of command looking for is NROFF */
		cmd[0] = c;
		c = getnext(BLANK);
		if (c != ' ' && c != '\n')
		  {
		   cmd[1] = c;
		   c = getnext(NOBL);
		   if (c != '\n')
		      {
			retract = TRUE;
			rechar = c;
		      }
		   }
	     }
	checkcmd(cmd);
}

/* this routine checks the commands table to see what to do with the command */
checkcmd(actcmd)	/* this routine checks that the command is ok */
char actcmd[2];
{

	int spot;

	if ((spot = lookup(actcmd)) != -1)
	   {  /* then it is in the table at index "spot" */
	     if (commands[spot].action == SPECIAL)
		specdo(actcmd);
	     if (commands[spot].action == SCAN)
		scanfix(actcmd);
	     else if (commands[spot].cmdtype != typeflag)
		     {
	     		if (commands[spot].action == EQUIV)
				equivmess(actcmd,commands[spot].cmdequiv);
	     		if (commands[spot].action == ARGS)
				argcheck(actcmd);
	     		if (commands[spot].action == UNIQUE)
				noemess(actcmd);
			if (commands[spot].action == DIFF)
				diffmess(actcmd);
			if (commands[spot].action == REDEF)
				;
		      }
	    }
		/* the command is not predefined is it user defined ? */
        else if (!strcmp(actcmd,endname) && actcmd[0] != '\0')
               {
                if (typeflag == SROFF)
                putoutyy();
               }
	else if (actcmd[0] != '\0') 	/* check to see if user defined */
	    {
	     for (spot = 0;spot<numuse && strcmp(usertab[spot].cmd,actcmd); spot++);
	     if (spot == numuse && !defdoing)	/* not found */
		{
		 if (lastnew)
		    printf(" line %d:  ",linenum-1);
		    else printf(" line %d:  ",linenum);
		 printf("%c%s:  is not recoginzed by mm-lint\n",cntrlch,actcmd);
		}
	     }
}

lookup(thecmd)
char *thecmd;		/* the command lokking for in commands */
{
	int low, high, mid, cond;

	low = 0;
	high = NUMCMDS - 1;
	while (low <= high) {
		mid = (low+high) / 2;
		if ((cond = strcmp(thecmd,commands[mid].cmdname)) < 0)
		    high = mid - 1;
		else if (cond > 0)
		    low = mid + 1;
		else
		     return(mid);
		}
	return(-1);
}


/* when there is an equivalent command in the other formatter this routine is */
/* called to print out the message */
equivmess(old, new)
char *old, *new;
{
	equivfl++;
	if (lastnew)
	   printf(" line %d:  ",linenum-1);
	   else printf(" line %d:  ",linenum);
	printf("%c%s:  use %c%s in ",cntrlch,old,cntrlch,new);
	if (typeflag == SROFF)
	   printf("sroff\n");
	   else printf("nroff\n");
}

/* when a command has to have the arguments checked this routined is called */
argcheck(cmd)
char *cmd;
{
	char c;
	int paren;
	char regname[8];
	int numargs;

	if (!lastnew && !strcmp(cmd,"AS"))
	   {
	   printf(" line %d:  %cAS:  WARNING different meaning of values for arg1 for each formatter\n",
		   linenum,cntrlch);
	   if (typeflag == NROFF && argcount() > 2)
		printf(" line %d:  %cAS:  argument 3 is ignored by nroff/mm\n",
			linenum-1,cntrlch);
	   }
	else if ((typeflag == SROFF) && !strcmp(cmd,"AU") && argcount() > 6)
		 printf(" line %d:  %cAU:  args 7-9 are ignored by sroff/mm\n",
		         linenum-1,cntrlch);
	else if (!strcmp(cmd,"B ") || !strcmp(cmd,"I "))
		{
		 if (!lastnew && typeflag == SROFF && (numargs=argcount()) > 1)
		    printf(" line %d:  %c%s:  args 2-%d are ignored by sroff/mm\n",
		            linenum-1,cntrlch,cmd,numargs);
		}
	else if (!strcmp(cmd,"FC") && lastnew)
		printf(" line %d:  %cFC:  WARNING default closing differs for each formatter\n",
			linenum-1,cntrlch);
	else if ((typeflag == SROFF) && !strcmp(cmd,"H ") && argcount() > 2)
		printf(" line %d:  %cH:  ignores third argument in sroff/mm\n",
			linenum-1,cntrlch);
	else if ((typeflag == SROFF) && !strcmp(cmd,"LI") && argcount() > 1)
		printf(" line %d:  %cLI:  ignores second argument in sroff/mm\n",
		       linenum-1,cntrlch);
	else if (lastnew && !strcmp(cmd,"MT"))
		printf(" line %d:  %cMT:  WARNING default of type differs for each formatter\n",
			linenum-1,cntrlch);
	else if ((typeflag == NROFF) && !strcmp(cmd,"TL") && argcount() > 2)
		printf(" line %d:  %cTL:  ignores third argument in nroff/mm\n",
			 linenum-1,cntrlch);
	else if ((typeflag == SROFF) && !lastnew && !strcmp(cmd,"ad"))
		{
		 c = getnext(NOBL);
		 if ((c == 'R') || (c == 'B'))
		    equivmess(cmd,"ju");
		 else noemess(cmd);
		}
	else if ((typeflag == SROFF) && !lastnew && !strcmp(cmd,"bp"))
		equivmess("bp","pa");
	else if (!strcmp(cmd,"hy") && !lastnew)
	 	printf(" line %d:  %chy:  WARNING different meaning of values for arg1 for each formatter\n",
			linenum,cntrlch);
	else if ((typeflag == SROFF) && !strcmp(cmd,"nm"))
		{
		 if (lastnew)
		    equivmess("nm","n0");
		    else noemess("nm +/-n");
		 }
	 else if ((typeflag == SROFF) && !strcmp(cmd,"nr"))
		{
		paren = checkreg(regname,TRUE);
		if (argcount() > 1)
		    printf(" line %d:  %cnr:  ignores third argument in sroff\n",
			    linenum-1,cntrlch);
		}
	 else if ((typeflag == SROFF) && !lastnew && !strcmp(cmd,"DS"))
		 {
		  c = getnext(NOBL);
		  if (c == '3')
		     printf(" line %d:  3:  %cDS does not recognize in sroff/mm\n",
			      linenum,cntrlch);
		  else if (c == 'C')
			  {
			   c = getnext(NOBL);
			   if (c == 'B')
				printf(" line %d:  CB:  %cDS does not recognize in sroff/mm\n",
					linenum,cntrlch);
			  }
		   }
}

/* this function returns the number of argument on a line, it checks for */
/* the quote character- will not work for embedded quotes */
argcount()
{
	int num;
	char c;

	num = 0;
	while (!lastnew)
	      {
		num++;
		c = getnext(NOBL);
		if (c == qchar)
		   {
		    c = getnext(BLANK);
		    while (!lastnew && c != qchar)
			   c = getnext(BLANK);
		    c = getnext(BLANK);
		   }
		while ((c != ' ') && !lastnew)
			c = getnext(BLANK);
	      }
	 return(num);
}


/* this routine is called whne ther is no equivalent for the command */
noemess(cmd)
char *cmd;
{
	noefl++;
	if (lastnew)
	   printf(" line %d:  ",linenum-1);
	   else printf(" line %d:  ",linenum);
	printf("%c%s:  has no equivalent in ",cntrlch,cmd);
	if (typeflag == SROFF)
	   printf("sroff\n");
	   else printf("nroff\n");
}

/* this routine is called when a command has a different meaning in is formatter */
diffmess(cmd)
char *cmd;
{
	if (lastnew)
	   printf(" line %d:  ",linenum-1);
	   else printf(" line %d:  ",linenum);
	printf("%c%s:  WARNING there is a different meaning for each formatter\n",
		   cntrlch,cmd);
}

/* when diversions or defining is being done in nroff - it can end with .yy */
/* however, in sroff need to put out .en(defname) */
putoutyy()
{
       equivfl++;
       if (lastnew)
	  printf(" line %d:  ",linenum-1);
	  else printf(" line %d:  ",linenum);
       if (defdoing)
         {
          defdoing = FALSE;
          printf("%c%s:  use .en(%s) in sroff\n",cntrlch,endname,defname);
        }
       else printf("%c%s:  use .en (e) in sroff\n",cntrlch,endname);
}

/* this routine is called when the command effects the scanning of the */
/* input, for example .cc changes the control character. */
scanfix(cmd)
char *cmd;
{
	char c;
	char savec;

	if (!strcmp(cmd,"cc"))
	   {
	    if (lastnew)
		{
		 if (typeflag == SROFF)
		    cntrlch = CONTROL;
		    else cntrlch = '\0';
		printf(" line %d:  .cc:  WARNING different defaults with no ",
			linenum-1);
		printf("arguments\n");
		}
	    else cntrlch = getnext(NOBL);
	   }
	else if (!strcmp(cmd,"ec"))
		{ if (typeflag == SROFF)
			{
			 if (lastnew)
			    printf(" line %d:  %cec:  use %cic \\ in sroff\n",
				    linenum-1,cntrlch,cntrlch);
			    else equivmess(cmd,"ic");
			}
		  if (lastnew)
		     escape = NCHDEF;
		     else escape = getnext(NOBL);
		}
	else if (!strcmp(cmd,"eo"))
		{
		 if (typeflag == SROFF)
		    equivmess(cmd,"ic");
		 escape = '\0';
		}
	else if (!strcmp(cmd,"c2"))
		{
		 if (typeflag == SROFF)
		    noemess(cmd);
		 if (!lastnew)
		     nobreak = getnext(NOBL);
		 }
	else if (!strcmp(cmd,"ic"))
		{
		 if (lastnew)  /* turn it off */
		    {
		     escape = '\0';
		     if (typeflag == NROFF)
			equivmess(cmd,"eo");
		    }
		 else
		   {
		    savec = getnext(NOBL);
		    c = getnext(BLANK);
		    if (savec == escape && lastnew)
		       {
			escape = '\0';
			if (typeflag == NROFF)
			   equivmess(cmd,"eo");
		       }
		    else if (savec == escape && !lastnew)
			    {
			     escape = c;
			     if (typeflag == NROFF)
				{ equivfl++;
			     printf(" line %d:  %cic %c%c:  use %cec %c in nroff\n",
				     linenum-1,cntrlch,savec,c,cntrlch,c);
				}
			    }
		else if (savec != escape)
			{
			 escape = savec;
			 if (typeflag == NROFF)
			    equivmess(cmd,"ec");
			}
		}
		}
}

/* this is called for special commands (don't fit into other categories)*/
/* like the defining commands, diversions, .so and .nx */
/* when a command is defined, if it is redefining a predefined command */
/* the action field of commands is set to REDEF */
specdo(cmd)
char *cmd;
{
	char c;
	char reg[2];	/* register name if being used */
	int paren;
	int spot;

	reg[2] = '\0';
	if (!strcmp(cmd,"de"))
		{
		paren = findxx(defname);
		if ((spot = lookup(defname)) != -1)
		    {
		     commands[spot].action = REDEF;
		      numuse--;
		     }
		if (firstdef && typeflag == SROFF)
		   {
	     	    firstdef = FALSE;
		    if (lastnew)
			printf(" line %d:  ",linenum-1);
			else printf(" line %d:  ",linenum);
		    printf("WARNING must have command to set");
		    printf(" parameter character %cpc $\n",cntrlch);
		   }
		if (typeflag == SROFF)
		   equivmess(cmd,"at");
		defdoing = TRUE;
                findyy();
		}
	 else if ((typeflag == SROFF) && !strcmp(cmd,". "))
		{
		 equivfl++;
		 if (defdoing)
		    printf(" line %d:  ..:  use .en(%s) in sroff\n",
			    linenum-1,defname);
		 defdoing = FALSE;
		}
	 else if (!strcmp(cmd,"en"))
		 {
		  if (divert && typeflag == NROFF)
		     equivmess(cmd,"di");
		  if (!divert && typeflag == NROFF)
		     equivmess(cmd,".");
		  divert = FALSE;
		  defdoing = FALSE;
		  /* ignore up till nextline */
		  while (!lastnew)
			c = getnext(NOBL);
		 }
	 else if (!strcmp(cmd,"di") || !strcmp(cmd,"da"))
		 {
		  if (!strcmp(cmd,"da") && typeflag == SROFF)
		     noemess(cmd);
		  if (!lastnew)
		     {
		      paren = findxx(divname);
		      if (paren && typeflag == NROFF && divname[1] != '\0')
			 {
			  equivfl++;
			  if (lastnew)
			     printf(" line %d:  ",linenum-1);
			     else printf(" line %d:  ",linenum);
		          printf("(%s):  use %s in nroff\n",divname,divname);
			 }
		      divert = TRUE;
		     }
		  else {
			divert = FALSE;
			if (typeflag == SROFF)
			   { equivfl++;
			   printf(" line %d:  %c%s:  use .en (%s) in sroff\n",
				   linenum-1,cntrlch,cmd,divname);
			   }
		       }
		}
	 else if (!strcmp(cmd,"at"))
		{
		 paren = findxx(defname);
		 if ((spot = lookup(defname)) != -1)
		     {
			commands[spot].action = REDEF;
			numuse--;
		      }
		 defdoing = TRUE;
		 if (typeflag == NROFF)
		    {
		     if (paren && defname[1] != '\0')
			{
			 equivfl++;
			 if (lastnew)
			    printf(" line %d:  ",linenum-1);
			    else printf(" line %d:  ",linenum);
			printf("(%s):  use %s in nroff\n",defname,defname);
			}
		     equivfl++;
		     printf(" line %d:  %cat use either %cde or %cds in nroff\n",
			     linenum-1,cntrlch,cntrlch,cntrlch);
		    }
		}
         else if (!strcmp(cmd,"am"))
                {
                 if (typeflag == SROFF)
                    noemess(cmd);
                 paren = findxx(defname);
		 defdoing = TRUE;
                 findyy();
                }
          else if (!strcmp(cmd,"ig"))
                {
                 if (lastnew && typeflag == SROFF)
		    { equivfl++;
                    printf(" line %d:  %cig:  use %cig e (e is reg name) in sroff\n",
                            linenum-1,cntrlch,cntrlch);
		    }
                 else
		   {
		    paren = findxx(endname);
		    if (paren && typeflag == NROFF)
		       {
			equivfl++;
			if (lastnew)
			   printf(" line %d:  ",linenum-1);
			   else printf(" line %d:  ",linenum);
			printf("(%s):  use %s in nroff\n",endname,endname);
		       }
		   }
                }
	else if (!strcmp(cmd,"ds"))
		{
 		 if (lastnew && typeflag == NROFF)
    		     equivmess(cmd,"ls 2");
		 else if (typeflag == SROFF)
 			{
			 equivfl++;
      			 paren = findxx(reg);
  			 printf(" line %d:  %cds  %s string: use the following three lines in sroff\n",
     				  linenum,cntrlch,reg);
   			printf("\t %cat (%s)\n",cntrlch,reg);
			printf("\t string\n");
			printf("\t %cen (%s)\n",cntrlch,reg);
			/* ignore string from processing */
			while (!lastnew)
			      c = getnext(NOBL);
			}
		}
	else if (!strcmp(cmd,"ss"))
		{
 		 if (lastnew && typeflag == NROFF)
		    equivmess(cmd,"ls 1");
 		else diffmess(cmd);
	}
	else if (!strcmp(cmd,"qc"))
		{
		 if (typeflag == NROFF)
		    noemess(cmd);
		 qchar = getnext(NOBL);
		}
	else if (!strcmp(cmd,"nx"))
		{
		 if (typeflag == SROFF)
		    noemess(cmd);
		if (lastnew)
		   printf(" line %d:  ",linenum-1);
		   else printf(" line %d:  ",linenum);
		printf("%cnx:  WARNING mmlint does not switch to next file\n",
			cntrlch);
		}
	else if (!strcmp(cmd,"so"))
		printf(" line %d:  %cso  WARNING mmlint does not switch to next file\n",
			linenum,cntrlch);
}

/* this routine finds the name of what is being defined, xx */
findxx(xx) 
char xx[8];
{
	char c;
	int endflag;
	int backflag;

	endflag = FALSE;
	if (lastnew)
	   printf(" line %d:  expect xx (register name) here\n",linenum-1);
	else
	    {
	     c = getnext(NOBL);
	     if (c == '(')
		 endflag = TRUE;
	     else
		{
		 retract = TRUE;
		 rechar = c;
		}
	     backflag = checkreg(xx,TRUE);
	     if (typeflag == NROFF)
		endflag = backflag;
	/* add to user defined table */
	if (numuse != USEDEF)
	{
	  strcpy(usertab[numuse].cmd,xx);
	  numuse++;
	}
	}
   return(endflag);
}

findyy()	/* this procedure finds yy if it exists */
		/* it stores it in endname, also puts  */
{
	char c;

	endname[0]= '\0';
	endname[1] = ' ';
	endname[2] = '\0';
	if (!lastnew)
	   {
	    c = getnext(NOBL);
	    if (!lastnew)
   		{
    		 endname[0] = c;
		 c = getnext(BLANK);
    		 if (c != ' ' && !lastnew)
		    endname[1] = c;
		 if (typeflag == SROFF)
   		    {
    		     if (lastnew)
			printf(" line %d:  ",linenum-1);
			else printf(" line %d:  ",linenum);
    		     printf("%s:  (yy) is not recognized by sroff\n",endname);
   		    }
 }
}
}


/* this portion of the code is invoked when an escape char. has been found */
regfind()
{
	int i;
	char c;
	char savech;
	char rname[8];
	int  paren;

	/* at this point we have reccognized an escape char */
	/* it could be :				    */
	/* 1) an embedded command			    */
	/* 2) a regfind invocation			    */

	if (firstslash)
	   {
	    firstslash = FALSE;
	    if (typeflag == SROFF && escape == NCHDEF)
	       printf(" line %d:  WARNING must have a %cic \\ previously\n",
			linenum,cntrlch);
	   } 
	c = getnext(BLANK);
	if (c == 'n')		/* have nroff reg inovaction */
	    {
		c = getnext(BLANK);
		if ((c == '+') || (c == '-'))
		    {
		      savech = c;
	              if (typeflag == SROFF)  /* we have problem */
			{
			 if ((c = getnext(BLANK)) == '(')
			    {
			     paren = checkreg(rname,FALSE);
			     if (rname[0] != '\0')
				{
				 equivfl++;
				 if (lastnew)
				    printf(" line %d:  ",linenum-1);
				    else printf(" line %d:  ",linenum);
				printf("\\n%c(%s:  use .an (%s) %cM in sroff\n",
					savech,rname,rname,savech);
				}
			    }
		         else if (typeflag == SROFF) /* have \n+x */
				 {
				  equivfl++;
				  if (lastnew)
				     printf(" line %d:  ",linenum-1);
				     else printf(" line %d:  ",linenum);
			 	  printf("\\n%c%c:  use .an %c %cM in sroff\n",
				          savech,c,c,savech);
				}
			}
		     }
		else if (c == '(')	/* have \n( */
			{
			 paren = checkreg(rname,FALSE);
			 if ((rname[0] != '\0') && (typeflag == SROFF))
			    {
			     rname[2] = '\0';
			     equivfl++;
			     if (lastnew)
				printf(" line %d:  ",linenum-1);
				else printf(" line %d:  ",linenum);
			     	printf("\\n(%s:  use %c(%s) in sroff\n",
				     rname,escape,rname);
				}
			}
		else if (typeflag == SROFF)
			{
			equivfl++;
			if (lastnew)
			   printf(" line %d:  ",linenum-1);
		           else printf(" line %d:  ",linenum);
		        printf("\\n%c:  use %c%c in sroff\n",c,escape,c);
		      }
	     }
     else if (c == '(')
	     {
		paren = checkreg(rname,FALSE);
		if (paren && typeflag == NROFF)
		  {
		   equivfl++;
		   if (lastnew)
			printf(" line %d:  ",linenum-1);
			else printf(" line %d:  ",linenum);
		   printf("%c(%s):  use %cn(%s in nroff\n",
			   escape,rname,escape,rname);
		  }
		if (!paren && typeflag == SROFF && rname[0] != '\0')
		  {
		   noefl++;
		   rname[2] = '\0';
		   if (lastnew)
			printf(" line %d:  ",linenum-1);
			else printf(" line %d:  ",linenum);
		   printf("%c(%s:  no special chars in sroff\n",
			   escape,rname);
		  }
	      }
     else if (c == escape)	/* have \\ */
	          regfind();
     else if (c == '"')
	{
	 if (typeflag == SROFF)
	    { noefl++;
	     printf(" line %d:  %c\":  no comments in sroff\n",linenum,escape);
	    }
	}
     else if (c == '{')
	  {
	   if (typeflag == SROFF)
		{
		 noefl++;
		if (lastnew)
		   printf(" line %d:  ",linenum-1);
		   else printf(" line %d:  ",linenum);
		printf("%c{:  is not recognized by sroff\n",escape);
		}
	  }
     else if ( c == '}')
	     {
	     if (typeflag == SROFF)
		{ noefl++;
	     	printf(" line %d:  \\}:  is not recognized by sroff\n",linenum);
		}
	     }
     else if (c == '\n')
	     {
	     if (typeflag == SROFF)
		{ noefl++;
	        printf(" line %d:  %c(new-line):  is not concealed in sroff\n",
			linenum-1,escape);
		}
	     }
     else if (c == '*')
		{
		if (typeflag == SROFF)
		   {
		    c = getnext(BLANK);
		    if (c == '(')
		       {
			paren = checkreg(rname,FALSE);
			if (rname[0] != '\0')
			   {
			    equivfl++;
			    if (lastnew)
				printf(" line %d:  ",linenum-1);
				else printf(" line %d:  ",linenum);
			    printf("%c*(%s:  use %c(%s) in sroff\n",
				escape,rname,escape,rname);
			  }
		       }
		    else 
			{
			 equivfl++;
			 if (lastnew)
			    printf(" line %d:  ",linenum-1);
			    else printf(" line %d:  ",linenum);
			 printf("%c*%c:  use %c%c in sroff\n",escape,c,escape,c);
		        }
		   }
		}
     else if (c != '$')
		{
		savech =c;
		c = getnext(BLANK);
		if (c == ' ' || lastnew)
		   {
		    if (typeflag == NROFF && isletter(savech))
		       {
			equivfl++;
			if (lastnew)
			   printf(" line %d:  ",linenum-1);
			   else printf(" line %d:  ",linenum);
			printf("%c%c:  use %cn%c in nroff\n",escape,savech,
							     escape,savech);
			}
		   }
		else
		 {
		  if (typeflag == SROFF)
		     {
	              if (!isletter(c))
		          c = '\0';
		      noefl++;
		      if (lastnew)
		         printf(" line %d:  ",linenum-1);
		         else printf(" line %d:  ",linenum);
		      printf("%c%c%c:  no embedded functions in sroff\n",
			     escape,savech,c);
		     }
		  }
		}
}

/* this routine finds a register name- puts it in result */
/* it makes sure it has legal character, and is the right length */
/* for what ever formatter we are checking for */
checkreg(result,flagout)
char result[8];
int flagout;	/* to pass to slegal to print out message or not */
{
	char c;
	int i;
	int endflag;
	int okay;

	i = 0;
	okay = TRUE;
	c = getnext(NOBL);
	if (typeflag == SROFF)
	   {
	     while (c != ')' && c != ' ' && c != escape && c != '\n' && i <=7)
		   {
		    result[i] = c;
	            i++;
	            c = getnext(BLANK);
		   }
	     result[i] = '\0';
	     if (c == ')')
		endflag = TRUE;
		else {
			if ((c == escape) && flagout)
			   endflag = TRUE;
			   else endflag = FALSE;
			if (c != '\n')
			   {
			    retract = TRUE;
			    rechar = c;
			   }
		      }
	     slegal(result,flagout,endflag);
	     lookreg(result);
	  }
	else {
		while (c != ')' && c != ' ' && c != escape && c != '\n' && i<8 
			&& okay)
		      {
			result[i] = c;
			i++;
			c = getnext(BLANK);
			if (i >= 2)
				if (isletter(c) || c >= '0' && c <= '9'
					|| c == '%' || c == '#')
				   okay = TRUE;
				   else okay = FALSE;
		      }
		result[i] = '\0';
		if (c != '\n')
		   {
		    retract = TRUE;
		    rechar = c;
		   }
		if (c == ')')
		   {
		    endflag = TRUE;
		    if (i > 2)
		       {
			noefl++;
			if (lastnew)
			   printf(" line %d:  ",linenum-1);
			   else printf(" line %d:  ",linenum);
			printf("%s:  register names can only be two chars long in nroff\n",
				result);
			endflag = FALSE;
		       }
		   }
		   else endflag = FALSE;
	       lookreg(result);
	      }
	return(endflag);
}


slegal(ch,flagout,flagin)	/* check to see if legal sroff register name */
char ch[8];
int flagout;
int flagin;	/* =TRUE if surrounded by () already */
{
	int i;
	int bad;

	bad = FALSE;
	for (i = 0; i < 8 && !bad && ch[i] != '\0';i++)
	    if (isletter(ch[i]) || ch[i] >= '0' && ch[i] <= '9' || 
		ch[i] == '#' || ch[i] == '%' || ch[i] == '$')
		bad = FALSE;
		else bad = TRUE;
	if (bad && i < 2)
	   {
	    noefl++;
	    if (lastnew)
		printf(" line %d:  ",linenum-1);
		else printf(" line %d:  ",linenum);
	    ch[2] = '\0';
	    printf("%s:  is an illegal register name in sroff\n",ch);
	    if (!flagout)
	       ch[0] = '\0';
	   }
	else if (bad && i >=2)
	   ch[2] = '\0';
	else if (i > 1 && flagout && !flagin)
		{
		 equivfl++;
		 if (lastnew)
			printf(" line %d:  ",linenum-1);
			else printf(" line %d:  ",linenum);
		printf("%s:  use (%s) in sroff\n",ch,ch);
		}
}


lookreg(regover)
char *regover;
{
	int i;

	for (i = 0; i < NUMREG && (strcmp(regover,regtab[i].rname) != 0); i++);
	if (i < NUMREG)
	   {
	    /* the register name has been found */
	    if (regtab[i].regtype != typeflag)
	       {
		if (regtab[i].regact == UNIQUE)
		   {
		    noefl++;
		    if (lastnew)
			printf(" line %d:  ",linenum-1);
			else printf(" line %d:  ",linenum);
		    printf("%s:  has no equivalent in ",regover);
		    if (typeflag == SROFF)
			printf("sroff\n");
			else printf("nroff\n");
		   }
		else if (regtab[i].regact == EQUIV)
			{
			 equivfl++;
			 if (lastnew)
			    printf(" line %d:  ",linenum-1);
			    else printf(" line %d:  ",linenum);
			 printf("%s:  use %s in ",regover,regtab[i].regequiv);
			 if (typeflag == SROFF)
			     printf("sroff\n");
			    else printf("nroff\n");
			}
		}
	}
}


main(argc, argv)
int argc;
char **argv;
{
	int c;
	extern int optind;
	extern char *optarg;
	int errflg = 0;
	int flg = 0;
	
	while ((c = getopt(argc,argv,"s:n:")) != EOF)
	      switch(c) {
	      case 's':
			if (flg)
			   errflg++;
			else {
				typeflag = SROFF;
				flg++;
				filename = optarg;
			      }
			break;
	      case 'n':
			if (flg)
			   errflg++;
			else {
				typeflag = NROFF;
				flg++;
				filename = optarg;
			     }
			break;
	      case '?':
			errflg++;
			}
	if (errflg || !flg || (optind < argc))
		{
	         fprintf(stderr,"\tusage: mmlint [-sn file]\n");
	         exit(1);
	        }
	if ((fp = fopen(filename,"r")) == NULL)
		{
		 fprintf(stderr,"mm-lint: cannot open %s\n",filename);
		 exit(2);
		}
	/* set up defaults */
	cntrlch = CONTROL;
	nobreak = BREAKCH;
	escape = NCHDEF;
	scan();
	printf("\t*****");
	if (!noefl && !equivfl)
	   {
	    printf(" %s can run with ",filename);
	    if (typeflag == SROFF)
		printf("sroff as is\n");
		else printf("nroff as is\n");
	   exit(0);
	   }
	if (!noefl && equivfl)
	   {
	    printf(" %s can run if change %d",filename,equivfl);
	    if (typeflag == SROFF)
		printf(" nroff constructs to sroff\n");
		else printf(" sroff constructs to nroff\n");
	    exit(3);
	   }
	else {
		printf(" %s cannot run due to %d incompatibilities",filename,noefl);
		if (typeflag == SROFF)
		   printf(" with sroff\n");
	           else printf(" with nroff\n");
	 	exit(4);
	     }
}
