#include "cx.h"

wagen()
{
	register *p1, *p2, *p3;

	p1 = lmp;
	if((flag&WOO) != 0)
	if(board[61]==0 && board[62]==0)
	if(battack(60) && battack(61) && battack(62))
		wcheck(60, 62);
	if((flag&WOOO) != 0)
	if(board[57]==0 && board[58]==0 && board[59]==0)
	if(battack(58) && battack(59) && battack(60))
		wcheck(60, 58);
	wgen();
	p2 = p1;
	p3 = p1;
	while(p2 != lmp) {
		wmove(*p2);
		if(battack(wkpos))
			*p1++ = *p2;
		p2++;
		wremove();
	}
	lmp = p1;
}

wgen()
{
	int j, k;
	register d, i, *p;

	i = 64;
	while(i--)
	switch(board[i]) {

	/* pawn */
	case WPAWN1:
	case WPAWN2:
	case WPAWN3:
	case WPAWN4:
	case WPAWN5:
	case WPAWN6:
	case WPAWN7:
	case WPAWN8:
		if(((d=dir[i])&ULEFT)==0) {
			if(ispiece[board[i-9]] < 0)
				wcheck(i, i-9);
			if(eppos == i-9)
				wcheck(i, i-1);
		}
		if((d&URIGHT)==0) {
			if(ispiece[board[i-7]] < 0)
				wcheck(i, i-7);
			if(eppos == i-7)
				wcheck(i, i+1);
		}
		if(board[i-8]==0) {
			wcheck(i, i-8);
			if((d&RANK2)!=0)
			if(board[i-16]==0)
				wcheck(i, i-16);
		}
		continue;

	/* knight */
	case WKNIG1:
	case WKNIG2:
		p = attab;
		goto jump;

	/* king */
	case WKING:
		p = attab+16;

	jump:
		d = dir[i];
		for(j=8; j--; p=+2)
			if((d&p[0])==0)
				wcheck(i, i+p[1]);
		continue;

	/* bishop */
	case WBISH1:
	case WBISH2:
		p = attab+16;
		j = 4;
		goto slide;

	/* rook */
	case WROOK1:
	case WROOK2:
		p = attab+24;
		j = 4;
		goto slide;

	/* queen */
	case WQUEEN:
		p = attab+16;
		j = 8;

	slide:
		while(j--) {
			k = i;
			while((dir[k]&p[0]) == 0)
				if(wcheck(i, k=+p[1]))
					break;
			p =+ 2;
		}
		continue;
	}
}

wcheck(from, to)
{
	register b;
	register char *p;

	b = board[to];
	if(ispiece[b] > 0)
		return(TRUE);
	p = lmp;
	*p++ = from;
	*p++ = to;
	lmp = p;
	return(b);
}

wmove(mov)
{
	int pfrom, pto;
	register from, to;
	register struct mstr *lp;

	lp = amp;
	amp++;
	from = mov.pfrm;
	to = mov.pto;
	lp->mval = value;
	lp->mflg = flag & ~NOREP;
	lp->mepp = eppos;
	lp->mfrm = from;
	lp->mto = to;
	pto = board[to];
	if(lp->mpto = pto) {
		if(ispawn[pto])
			value.valpwn =+ 1; else
			value.valpce =+ pval[pto];
		lp->mflg =| NOREP;
		if(pto == BROOK1)
			flag =& ~BOOO; else
		if(pto == BROOK2)
			flag =& ~BOO;
	}
	board[to] = pfrom = board[from];
	board[from] = 0;
	eppos = -1;
	switch(pfrom) {

	case 0:
		for(to=0; movlst[to].movnam; to++)
			if(movlst[to].movval == mov) {
				lp->mtyp = movlst[to].movtyp;
				return;
			}
		abort();

	/* pawn */
	case WPAWN1:
	case WPAWN2:
	case WPAWN3:
	case WPAWN4:
	case WPAWN5:
	case WPAWN6:
	case WPAWN7:
	case WPAWN8:
		lp->mflg =| NOREP;
		switch(from-to) {

		case 1:
		case -1:
			board[to] = 0;
			board[to-8] = pfrom;
			lp->mtyp = TEP;
			return;

		case 16:
			eppos = from-8;
			break;
		}
		if((dir[from]&RANK7)!=0) {
			value.valpce =- pval[WQUEEN];
			value.valpwn =- 1;
			board[to] = WQUEEN;
			lp->mpar = pfrom;
			lp->mtyp = TQPRO;
			return;
		}
		break;

	/* queen rook */
	case WROOK1:
		flag =& ~WOOO;
		break;

	/* king rook */
	case WROOK2:
		flag =& ~WOO;
		break;

	/* king */
	case WKING:
		wkpos = to;
		flag =& ~(WOO|WOOO);
		switch(from-to) {

		case -2:
			board[61] = WROOK2;
			board[63] = 0;
			lp->mtyp = TOO;
			return;

		case 2:
			board[59] = WROOK1;
			board[56] = 0;
			lp->mtyp = TOOO;
			return;
		}
		lp->mtyp = TKING;
		return;
	}
	if(ispiece[pfrom] <= 0)
		abort();
	lp->mtyp = TMOVE;
}

wremove()
{
	int t, p;
	register from, to;
	register struct mstr *lp;

	amp--;
	lp = amp;
	t = lp->mtyp;
	p = lp->mpto;
	to = lp->mto;
	from = lp->mfrm;
	eppos = lp->mepp;
	flag = lp->mflg;
	value = lp->mval;
	board[from] = board[to];
	board[to] = p;

	switch(t) {

	/* king move */
	case TKING:
		wkpos = from;
		return;

	/* o-o */
	case TOO:
		board[63] = WROOK2;
		board[61] = 0;
		wkpos = 60;
		return;

	/* o-o-o */
	case TOOO:
		board[56] = WROOK1;
		board[59] = 0;
		wkpos = 60;
		return;

	/* ep */
	case TEP:
		board[from] = board[to-8];
		board[to-8] = 0;
		return;

	/* (q) */
	case TQPRO:
		board[from] = lp->mpar;
		return;
	}
}

wattack(pos)
{
	int b, d;
	register *p, i, j;

	p = attab;
	d = dir[pos];

	/* attack by knight */
	i = 8;
	do {
		if((d & p[0]) == 0)
		if(isknig[board[pos+p[1]]] > 0)
			return(FALSE);
		p =+ 2;
	} while(--i);

	/* attack along diagonal */
	b = 4;
	do {
		j = pos;
		while((dir[j]&p[0]) == 0) {
			j =+ p[1];
			if(i = board[j])
			if(isdiag[i] > 0)
				return(FALSE); else
				break;
		}
		p =+ 2;
	} while(--b);

	/* attack at right angles */
	b = 4;
	do {
		j = pos;
		while((dir[j]&p[0]) == 0) {
			j =+ p[1];
			if(i = board[j])
			if(isrigh[i] > 0)
				return(FALSE); else
				break;
		}
		p =+ 2;
	} while(--b);

	/* attack by king */
	p =- 16;
	i = 8;
	do {
		if((d & p[0]) == 0)
		if(board[pos+p[1]] == WKING)
			return(FALSE);
		p =+ 2;
	} while(--i);

	/* attack by pawns */
	if((d & DLEFT) == 0)
	if(ispawn[board[pos+7]] > 0)
		return(FALSE);
	if((d & DRIGHT) == 0)
	if(ispawn[board[pos+9]] > 0)
		return(FALSE);

	return(TRUE);
}
