#include "astro.h"
char	*startab	"/usr/lib/estartab";

stars()
{
	register i;
	double sd;
	double lomoon, himoon;
	int wrap;
	int buf[259];

	sd = 1000.*radsec;
	lomoon = omoon.point[0].ra - sd;
	if(lomoon < 0.)
		lomoon =+ 2.*pi;
	himoon = omoon.point[NPTS+1].ra + sd;
	if(himoon > 2.*pi)
		himoon =- 2.*pi;
	lomoon =* 12./pi;
	himoon =* 12./pi;
	wrap = 0;
	if(lomoon > himoon)
		wrap++;

/*
 *	read epoch of star table
 *	and convert to internal format
 */

	if(fopen(startab, buf) < 0) {
		printf("%s?\n", startab);
		return;
	}
	rline(buf);
	epoch = atof(line);
	epoch = (epoch-1900.0) * 365.2422 + 0.313;

/*
 *	read mean places of stars at epoch of star table
 */

loop:
	if(rline(buf)) {
		close(buf[0]);
		return;
	}
	rah = atof(line+17);
	ram = atof(line+20);
	ras = atof(line+23);

	alpha = rah + ram/60. + ras/3600.;
	if(wrap == 0) {
		if(alpha < lomoon || alpha > himoon)
			goto loop;
	} else
		if(alpha < lomoon && alpha > himoon)
			goto loop;

	agc = atof(line+12);
	da = atof(line+30);
	dday = atof(line+37);
	dmin = atof(line+41);
	dsec = atof(line+44);
	dd = atof(line+50);
	px = atof(line+57);
	mag = atof(line+61);

/*
 *	convert rt ascension and declination to internal format
 */

	delta = fabs(dday) + dmin/60. + dsec/3600.;
	if(dday < 0.)
		delta = -delta;

	star();
/*
 *	if(fabs(beta) > 6.55*radian)
 *		goto loop;
 */
	sd = .0896833e0*cos(beta)*sin(lambda-1.3820+.00092422117*eday)
		 + 0.99597*sin(beta);
	if(fabs(sd) > .0183)
		goto loop;

	for(i=0; i<=NPTS+1; i++)
		setobj(&ostar.point[i]);

	occult(&omoon, &ostar, 0.);
	if(occ.t3 >= 0.)
	event("Occultation of AGC %l at ", agc, 0,
		occ.t3, SIGNIF|DARK|PTIME);
	goto loop;
}
