#include "astro.h"

struct
{
	struct	object	act;
	struct	object	del0;
	struct	object	del1;
	struct	object	del2;
} o1, o2;
struct
{
	int	junk[2];
	struct	object	pt[3];
} xo1, xo2;


occult(p1, p2, mel)
struct object *p1, *p2;
double mel;
{
	register i, N;
	double d1, d2, d3;
	double x, di, dx;

	N = 2880*PER/NPTS; /* 1 min steps */
	occ.t3 = -1.;
	for(i=0; i<=NPTS+1; i++) {
		d1 = d2;
		d2 = d3;
		d3 = dist(&p1->point[i], &p2->point[i]);
		if(i >= 2 && d2 <= d1 && d2 <= d3)
			goto found;
	}
	return;

found:
	i =- 2;
	set3pt(p1, i, &o1);
	set3pt(p2, i, &o2);

	di = i;
	x = 0.;
	dx = 2./N;
	for(i=0; i<=N; i++) {
		setpt(&o1, x);
		setpt(&o2, x);
		d1 = d2;
		d2 = d3;
		d3 = dist(&o1.act, &o2.act);
		if(i >= 2 && d2 <= d1 && d2 <= d3)
			goto found1;
		x =+ dx;
	}
	printf("bad 1 \n");
	return;

found1:
	if(o1.act.el < mel) {
		return;
	}
	if(d2 > o1.act.semi2+o2.act.semi2+50.) {
		return;
	}
	di =+ x - 3.*dx;
	x = 0.;
	for(i=0; i<3; i++) {
		setime(day + deld*(di + x));
		(*p1->obj)();
		setobj(&xo1.point[i]);
		(*p2->obj)();
		setobj(&xo2.point[i]);
		x =+ 2.*dx;
	}
	dx =/ 60.;
	x = 0.;
	set3pt(&xo1, 0, &o1);
	set3pt(&xo2, 0, &o2);
	for(i=0; i<=240; i++) {
		setpt(&o1, x);
		setpt(&o2, x);
		d1 = d2;
		d2 = d3;
		d3 = dist(&o1.act, &o2.act);
		if(i >= 2 && d2 <= d1 && d2 <= d3)
			goto found2;
		x =+ 1./120.;
	}
	printf("bad 2 \n");
	return;

found2:
	if(d2 > o1.act.semi2 + o2.act.semi2) {
		return;
	}
	occ.t3 = di + (i-1) * dx;
}

setpt(o, x)
int *o;
double x;
{
	register *p;
	double y;

	y = x * (x-1.);
	p = o;
	p->act.ra = p->del0.ra +
		x*p->del1.ra + y*p->del2.ra;
	p->act.decl2 = p->del0.decl2 +
		x*p->del1.decl2 + y*p->del2.decl2;
	p->act.semi2 = p->del0.semi2 +
		x*p->del1.semi2 + y*p->del2.semi2;
	p->act.el = p->del0.el +
		x*p->del1.el + y*p->del2.el;
}


double
pinorm(a)
double a;
{

	while(a < -pi)
		a =+ 2.*pi;
	while(a > pi)
		a =- 2.*pi;
	return(a);
}

set3pt(p, i, o)
int *p, *o;
{
	register *p1, *p2, *p3;
	double a;

	p1 = p->point+i;
	p2 = p->point+i+1;
	p3 = p->point+i+2;

	o->del0.ra = p1->ra;
	o->del0.decl2 = p1->decl2;
	o->del0.semi2 = p1->semi2;
	o->del0.el = p1->el;

	a = p2->ra - p1->ra;
	o->del1.ra = pinorm(a);
	a = p2->decl2 - p1->decl2;
	o->del1.decl2 = pinorm(a);
	o->del1.semi2 = p2->semi2 - p1->semi2;
	o->del1.el = p2->el - p1->el;

	a = p1->ra + p3->ra - 2.*p2->ra;
	o->del2.ra = pinorm(a)/2.;
	a = p1->decl2 + p3->decl2 - 2.*p2->decl2;
	o->del2.decl2 = pinorm(a)/2.;
	o->del2.semi2 = (p1->semi2 + p3->semi2 - 2.*p2->semi2) / 2.;
	o->del2.el = (p1->el + p3->el - 2.*p2->el) / 2.;
}
