#include "astro.h"

int	*objlst[]
{
	&osun,
	&omoon,
	&oshad,
	&omerc,
	&ovenus,
	&omars,
	&ojup,
	&osat,
	0,
};
int	fstar();
int	fsun();
int	moon();
int	shad();
int	merc();
int	venus();
int	mars();
int	jup();
int	sat();
int	idata[]
{
	"The sun", &fsun,
	"The moon", &moon,
	"The shadow", &shad,
	"Mercury", &merc,
	"Venus", &venus,
	"Mars", &mars,
	"Jupiter", &jup,
	"Saturn", &sat,
};

init()
{
	register i, *p, *q;

	glat = nlat - (692.74*radsec)*sin(2.*nlat)
		 + (1.16*radsec)*sin(4.*nlat);
	erad = .99832707e0 + .00167644e0*cos(2.*nlat)
		 - 0.352e-5*cos(4.*nlat)
		 + 0.001e-5*cos(6.*nlat)
		 + 0.1568e-6*elev;
	if(flags & DELT)
		wlong =+ 15.e0*deltat*radsec;

	p = idata;
	for(i=0; q=objlst[i]; i++) {
		q->name = *p++;
		q->obj = *p++;
	}
	ostar.obj = &fstar;
}

setime(d)
double d;
{
	double x, xm, ym, zm;

	eday = d;
	deltat = eday * .00167;
	wlong = awlong;
	if(flags & DELT)
		wlong =+ 15.*deltat*radsec;
	capt = eday/36525.e0;
	capt2 = capt*capt;
	capt3 = capt*capt2;
	nutate();
	eday =+ .1;
	sun();
	srad = rad;
	xm = rad*cos(beta)*cos(lambda);
	ym = rad*cos(beta)*sin(lambda);
	zm = rad*sin(beta);
	eday =- .1;
	sun();
	xms = rad*cos(beta)*cos(lambda);
	yms = rad*cos(beta)*sin(lambda);
	zms = rad*sin(beta);
	x = .057756;
	xdot = x*(xm-xms);
	ydot = x*(ym-yms);
	zdot = x*(zm-zms);
}

setobj(op)
struct object *op;
{
	register struct object *p;

	p = op;
	p->ra = ra;
	p->decl2 = decl2;
	p->semi2 = semi2;
	p->az = az;
	p->el = el;
	p->mag = mag;
}

fstar()
{

	ra = ostar.point[0].ra;
	decl2 = ostar.point[0].decl2;
	semi2 = ostar.point[0].semi2;
	az = ostar.point[0].az;
	el = ostar.point[0].el;
	mag = ostar.point[0].mag;
}

fsun()
{

	beta = 0.;
	rad = 0.;
	lambda = 0.;
	motion = 0.;
	helio();
	geo();
	seday = eday;
	salph = alpha;
	sdelt = delta;
	mag = lmb2;
}

shad()
{

	if(seday != eday)
		fsun();
	if(meday != eday)
		moon();
	alpha = fmod(salph+pi, 2.*pi);
	delta = -sdelt;
	hp = mhp;
	semi = 1.0183*mhp/radsec - 969.85/srad;
	geo();
}
