int	noline	20;
int	olinx[50];
int	oliny[50];
int	pltflg	1;
int	nstar;
double	pi	3.141592653589793;
double	radian	.01745329251994396;
char	card[200];
struct
{
	double	az;
	double	el;
	int	vis;
	int	nx;
	int	ox;
	int	ny;
	int	oy;
} out;
struct
{
	double	lat;
	double	long;
	double	elev;

	double	slat;
	double	clat;
	double	ro;
	double	sa;
	double	ca;
	double	olat;
	double	sol;
	double	col;
} loc;
struct
{
	double	time;
	double	tilt;
	double	pnni;
	double	psi;
	double	ppi;
	double	d1pp;
	double	peri;
	double	d1per;
	double	e0;
	double	deo;
	double	rdp;
	double	st;
	double	ct;
	double	rot;
	double	semi;
} sat;
struct
{
	double	gst;
	double	tau;
	double	xx;
	double	yx;
	double	zx;
	double	yy;
	double	zy;
	double	zz;
} strtm;
struct
{
	float	ras;
	float	dras;
	float	dec;
	float	ddec;
	int	mag;
} star[100];
main(argc, argv)
char *argv[];
{
	char *file;
	extern fin[];
	double ltod();
	double sin(), cos();
	double t;
	double sinc, linc;
	int d[2];
	int i, f;

	for(i=0; i<=noline; i++) {
		t = pi * 2. * i / noline;
		olinx[i] = 2000. * sin(t);
		oliny[i] = 2000. * cos(t);
	}
	sinc = 60.;
	linc = 300.;
	rloc();
	file = "/usr/jfo/el/sla";
	if(argc > 1)
		file = argv[1];
	fin[0] = open(file, 0);
	if(fin[0] < 0)
		error("main: open of sat");
	rsat();
	close(fin[0]);
	fin[0] = open("/usr/lib/startab", 0);
	if(fin[0] < 0)
		error("main: open of stars");
	fin[1] = 0;
	fin[2] = 0;
	fin[3] = 0;
	rstar();
	close(fin[0]);
	time(d);
	t = ltod(d);
	if(pltflg)
		openvt();

loop:
	for(;;) {
		xsat(t);
		if(out.el > 0. && out.vis)
			break;
		t = t+linc;
	}
	erase();
	startim(t);
	for(i=0; i<nstar; i++) {
		xstar(i);
		pstar();
	}
	do {
		t = t-sinc;
		xsat(t);
	} while(out.el > 0.);
	f = 0;
	for(;;) {
		xsat(t);
		if(out.el > 0.) {
			if(f == 0) {
				spass(t);
				f++;
			} else
				mpass(t);
		} else
		if(f != 0) {
			epass(t);
			break;
		}
		t = t + sinc;
	}
	goto loop;
}

pstar()
{
	register i;

	if(pltflg) {
		if(out.el > 0.) {
			mapco();
			for(i=0; i<out.vis; i++)
				point(out.nx, out.ny);
		}
		return;
	}
/*
	printf("%5.1f %5.1f\n",
		out.az/radian, out.el/radian);
 */
}

spass(t)
double t;
{

	if(pltflg) {
		mapco();
		move(out.nx, out.ny);
		label("S");
		move(-1950, 2000);
		label(pdate(t));
		return;
	}
	printf("\n%s", pdate(t));
	mpass(t);
}

mpass(t)
double t;
{

	if(pltflg) {
		mapco();
		if(out.vis == 0)
			return;
		line(out.ox, out.oy, out.nx, out.ny);
		return;
	}
	printf("%d %5.1f %5.1f\n",
		out.vis, out.az/radian, out.el/radian);
}

epass(t)
double t;
{
	register i;

	if(pltflg) {
		move(out.nx, out.ny);
		label("F");
		move(600, 2000);
		label(pdate(t));
		for(i=0; i<noline; i++)
			line(olinx[i], oliny[i], olinx[i+1], oliny[i+1]);
		return;
	}
}

error(s)
char *s;
{

	printf("%s\n", s);
	exit();
}

rloc()
{
	double a, sin(), cos();

	loc.lat = 40.682 * radian;
	loc.long = 74.425 * radian;
	loc.elev = 460.;

	loc.slat = sin(loc.lat);
	loc.clat = cos(loc.lat);
	loc.ro = 3963.35 * (0.99832 + 0.00168*cos(2.*loc.lat)) +
		loc.elev/5280.;
	a = .1932 * sin(2.*loc.lat) * radian;
	loc.sa = sin(a);
	loc.ca = cos(a);
	loc.olat = loc.lat - a;
	loc.sol = sin(loc.olat);
	loc.col = cos(loc.olat);
}

int	dmo[12]
{
	0,31,59,90,120,151,181,212,243,273,304,334
};

rsat()
{
	double sin(), cos();
	double ifa[20];
	double t;
	register *cp;
	int i, n;

	rcard();
	rcard();
	rcard();
	if(input(card, ifa) != 9)
		error("sat: input");
	n = ifa[0];
	i = ifa[1];
	t = dmo[i-1] + ifa[2] - 1.;
	if(n%4 == 0 && i > 2)
		t = t + 1.;
	for(i=1970; i<n; i++) {
		t = t + 365.;
		if(i%4 == 0)
			t = t + 1.;
	}
	t = (t * 24. + ifa[3]) * 60. + ifa[4];
	sat.time = t * 60.;
	sat.tilt = ifa[5] * radian;
	sat.pnni = ifa[6] * radian;
	sat.psi = ifa[7];
	sat.ppi = ifa[8] * radian;
	rcard();
	if(input(card, ifa) != 5)
		error("sat: input1");
	sat.d1pp = ifa[0] * radian;
	sat.peri = ifa[1];
	sat.d1per = ifa[2];
	sat.e0 = ifa[3];
	sat.deo = 0;
	sat.rdp = ifa[4];

	sat.st = sin(sat.tilt);
	sat.ct = cos(sat.tilt);
	sat.rot = 2. * pi / (1440. + sat.psi);
	sat.semi = sat.rdp * (1. + sat.e0);
}

xsat(time)
double time;
{
	double sqrt(), sin(), cos(), atan2(), fabs(), pyth();
	double amean;
	double an;
	double az;
	double c;
	double cc;
	double cd;
	double cel;
	double cel1;
	double coa;
	double coa1;
	double coc;
	double csl;
	double d;
	double de;
	double el;
	double enom;
	double eo;
	double pp;
	double q;
	double rdp;
	double sd;
	double sel;
	double sel1;
	double slong;
	double soa;
	double soa1;
	double soc;
	double ssl;
	double t;
	double tp;
	double z;
	register i;

	t = (time - sat.time)/60.;
	if(t < 0.)
		error("sat: time too early");
	i = t/sat.peri;
	an = i;
	while(an*sat.peri + an*an*sat.d1per/2. <= t)
		an = an + 1.;
	while((tp = an*sat.peri + an*an*sat.d1per/2.) > t)
		an = an - 1.;
	amean = (t-tp)/(sat.peri+(an+.5)*sat.d1per);
	pp = sat.ppi+(an+amean)*sat.d1pp;
	amean = 6.2831853*amean;
	eo = sat.e0+sat.deo*an;
	rdp = sat.semi/(1.0+eo);
	enom = amean+eo*sin(amean);
	do {
		de = (amean-enom+eo*sin(enom))/(1.0-eo*cos(enom));
		enom = enom+de;
	} while(fabs(de) >= 1.0e-6);
	c = rdp*(1.0-eo*cos(enom))/(1.0-eo);
	q = loc.ro/c;
	d = pp+2.0*atan2(sqrt((1.+eo)/(1.-eo))*sin(enom/2.0),cos(enom/2.0));
	sd = sin(d);
	cd = cos(d);
	slong = sat.pnni+t*sat.rot-atan2(sat.ct*sd,cd);
	ssl = sat.st*sd;
	csl = pyth(ssl);
	out.vis = vis(time, atan2(ssl,csl), slong, c);
	c = loc.long-slong;
	cc = cos(c);
	coc = ssl*loc.sol + csl*loc.col*cc;
	soc = pyth(coc);
	el = atan2(coc-q,soc);
	cel = cos(el);
	soa = sin(c)*csl;
	coa = loc.col*ssl - loc.sol*csl*cc;
	sel = sin(el);
	z = cel*coa/soc;
	sel1 = sel*loc.ca + z*loc.sa;
	cel1 = pyth(sel1);
	el = atan2(sel1,cel1);
	soa1 = cel*soa/soc;
	coa1 = z*loc.ca - sel*loc.sa;
	az = pi-atan2(soa1,-coa1);
	out.az = az;
	out.el = el;
}

vis(t, slat, slong, srad)
double t;
double slat, slong, srad;
{
	double sin(), cos(), atan2(), fabs(), pyth();
	double t0, t1, t2;
	double d;

	d = t/86400. - .005375 + 3653.;
	t0 = 6.238030674 + .01720196977*d;
	t2 = t0 + .0167253303*sin(t0);
	do {
		t1 = (t0 - t2 + .0167259152*sin(t2)) /
			(1. - .0167259152*cos(t2));
		t2 = t2 + t1;
	} while(fabs(t1) >= 1.e-4);
	t0 = 2. * atan2(1.01686816*sin(t2/2.), cos(t2/2.));
	t0 = 4.926234925 + 8.214985538e-7*d + t0;
	t1 = 0.91744599 * sin(t0);
	t0 = atan2(t1, cos(t0));
	if(t0 < -pi/2.)
		t0 = t0 + 2.*pi;
	d = 4.88097876 + 6.30038809*d - t0;
	t0 = 0.43366079 * t1;
	t1 = pyth(t0);
	t2 = t1*cos(slat)*cos(d-slong) - t0*sin(slat);
	if(t2 > 0.46949322e-2) {
		if(0.46949322e-2*t2 + 0.999988979*pyth(t2) < loc.ro/srad)
			return(0);
	}
	t2 = t1*loc.col*cos(d-loc.long) - t0*loc.sol;
	if(t2 < .1)
		return(0);
	return(1);
}

rstar()
{
	register *p;
	double ifa[20];
	double fabs();
	double t;

	rcard();
	while(rcard() == 0) {
		if((card[69]&01) != 1)
			continue;
		card[67] = '\n';
		if(input(card+18, ifa) != 10)
			error("star: input");
		if(ifa[9] > 4.5)
			continue;
		p = &star[nstar];
		t = ifa[0] + ifa[1]/60. + ifa[2]/3600.;
		p->ras = t * radian;
		t = fabs(ifa[4]) + ifa[5]/60. + ifa[6]/3600.;
		if(card[38] == '-')
			t = -t;
		p->dec = t * radian;
		p->dras = ifa[3] * radian;
		p->ddec = ifa[7] * radian;
		if(ifa[9] < 0.)
			ifa[9] = 0.;
		p->mag = 4.5-ifa[9];
		p->mag = 1<<p->mag;
		nstar++;
		if(nstar >= 100)
			break;
	}
}

startim(time)
double time;
{
	double floor();
	double eday, capt0, capt1;
	double capt11, capt111, epoch;

	eday = time/86400. + 25567.5;
	capt1 = eday/36525.;
	capt11 = capt1*capt1;
	capt0 = 99.69098 + 360.9856473354*eday + .000387*capt11;
	capt0 = capt0 - 180.;
	capt0 =- floor(capt0/360.) * 360.;
	if(capt0 < 0.)
		capt0 = capt0 + 360.;
	strtm.gst = capt0*radian - loc.long;
	epoch = 19723.392;
	strtm.tau = (eday - epoch)/365.25;
	capt0 = (epoch - 18262.427)/36524.220;
	capt1 = (eday - epoch)/36524.220;
	capt11 = capt1*capt1;
	capt111 = capt11*capt1;
	strtm.xx = - (.00029696+26.e-8*capt0)*capt11
		- 13.e-8*capt111;
	strtm.yx =  -(.02234941+1355.e-8*capt0)*capt1
		- 676.e-8*capt11 + 221.e-8*capt111;
	strtm.zx = -(.00971690-414.e-8*capt0)*capt1
		+ 207.e-8*capt11 + 96.e-8*capt111;
	strtm.yy = - (.00024975+30.e-8*capt0)*capt11
		- 15.e-8*capt111;
	strtm.zy = -(.00010858+2.e-8*capt0)*capt11;
	strtm.zz = - (.00004721-4.e-8*capt0)*capt11;
}

xstar(i)
{
	register *p;
	double sin(), cos(), sqrt(), atan2(), pyth();
	double alpha;
	double az;
	double ca;
	double caz;
	double decl;
	double dxm;
	double dym;
	double el;
	double lha;
	double sa;
	double saz;
	double sel;
	double xm;
	double ym;
	double zm;

	p = &star[i];
	alpha = (p->ras + strtm.tau*p->dras/3600.) * 15.;
	decl = p->dec + strtm.tau*p->ddec/3600.;
	ca = cos(decl);
	xm = ca*cos(alpha);
	ym = ca*sin(alpha);
	zm = sin(decl);
	dxm =   strtm.xx*xm + strtm.yx*ym + strtm.zx*zm;
	dym = - strtm.yx*xm + strtm.yy*ym + strtm.zy*zm;
	xm = xm + dxm;
	ym = ym + dym;
	alpha = pi + atan2(-ym,-xm);
	decl = atan2(zm,sqrt(xm*xm+ym*ym));
	lha = strtm.gst - alpha;
	ca = cos(decl);
	saz = sin(lha)*ca;
	ca = ca * cos(lha);
	sa = sin(decl);
	sel = loc.slat*sa + loc.clat*ca;
	out.el = atan2(sel, pyth(sel));
	caz = loc.clat*sa - loc.slat*ca;
	out.az = pi + atan2(saz,-caz);
	out.vis = p->mag;
}

pdate(t)
double t;
{
	int d[2];

	d[0] = t / 65536.;
	t = t - d[0]*65536.;
	if(t == 32768.)
		d[1] = 0100000; else
	if(t >= 32768.) {
		d[1] = 65536. - t;
		d[1] = -d[1];
	} else
		d[1] = t;
	return(ctime(d));
}

double
pyth(f)
double f;
{
	double sqrt();

	if(f > 1.)
		f = 1.;
	return(sqrt(1. - f*f));
}

mapco()
{
	double e, sin(), cos();

	e = pi/4. - out.el/2.;
	e = 2000. * (sin(e)/cos(e));
	out.ox = out.nx;
	out.oy = out.ny;
	out.nx = e * sin(out.az);
	out.ny = e * cos(out.az);
}

rcard()
{
	register char *p;
	register c;

	p = card;
	while((c = getchar()) != '\n')
		if(c == 0)
			return(1); else
			*p++ = c;
	*p++ = '\n';
	return(0);
}

input(cp, ifa)
char *cp;
double ifa[];
{
	double atof();
	register char *p;
	register n;

	p = cp;
	n = 0;
	for(;;)
	switch(*p++) {

	case '\n':
		return(n);

	case '0':
	case '1':
	case '2':
	case '3':
	case '4':
	case '5':
	case '6':
	case '7':
	case '8':
	case '9':
	case '-':
	case '.':
		ifa[n++] = atof(p-1);
		p = skip(p);
		if(*p == '.')
			p = skip(p+1);
		if(*p == 'e') {
			p++;
			if(*p=='+' || *p=='-')
				p++;
			p = skip(p);
		}
	}
}

skip(cp)
char *cp;
{
	register char *p;

	p = cp;
	while(*p >= '0' && *p <= '9')
		p++;
	return(p);
}
