/*
 *	frametab (virtual page frame table)
 *		gives for each frame of virtual space (user and supervisor)
 *		the name of the mapped in segment, its access, length and
 *		direction.  The only remaining piece of information (the
 *		capability index associated with that segment) is in the
 *		array _segcap which is initialized by k_init_cap and maintained
 *		by k_map.
 */
struct frametab {
	int f_id[2];	/* the id (to the file process) of the assoc segment */
	int f_modes;	/* the modes with which the segment is mapped in */
	int f_length;	/* the length it is mapped in to (in 32 word blocks) */
	int f_refcount;	/* number of people using the pageframe */
} frametab[32];



/*
 *	(and the _segcap table as well)
 */
#define USERI	0
#define USERD	8
#define SUPERI	16
#define SUPERD	24



/*
 * telling bits within the frame table index
 */
#define SUPERVISORSEGMENT 16
#define DATASEGMENT 8



/*
 bits within the modes field of the frame table
 */
#define downFRAME	010
#define shortFRAME 020
