/*
 * tunable variables
 */

#define VERSION 0
#define MOD	2
#define	NINODE	25		/* number of in core inodes */
#define	NFILE	25		/* number of in core file structures */
#define	NMOUNT	4		/* number of mountable file systems */
#define	NOFILE	15		/* max open files per process */
#define	NCLIST	40		/* max total clist size */
#define	SINCR	20		/* growth increment for stack (*64 bytes) */
#define	HZ	60		/* Ticks/second of the clock */
#define NCALL	10		/* max number of call outs */
#define NBLKDEV	16		/* max number of open block devices */

/*
 * signals
 * dont change
 */

#define	NSIG	20
#define		SIGHUP	1	/* hangup */
#define		SIGINT	2	/* interrupt (rubout) */
#define		SIGQIT	3	/* quit (FS) */
#define		SIGINS	4	/* illegal instruction */
#define		SIGTRC	5	/* trace or breakpoint */
#define		SIGIOT	6	/* iot */
#define		SIGEMT	7	/* emt */
#define		SIGFPT	8	/* floating exception */
#define		SIGKIL	9	/* kill */
#define		SIGBUS	10	/* bus error */
#define		SIGSEG	11	/* segmentation violation */
#define		SIGSYS	12	/* sys */
#define		SIGPIPE	13	/* end of pipe */
#define		SIGCLK	14	/* alarm clock */

/*
 * fundamental constants
 * cannot be changed
 */

#define	USIZE	16		/* size of user block (*64) */
#define	NULL	0
#define	NODEV	(-1)
#define	ROOTINO	1		/* i number of all roots */
#define	DIRSIZ	14		/* max characters per directory */

/*
 * structure to access an
 * integer in bytes
 */
struct
{
	char	lobyte;
	char	hibyte;
};

/*
 * structure to access an integer
 */
struct
{
	int	integ;
};

