#
#include "../param.h"
#include "../systm.h"
#include "../conf.h"
#include "../../shared/constants.h"
#include "../../shared/shared.h"

#define then /* */
#define true 0177777
#define false 000000


/*
 * In case console is off,
 * panicstr contains argument to last
 * call to panic.
 */

char	*panicstr;

/*
 * Scaled down version of C Library printf.
 * Only %s %l %d (==%l) %o are recognized.
 * Used to print diagnostic information
 * directly on console tty.
 * Since it is not interrupt driven,
 * all system activities are pretty much
 * suspended.
 * Printf should not be used for chit-chat.
 */
char outstring[40];
int outlength;
printf(fmt,x1,x2,x3,x4,x5,x6,x7,x8,x9,xa,xb,xc)
char fmt[];
{
	register char *s;
	register *adx, c;

	outlength = 0;
	adx = &x1;
loop:
	while((c = *fmt++) != '%') {
		if(c == '\0')
		{	typeout(outstring, outlength);
			return;
		}
		putchar(c);
	}
	c = *fmt++;
	if(c == 'd' || c == 'l' || c == 'o')
		printn(*adx, c=='o'? 8: 10);
	if(c == 's') {
		s = *adx;
		while(c = *s++)
			putchar(c);
	}
	adx++;
	goto loop;
}

/*
 * print an unsigned integer in base b.
 */
printn(n, b)
{
	register a;

	if(a = ldiv(n, b))
		printn(a, b);
	putchar(lrem(n, b) + '0');
}

/*
 *	append a single character to the output string we are
 *	building.  If it gets too long, output it.
 */
putchar( c )
 char c;
{	register int i;

	outstring[ outlength++ ] = c;
	if (outlength == 40) then
	{	typeout(outstring, outlength);
		outlength = 0;
	}

	if (c == '\r')
	then	for(i = 0; i < 8; i++)
			putchar('\177');
}
/*
 *	type out the indicated string.  This was put here to cut down on the
 *	number of kernel calls made to do la30 output for the system
 */
typeout( string, length )
 char *string;
 int length;
{	register int l;
	register char *s;
	register int retval;

	l = length;
	s = string;
	while( l )
	{	retval = k_sio( super_d_space, _ttyo_cap, _IO_WRITE_OP,
			s, l, true, 0 );
		if (retval < 0) then
			while( true ) idle();

		l =- retval;
		s =+ retval;
		idle();
	}
}




/*
 * Panic is called on unresolvable
 * fatal errors.
 * It syncs, prints "panic: mesg" and
 * then loops.
 */
panic(s)
char *s;
{
	panicstr = s;
	/* update(); */
	printf("Unix is inoperative (%s)\r\n", s);
	for(;;)
		idle();
}

/*
 * prdev prints a warning message of the
 * form "mesg on dev x/y".
 * x and y are the major and minor parts of
 * the device argument.
 */
prdev(str, dev)
{

	printf("%s on dev %l/%l\n", str, dev.d_major, dev.d_minor);
}

