#
/*****************************************************************
 **								**
 **		   U C L A  Data Secure Unix			**
 **								**
 **			Copyright 1977				**
 **								**
 **    Mark Kampe, Charles Kline, Gerald Popek, Evelyn Walton	**
 **								**
 *****************************************************************/
/* name:
	main

function:
	to initialize the system

algorithm:
	initialize pointers into the shared segments for the assembler code
		(which can't reference symbols within structures)
	initialize the capability table with the known capabilities
	arrange for clock interrupts, and start the clock timer going
	call	character device initialization routine
		block device initialization routine
		inode and superblock initialization routine
		user process initialization routine
	return to user mode (to execute first user process)

parameters:
	none

returns:
	to the user process after initializing the system

globals:
	comm_blk
	arg_blk
	(pointers into above)
		RTI_ADR
		OPS_ADR
		OPC_ADR
	captab
	u structure

calls:
	k_init_cap	to find out the initial capabilities
	capinit		to initialize my capability table
	seginit		to initialize my segment table
	cinit		initialization routine for character devices
	iinit		initialization routine for inodes
	uinit		initialization routine for user process
	printf		to talk to the oc

called by:
	start (after setting up the stack)

history:
	designed and coded by Mark Kampe
*/
#define true 0177777
#define false 000000
#define then  /* */

#include "../../shared/constants.h"
#include "../../shared/shared.h"
#include "../param.h"
#include "../user.h"
#include "../systm.h"
#include "../inode.h"
#include "../seg.h"
#include "../tty.h"



extern int *PS_ADR, *PC_ADR, *RTI_ADR;
extern end();
extern etext();
retrap();
extern int pretty;
struct tty ttys[];


main()	/* ah, life */
{	register int i;
	register int j;
	register int k;

	/* initialize some pointers for the assembler code */
	RTI_ADR = &comm_blk->c_nop[0];
	PC_ADR = &comm_blk->c_opc;
	PS_ADR = &comm_blk->c_ops;
	comm_blk->c_nop[0] = 000002;	/* an rti instruction */
	comm_blk->c_nop[1] = 000137;	/* jump absolute instruction */
	comm_blk->c_nop[2] = &retrap;	/* to the trap reentry routine */
	pretty = 017;			/* figure this one out */

	/* find out what my initial capabilities and ids are */
	k_init_cap();

	/* initialize my segment table */
	seginit();

	/* and my capability table */
	capinit();
	super_d_space = &_segcap[ SUPERD ];

	/* and my I/O devices */
	devinit();
	_ttyo_cap = ttys[0].t_outcap;

	/* arrange for clock interrupts */
	comm_blk->c_clk_wanted = true;
	comm_blk->c_time_counter = 0;
	comm_blk->c_clk_counter = -30;

	/* say hi to the people */
	printf( "UCLA - Developmental Unix %d.%d\r\n",
		VERSION, MOD );

	/* tell them how big I am */
	i = &end;
	i = ((i + 03777) >> 11) & 037;
	j = &etext;
	j = ((j + 03777) >> 11) & 037;
	printf( "Supervisor size: %dk (%dI + %dD)\r\n",
		(i + j), j, i );


	/* perform all necessary file system initialization */
	iinit();	/* inode initialization */

	/* bring in the inode for the file system root */
	rootdir = iget( rootdev , ROOTINO );
	rootdir->i_flag =& ~ILOCK;

	/* do any necessary user process initialization */
	uinit();

	return;
}
/* name:
	uinit

function:
	initialize the first user process

algorithm:
	Get a working directory for the user and put it in his u block
	Allocate one page, map it in to his i and d spaces, and copy
	into it a bootstrap;

parameters:

returns:

globals:
	segcap
	u structure

calls:
	iget
	segfetch
	copyout

called by:
	main

history:
	designed and coded by Mark Kampe
*/
int icode[]
{/* 000000: */	0104413, /*	   sys exec;	*/
 /* 000002: */	0000014, /*	   init;	*/
 /* 000004: */	0000010, /*	   initp;	*/
 /* 000006: */	0000777, /*	   br .		*/
 /* 000010: */	0000014, /* initp: init;	*/
 /* 000012: */	0000000, /*	   0		*/
 /* 000014: */	0065457, /* init:  </k>		*/
 /* 000016: */	0064544, /*	   <di>		*/
 /* 000020: */	0027562, /*	   <r/>		*/
 /* 000022: */	0067151, /*	   <in>		*/
 /* 000024: */	0072151, /*	   <it>		*/
 /* 000026: */	0000000  /*	   000000	*/
};


uinit()
{	register int frame;
	register int id0, id1;
	/*	set up a working directory	*/
	u.u_cdir = iget( rootdev , ROOTINO );
	u.u_cdir->i_flag =& ~ILOCK;
	if (u.u_error)
	then	panic( "uinit" );

	/* I have no user portion, allocate him one page and copy
	   in a bootstrap */
	segfetch( 0, 0, _READ_WRITE_ACCESS, USERD, 8192,
			_PAGE_GROWS_UP_FROM_ZERO );
	id0 = frametab[USERD].f_id[0];
	id1 = frametab[USERD].f_id[1];
	segfetch( id0, id1, _READ_ACCESS, USERI, 8192,
			_PAGE_GROWS_UP_FROM_ZERO );
	if (u.u_error)
	then	panic( "first user segment" );

	u.u_tsize = 8192/64;
	u.u_dsize = 8192/64;
	u.u_ssize = 0;
	u.u_sep = true;

	copyout( icode, 0, sizeof icode );


	printf("Unix process %d initialized and ready\r\n",
		_proc_index);
}
/* name:
	idle

function:
	system idle loop

algorithm:
	move the idle pattern
	wait for something to happen (if nothing has happened yet)
	process the event
	return to caller

parameters:

returns:

globals:
	comm_blk
		qfront and qrear

calls:
	drain_q

called by:
	everyone

history:
	designed and coded by Mark Kampe
*/
idle()
{	if (pretty < 0) 
	then	pretty = (pretty << 1) | 1;
	else	pretty = pretty << 1;

	comm_blk->c_nop[0] = 000002;
	while( (comm_blk->c_qfront == comm_blk->c_qrear)
	     && (notified() == false) ) k_sleep();
	comm_blk->c_nop[0] = 000002;	/* rti (back to user state) */
	drain_q();
	return;
}

