/ PC-11 driver

pcvec	= 70
pcaddr	= 177550
npc = 1			/ # PC's
phiwater = 50.
plowater = 20.
rhiwater = 100.
rlowater = 20.

.globl	devpc

i.addr	= i.param
i.nropen=i.param+2
i.nwopen=i.param+3
i.ctl	= i.param+4
i.rawiq	= i.param+5
i.caniq	= i.param+6
i.canoq	= i.param+7

devpc:
	pcread
	pcwrite
	pcoread
	pcowrite
	pcclread
	pcclwrite

pcwrite:
	bic	$!377,r0
1:
	cmp	c.count(r1),$phiwater
	ble	1f
	jsr	pc,sleep
	br	1b
1:
	movb	i.canoq(r4),r1
	jsr	pc,putc
		br 2f			/ no room
	jsr	pc,startpc
	rts	pc
2:
	jsr	pc,timeout
	br	1b

pcread:
	movb	i.caniq(r4),r1
	cmpb	i.ctl(r4),$4		/ input choked?
	bne	1f
	cmp	c.count(r1),$rlowater
	bgt	1f
	mov	$101,*i.addr(r4)	/ enable reader
	movb	$4,i.ctl(r4)		/ normal read
1:
	jsr	pc,getc			/ any characters?
		br 2f
	add	$2,(sp)
	rts	pc
2:
	cmpb	i.ctl(r4),$6		/ eof?
	bne	1f
	clr	*i.addr(r4)		/ IE off
	rts	pc
2:
	jsr	pc,sleep
	br	pcread

pcoread:
	jsr	pc,pcopen
	tstb	i.nropen(r4)
	beq	1f
	mov	$101,*$pcaddr		/ enable first character
	clrb	i.ctl(r4)
1:
	incb	i.nropen(r4)
	rts	pc

pcowrite:
	jsr	pc,pcopen
	incb	i.nwopen(r4)
	mov	$100,pcaddr+4		/ IE
	rts	pc

pcopen:
	jsr	pc,ttyopen
	cmpb	i.nused(r4),$1		/ first open?
	bne	1f
	mov	$pcvec,r0		/ set up PC vector
	mov	$pcrint,(r0)+
	mov	$200,(r0)+
	mov	$pcpint,(r0)+
	mov	$200,(r0)+
	mov	r4,pcinode		/ remember inode
1:
	rts	pc

pcclread:
	decb	i.nropen(r4)		/ # read opens
	br	1f

pcclwrite:
	decb	i.nwopen(r4)		/ # write opens
1:
	cmpb	i.nused(r4),$1		/ final close?
	bne	1f
	jsr	pc,ttyclose
	clr	pcinode
1:
	rts	pc

/ start PC output, both at punch
/ interrupt and on the top half

startpc:
	tstb	*$pcaddr+4		/ PC PSR
	bpl	1f			/ still busy
	jsr	pc,getc
		br 1f			/ none
	mov	r0,*$pcaddr+6		/ punch char
1:
	rts	pc

/ PC reader interrupt

pcrint:
	jsr	r0,setisp
	mov	pcinode,r4
	beq	pcret			/ closed
	movb	i.ctl(r4),r0
	movb	i.caniq(r4),r1
	jmp	*1f(r0)

1:
	waitok
	pcok
	choke
	rderr

waitok:
	tst	*$pcaddr		/ wait open; test error
	bmi	2f			/ still offline
	movb	$2,i.ctl(r4)		/ online now
	br	pcok
2:
	mov	$15.,r0
	jsr	pc,ccall		/ offline, wait .25 sec
		br 2f
	br	pcret
2:
	inc	*$pcaddr		/ reenable reader
	br	pcret

pcok:
	tst	*$pcaddr		/ check error
	bmi	rderr
	mov	*$pcaddr+2,r0
	jsr	pc,putc
		br rderr
	cmp	c.count(r1),$rhiwater	/ check choking
	bge	2f
	inc	*$pcaddr		/ reenable reader
	cmp	c.count(r1),$rlowater
	bgt	pcret
	jsr	pc,wakeup		/ wake up top half
	br	pcret
2:
	movb	$4,i.ctl(r4)		/ set choke mode
	br	pcret

choke:
rderr:
	movb	$6,i.ctl(r4)		/ mark error
	jsr	pc,wakeup
	br	pcret

/ PC punch interrupt

pcpint:
	jsr	r0,setisp
	jsr	pc,startpc
	movb	i.canoq(r4),r1
	cmp	c.count(r1),$plowater
	bge	pcret
	jsr	pc,wakeup		/ wake up top half
	br	pcret

pcret:
	jmp	retisp

.bss
pcinode:.=.+2
.text

