	subroutine cpoly(op,degree,zero,fail)
	common /global/ p, h, qp, qh, shr, shi, s, t, pv, are,
&		mre, eta, infin, nn
	doublecomplex s, t, pv, p(15), h(15), qp(15), qh(15)
	doubleprecision are, mre, eta, infin, shr(15), shi(15)
	doubleprecision xx,yy,cosr,sinr,smalno,base,xxx
	doubleprecision bnd,scale,cauchy
	doublecomplex zero(16), z, op(16)
	logical fail,conv
	integer degree,cnt1,cnt2

	call mcon(eta,infin,smalno,base)
	are = eta
	mre = 2.0d0*dsqrt(2.0d0)*eta
	xx = .70710678
	yy = -xx
	cosr = -.060756474
	sinr = .99756405
	fail = .false.
	nn = degree+1

c fail if leading coefficient is 0

	if (op(1) .ne. (0.0d0,0.0d0)) goto 10
		fail = .true.
		return

c remove any zeros at the origin

10	if (op(nn) .ne. (0.0d0,0.0d0)) goto 20
		idnn2 = degree-nn+2
		zero(idnn2) = (0.0d0,0.0d0)
		nn = nn-1
		goto 10

c copy the coefficients

20	do 30 i = 1,nn
		p(i) = op(i)
		shr(i) = dcabs(p(i))
30	continue

c scale the polynomial

	bnd = scale(nn,shr,eta,infin,smalno,base)
	if (bnd.eq.1.0d0) goto 40
	do 35 i = 1,nn
		p(i) = p(i) * dcmplx(bnd,0.0d0)
35	continue

c start the algorithm for one zero

40	if (nn.gt.2) goto 50

c calculate the final zero and return

		zero(degree) =  -p(2) / p(1)
		return

c calculate bnd, a lower bound on the modulus of the zeros

50	do 60 i = 1,nn
		shr(i) = dcabs(p(i))
60	continue
	bnd = cauchy(nn,shr,shi)

c outer loop to control 2 passes with different sequences
c of shifts

	do 100 cnt1 = 1,2
		print 1000
1000		format(" Advance cnt1.")

c first stage calculation, no shifts

		call noshft(5)

c inner loop to select a shift

		do 90 cnt2 = 1,9
			print 1001
1001			format(" Advance cnt2.")

c shift is chosen with modulus bnd and amplitude rotated
c by 94 degrees from the previous shift

			xxx = cosr*xx-sinr*yy
			yy = sinr*xx + cosr*yy
			xx = xxx
			s = dcmplx(bnd*xx, bnd*yy)

c second stage calculation, fixed shift

			call fxshft(10*cnt2, z, conv)
			if (.not. conv) goto 80

c the second stage jumps directly to the third stage
c iteration.  if successful the zero is stored and the
c polynomial deflated

				idnn2 = degree-nn+2
				zero(idnn2) = z
				nn = nn-1
				do 70 i = 1,nn
					p(i) = qp(i)
70				continue
				goto 40
80			continue

c if the iteration is unsuccessful, another shift is chosen

90		continue

c if 9 shifts fail, the outer loop is repeated with another
c sequence of shifts

100	continue

c the zerofinder has failed on 2 major passes.
c return empty-handed

	fail = .true.
	return
	end
