	doubleprecision function cauchy(nn,pt,q)

c cauchy computes a lower bound on the moduli of the zeros of a
c polynomial - pt is the modulus of the coefficients

	doubleprecision q(nn),pt(nn),x,xm,f,dx,df

	pt(nn) = -pt(nn)

c compute upper estimate of bound.

	n = nn-1
	x = dexp((dlog(-pt(nn)) - dlog(pt(1)))/float(n))
	if (pt(n).eq.0.0d0) goto 20

c if newton step at the origin is better, use it.

		xm = -pt(nn)/pt(n)
		if (xm .lt. x) x = xm

c chop the interval (0,x) until f<=0

20	xm = x*.1d0
	f = pt(1)
	do 30 i = 2,nn
		f = f*xm + pt(i)
30	continue
	if (f.le. 0.0d0) goto 40
		x = xm
		goto 20
40	dx = x

c do newton iteration until x converges to two decimal places.

50	if (dabs(dx/x) .le. .005d0) goto 70
		q(1) = pt(1)
		do 60 i = 2,nn
			q(i) = q(i-1)*x + pt(i)
60		continue
		f = q(nn)
		df = q(1)
		do 65 i = 2,n
			df = df*x+q(i)
65		continue
		dx = f/df
		x = x - dx
		goto 50
70	cauchy = x
	return
	end
