/*

	C debugger

*/

main(argc, argv)
char argv[][];
{
	extern fsym, fcore;
	extern ubreak[], ur0[], uregs[], regbuf[], usp[];
	extern usavps[], ucore[], uusp[], uuusp[];
	extern line, lp, symoff, pc, r5, symlen, errflg;
	char line[], lp[];
	char corfil[], symfil[];

	if (argc<2)
		corfil = "core";
	else
		corfil = argv[1];
	if (argc<3)
		symfil = "a.out";
	else
		symfil = argv[2];
	if ((fcore = open(corfil, 0)) < 0) {
		printf("%s not found\n", corfil);
		return;
	}
	if ((fsym = open(symfil, 0)) < 0) {
		printf("%s not found", symfil);
		return;
	}
	read(fsym, regbuf, 020);
	if (regbuf[0] != 0407) {	/* magic */
		printf("Bad format: %s\n", symfil);
		return;
	}
	symoff = regbuf[1] + regbuf[2];
	symlen = regbuf[4];
	if (regbuf[7] != 1)
		symoff =<< 1;
	symoff =+ 020;
	seek(fcore, -512, 2);
	read(fcore, regbuf, 512);
	usp = &regbuf[0];
	uusp = &regbuf[1];
	uuusp = &regbuf[2];
	ubreak = &regbuf[3];
	ur0 = &regbuf[4];
	usavps = &regbuf[5];
	ucore = &regbuf[6];
	*ubreak =- *ucore;
	uregs = &regbuf[256];
	setexit();
loop:
	lp = line;
	while ((*lp++ = getchar()) != '\n');
	printtrace();
lp = -2;
goto lp;
}

printtrace()
{
	extern uregs[], r5, pc, errflg, ssymbol;
	int tpc, tr5, narg, argp;

	tpc = uregs[pc];
	tr5 = uregs[r5];
	while (errflg == 0) {
		narg = findroutine(tpc, tr5);
		printf("%s(", ssymbol);
		if (--narg >= 0)
			printf("%o", get(tr5+4));
		argp = tr5+4;
		while(--narg >= 0)
			printf(",%o", get(argp =+ 2));
		printf(")\n");
		tpc = get(tr5+2);
		if ((tr5 = get(tr5)) == 0)
			break;
	}
}

findroutine(pc, r5)
{
	extern errflg;
	int callpt, inst;

	callpt = get(r5+2);
	if (get(callpt-4) != 04777)	/* jsr pc,*... */
		errflg++;
	vallook(callpt + get(callpt-2));
	inst = get(callpt);
	if (inst == 05726)		/* tst (sp)+ */
		return(1);
	if (inst == 022626)		/* cmp (sp)+,(sp)+ */
		return(2);
	if (inst == 062706)		/* add $n,sp */
		return(-(get(callpt+2))/2);
	return(0);
}

vallook(value)
{
	extern symbol, symflg, symval, errflg;
	char symbol[];

	symset();
	while(symget())
		if (symval == value & (symflg&037) == 2) {
			savsym('_');
			return;
		}
	errflg++;
}

get(addr)
{
	extern fcore, errflg, ubreak[], uuusp[];
	int w;

	w = 0;
/* printf("{%o,", addr); */
	if (addr >= *ubreak)
		if (addr >= *uuusp)
			addr =+ *ubreak - *uuusp;
		else
			addr = -1;
	seek(fcore, addr, 0);
	if (read(fcore, &w, 2) < 2)
		errflg++;
/* printf("%o,%o}", w, errflg); */
	return(w);
}

symset()
{
	extern fsym, symoff, symlen, symct;

	symct = symlen;
	seek(fsym, symoff, 0);
}

symget()
{
	extern symbol, symct, fsym;
	char symbol[];

	if ((symct =- 12) < 0)
		return(0);
	return(read(fsym, symbol, 12) == 12);
}

savsym(skip)
{
	char p[], q[], symbol[], ssymbol[];
	int ch;
	extern symbol, ssymbol, symflg, ssymflg, symval, ssymval;

	p = symbol;
	q = ssymbol;
	while (ch = *p++) {
		if (ch == skip)
			continue;
		*q++ = ch;
	}
	while (q < ssymbol+8)
		*q++ = '\0';
	ssymflg = symflg;
	ssymval = symval;
}

fcore;
fsym;
symoff;
lp;
errflg;
symlen;
symct;
symbol[4];
symflg;
symval;
ssymbol[4];
ssymflg;
ssymval;
line[64];
regbuf[256];
usp;
uusp;
uuusp;
ubreak;
ucore;
ur0;
usavps;
uregs;
pc -2;
r5 -8;

