int	comp();
struct
{
	char	crap[32];
	long	mdate;
} statb;
struct obj
{
	int	flag;
	char	name[14];
	long	date;
} obj[50];
struct
{
	int	ino;
	char	name[14];
	char	pad[2];
} dir;

main(argc, argv)
char *argv[];
{
	register i;
	register struct obj *objp;
	struct obj *eobj;
	int f, t;

	if(argc == 2 && chdir(argv[1]) == 0)
		argc--;
	f = open(".", 0);
	if(f < 0) {
		printf("cannot open .\n");
		exit();
	}
	objp = obj;
	dir.pad[0] = 0;
	/*
	 * init table with args
	 */
	for(t=1; t<argc; t++) {
		for(i=0; argv[t][i]; i++)
			;
		if(i >= 2 && argv[t][i-2] == '.')
			i =- 2;
		if(i == 0)
			continue;
		for(i--; i>=0; i--)
			objp->name[i] = argv[t][i];
		objp++;
	}
	/*
	 * pass 1 -- find the object files
	 */
	for(;;) {
		if(read(f, &dir, 16) != 16)
			break;
		if(dir.ino == 0)
			continue;
		for(i=0; dir.name[i]; i++)
			;
		if(i < 3)
			continue;
		if(dir.name[i-2] != '.' || dir.name[i-1] != 'o')
			continue;
		if(stat(dir.name, &statb) != 0)
			continue;
		objp->date = statb.mdate;
		for(i =- 3; i >= 0; i--)
			objp->name[i] = dir.name[i];
		objp++;
	}
	eobj = objp;
	qsort(obj, eobj-obj, sizeof obj[0], &comp);

	/*
	 * pass2 -- find corresponding source
	 */
	seek(f, 0, 0);
	for(;;) {
		if(read(f, &dir, 16) != 16)
			break;
		if(dir.ino == 0)
			continue;
		for(i=0; dir.name[i]; i++)
			;
		if(i < 3 || dir.name[i-2] != '.')
			continue;
		t = dir.name[i-1];
		if(t == 'o')
			continue;
		for(i =- 2; i < 14; i++)
			dir.name[i] = 0;
		for(objp = obj; objp < eobj; objp++)
			if(comp(&dir, objp) == 0)
				goto out;
		continue;
	out:
		suffix(objp, t);
		if(stat(dir.name, &statb) != 0)
			continue;
		if(objp->date >= statb.mdate)
			continue;
		objp->flag = t;
	}
	close(f);
	/*
	 * pass3 -- compile
	 */
	for(objp = obj; objp < eobj; objp++) {
		t = objp->flag;
		if(t == 0)
			continue;
		suffix(objp, t);
		printf("%s:\n", dir.name);
		switch(t) {

		case 'c':
			ex("cc", "-c", dir.name, 0);
			continue;

		case 's':
			ex("as", dir.name, 0);
			suffix(objp, 'o');
			ex("mv", "a.out", dir.name, 0);
			continue;

		case 'f':
			ex("fc", "-c", dir.name, 0);
			continue;

		case 'r':
			ex("rc", "-c", dir.name, 0);
			continue;

		case 'y':
			ex("yacc", dir.name, 0);
			ex("cc", "-c", "y.tab.c", 0);
			suffix(objp, 'o');
			ex("mv", "y.tab.o", dir.name, 0);
			continue;
		}
		printf("no procedure for `%c'\n", t);
	}
}

comp(p1, p2)
struct obj *p1, *p2;
{
	register a, i;

	for(i=0; i<14; i++) {
		a = p1->name[i] - p2->name[i];
		if(a)
			return(a);
	}
	return(0);
}

suffix(p, c)
struct obj *p;
{
	register i;

	for(i=0; p->name[i]; i++)
		dir.name[i] = p->name[i];
	dir.name[i] = '.';
	dir.name[i+1] = c;
	dir.name[i+2] = 0;
}

ex(args)
char *args;
{
	register i, c;
	char com[20];

	for(i=0; c="/usr/bin/"[i]; i++)
		com[i] = c;
	for(c=0; args[c]; c++)
		com[i++] = args[c];
	com[i] = 0;
	if(fork() == 0) {
		execv(com+4, &args);
		execv(com, &args);
		printf("cannot execute %s\n", args);
		exit();
	}
	while(wait() != -1);
		;
}
