	.even
/"read ASCII date and return binary" subroutine
/ input
/	2(sp) -> address of beginning of ASCII date
/	(sp) -> old r5
/
/ output
/	r0 = year(bit 15-9)/day(bits 8-0)
/	r0 = 0 if illegal date
/
rdate:
	mov	r1,-(sp)	/save regs
	mov	r2,-(sp)
	mov	r3,-(sp)
	clr	dfields		/initialize subfields
	clr	dfields+2
	clr	dfields+4
	clr	r1	/initialize 1st subfield looked at
	clr	r2	/initialize 1st digit being looked at
0:
	cmpb	*8(sp),$'\n	/is it <newline> char?
	beq	1f	/branch if yes
	cmpb	*8(sp),$'/	/is it "/"?
	beq	2f	/branch if yes
	cmpb	*8(sp),$60
	blo	9f	/branch if not dec digit
	cmpb	*8(sp),$71
	bhi	9f	/branch if not dec digit
	cmp	r2,$1	/how many digits preceded this?
	bhi	9f	/error branch if 2
	inc	r2	/inc. no. digits in this subfield
	cmp	r2,$1	/is it 1st digit?
	bne	3f	/branch if no
	movb	*8(sp),dfields(r1)	/move to subfield
	sub	$60,dfields(r1)	/change to binary
	inc	8(sp)	/increment to next char
	br	0b	/go to top loop
3:
	mov	dfields(r1),mq
	mov	$10.,mul	/mult. subfield by 10. and store
	mov	mq,dfields(r1)
	movb	*8(sp),r3
	sub	$60,r3
	add	r3,dfields(r1)	/add 2nd digit to subfield
	inc	8(sp)	/inc to next char
	br	0b	/go to top loop
/it's a <newline> char
1:
	cmp	r1,$4	/are there 3 subfields?
	bne	9f	/error branch if no
	cmp	r2,$2	/are there 2 digits for 3rd subfield
	bne	9f	/error branch if no
	mov	dfields+2,-(sp)		/move day onto stack
	swab	dfields+4
	bis	dfields+4,dfields
	mov	dfields,-(sp)	/move yr/mo onto stack
	jsr	r5,idate	/jump to sub to crunch into 1 bin word
4:
	mov	(sp)+,r3	/restore regs
	mov	(sp)+,r2
	mov	(sp)+,r1
	mov	(sp)+,(sp)	/return to caller
	rts	r5
/control here if "/"
2:
	cmp	r1,$2	/is this 3rd "/" encountered
	bhi	9f	/error branch if yes
	tst	r2	/no digit preceded "/"?
	beq	9f	/error branch if yes
	add	$2,r1	/increment by 2 for each new subfield
	clr	r2	/reinitialize looking for 1st digit
	inc	8(sp)	/inc to next char
	br	0b	/go to top loop
/error return
9:
	clr	r0	/indicates illegal date to caller
	br	4b
dfields:
	.=.+2	/storage for mo/day/yr subfields
	.=.+2
	.=.+2

/"convert date to internal binary" subroutine
/ input
/	4(sp) -> day of month
/	2(sp) -> year/month
/	(sp) -> old r5
/ output
/	r0 = year(bits 15-9)/day(bit 8-0)
/	r0 = 0 if illegal date
idate:
	mov	r1,-(sp)	/save r1
	cmp	6(sp),$31.	/is day of month > 31.?
	bhi	9f	/error branch if yes
	cmpb	5(sp),$99.	/check year
	bhi	9f	/error if not in range
	cmpb	4(sp),$12.	/check month
	bhi	9f	/error if not in range
	decb	4(sp)		/allows month to be used as index
	movb	4(sp),r1
	bitb	$3,5(sp)	/is it leap year?
	bne	2f	/branch if not leap year
	cmp	r1,$1	/is month Feb?
	bne	0f	/branch if not
	cmp	6(sp),$29.	/is Feb day > 29.?
	bhi	9f	/error branch if yes
	br	3f
0:
	cmpb	6(sp),months(r1)	/too many days in month?
	bhi	9f	/error branch if yes
1:
	cmp	r1,$1	/is month after Feb?
	blos	2f	/branch if not
	inc	6(sp)	/add 1 day for Feb 29.
	br	3f
2:
	cmpb	6(sp),months(r1)	/is day of month over max for month
	bhi	9f	/error branch if yes
3:
	dec	r1
	blt	4f
	movb	months(r1),r0
	add	r0,6(sp)	/add months days to total
	br	3b
4:
	bicb	$377,4(sp)	/clear month field from yr/mo
	asl	4(sp)	/shift year into bits 15-9
	bis	4(sp),6(sp)	/form binary date
/ normal return sequence
5:
	mov	6(sp),r0
6:
	mov	(sp)+,r1	/restore r1
	mov	(sp),4(sp)	/ move old r5 up 2 words on stack
	cmp	(sp)+,(sp)+	/pop 2 words off stack
	rts	r5
/error return
9:
	clr	r0
	br	6b
