/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)HashName.c	1.4 85/08/10
*/

/*
**	Calculate hash for a node name.
*/

#include	<ctype.h>
#include	<setjmp.h>

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"node.h"


jmp_buf		NameErrJmp;



int
HashName(name)
	char *		name;
{
	register char *	cp = name;
	register int	hash;
	register int	c;
	register int	n = 0;
#	if	CRC_HASH == 1
	char		nn[NODE_NAME_SIZE+1];
	register char *	np = nn;
#	endif	CRC_HASH == 1

#	if	CRC_HASH == 0
	hash = 0;
#	endif	CRC_HASH == 0

	while ( c = *cp++ )
	{
		if ( ++n > NODE_NAME_SIZE || (!isalnum(c) && c != '_' && c != '-') )
		{
			longjmp(NameErrJmp, n+1);
			return 0;
		}

#		if	CRC_HASH == 0
		HASH(hash, c|040);
#		else	CRC_HASH == 0
		*np++ = c|040;
#		endif	CRC_HASH == 0
	}

	if ( n == 0 )
	{
		longjmp(NameErrJmp, 1);
		return 0;
	}

#	if	CRC_HASH == 1
	*np = '\0';
	hash = acrc((Crc_t)0, nn, n);
#	endif	CRC_HASH == 1

	Trace3(3, "\"%s\" hash = %#x", name, hash);

#	if	CRC_HASH == 0
#	ifdef	HASH_MASK
	return (hash ^ (hash>>(16-HASH_BITS))) & HASH_MASK;
#	else	HASH_MASK
	return (int)(((unsigned)hash ^ ((unsigned)hash>>(16-HASH_BITS))) % (unsigned)HASH_SIZE);
#	endif	HASH_MASK

#	else	CRC_HASH == 0

#	ifdef	HASH_MASK
	return hash & HASH_MASK;
#	else	HASH_MASK
	return (int)((unsigned)hash % (unsigned)HASH_SIZE);
#	endif	HASH_MASK
#	endif	CRC_HASH == 0
}
