/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SplitAddress.c	1.1 84/06/12
*/

/*
**	Extract parts of address from given string.
**	Returns pointer to new structure containing parts.
*/

#include	"global.h"
#include	"address.h"



Address *
SplitAddress(address)
	char *			address;
{
	register char *		cp;
	register char **	cpp;
	register char *		np;
	register Address *	addrp = Talloc(Address);

	if ( (cp = address) == NULLSTR )
		address = cp = "";

	addrp->ad_domains = 0;

	while ( (cp = strchr(cp, DOMAIN_SEP)) != NULLSTR )
	{
		addrp->ad_domains++;
		cp++;
	}
	
	addrp->ad_strings = cpp = (char **)Malloc((addrp->ad_domains+1)*sizeof(char *));

	for ( cp = address ; ; )
	{
		if ( (np = strchr(cp, DOMAIN_SEP)) != NULLSTR )
			*np = '\0';

		*cpp++ = newstr(cp);

		if ( (cp = np) != NULLSTR )
			*cp++ = DOMAIN_SEP;
		else
			break;
	}

	return addrp;
}
