/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)FindNode.c	1.5 85/02/20
*/

/*
**	Given node name, find link on shortest path.
**
**	Uses binary search to find node in routing tables.
**
**	If link found, return 'true' with details in "*nlp".
**
**	If a shortest path cannot be found,
**	return 'false' with an error reason in nlp->nl_name.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"


bool
FindNode(node, type, nlp)
	char *		node;	/* Node to be located */
	Path_t		type;	/* Type of route */
	NodeLink *	nlp;	/* Where to put the info. */
{
	register char *	cp1;	/* String comparison temporary */
	register char *	cp2;	/* String comparison temporary */
	register char *	l;	/* First node in table */
	register char *	u;	/* Last node in table */
	register int	n;	/* Number of nodes in table */
	register char *	i;	/* Approximate middle node in table*/

	Trace3(1, "FindNode to \"%s\" type %d", node, (int)type);

	if ( RouteBase == NULLSTR )
		if ( !ReadRoute() )
		{
			nlp->nl_name = "unknown (no routing table)";
			return false;
		}

	nlp->nl_index = LINK_N_A;
	nlp->nl_domind = LINK_N_A;

	n = NodeCount-2;
	l = NodeTable;
	u = &l[NODE_ENTRY_SIZE * n];

	while ( u >= l )
	{
		i = &l[NODE_ENTRY_SIZE * (n/2)];

#		if	DEBUG
		if ( Traceflag >= 2 )
		{
			int	index;
			char *	name;

			if ( (index = ((NodeEntry *)i)->ne_shortest[(int)type]) == LINK_N_A )
			{
				index = -1;
				name = "(N/A)";
			}
			else
			{
				index = RT_LINK(index)->le_index;
				name = RT_NODE(index)->ne_name;
			}

			Trace
			(
				2,
				"FindNode => \"%s\", link index %d, node index %d, node name \"%s\"",
				((NodeEntry *)i)->ne_name,
				((NodeEntry *)i)->ne_shortest[(int)type],
				index,
				name
			);
		}
#		endif	DEBUG

		for
		(
			cp1 = node, cp2 = ((NodeEntry *)i)->ne_name ;
			((*cp1)|040) == ((*cp2++)|040) ;
		)
		{
			if ( *cp1++ != '\0' )
				continue;

			if ( (n = ((NodeEntry *)i)->ne_shortest[(int)type]) == LINK_N_A )
			{
				nlp->nl_name = "unreachable";
				return false;
			}

			l = (char *)RT_LINK(n);

			nlp->nl_link = n;
			nlp->nl_name = RT_NODE(((LinkEntry *)l)->le_index)->ne_name;
			nlp->nl_flags = ((LinkEntry *)l)->le_flags;
			nlp->nl_index = (i-NodeTable)/NODE_ENTRY_SIZE;
			nlp->nl_domind = ((NodeEntry *)i)->ne_primary;

			if ( n = ((LinkEntry *)l)->le_handlers[PT_MSG] )
				nlp->nl_spooler = &Strings[n];
			else
				nlp->nl_spooler = NULLSTR;

			if ( n = ((LinkEntry *)l)->le_handlers[PT_CON] )
				nlp->nl_connector = &Strings[n];
			else
				nlp->nl_connector = NULLSTR;
			
			if ( n = ((LinkEntry *)l)->le_caller )
				nlp->nl_caller = &Strings[n];
			else
				nlp->nl_caller = NULLSTR;

			return true;
		}

		if ( (*cp1|040) < (*--cp2|040) )
			u = i-NODE_ENTRY_SIZE;
		else
			l = i+NODE_ENTRY_SIZE;

		n = (u-l)/NODE_ENTRY_SIZE;
	}

	nlp->nl_name = "unknown";

	return false;
}
