/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)FindAddress.c	1.4 85/05/04
*/

/*
**	Return true if address is known,
**	(know route to node, or nearest domain),
**	fill NodeLink structure with the route details,
**	if home domains found, make up a new reduced address in "dest".
*/

#include	"global.h"
#include	"address.h"
#include	"debug.h"
#include	"state.h"

#include	"route.h"



bool
FindAddress(dest, nlp)
	char *		dest;
	NodeLink *	nlp;
{
	register char *	cp;

	Trace2(1, "FindAddress \"%s\"", dest);

	if ( (cp = strchr(dest, DOMAIN_SEP)) != NULLSTR )
	{
		register Address *	address = SplitAddress(dest);
		register char **	cpp;
		register int		i;

		/*
		**	Search back through domain hierarchy
		*/

		for
		(
			i = address->ad_domains,
			cpp = &address->ad_strings[i] ;
			i > 0 ;
		)
		{
			register int	hier;

			if ( !FindDomain(*cpp--, nlp) )
			{
				FreeAddress(address);
				return false;
			}

			if ( nlp->nl_link != (NodeCount-1) )
			{
				/*
				**	Foreign domain encountered,
				**	so use route to it.
				**
				**	Make up new reduced destination address.
				*/

				if ( i != address->ad_domains )
					for
					(
						cpp = address->ad_strings,
						cp = dest ;
						;
					)
					{
						cp = strcpyend(cp, *cpp++);

						if ( i-- > 0 )
							*cp++ = DOMAIN_SEP;
						else
							break;
					}

				FreeAddress(address);
				return true;
			}

			i--;

			if
			(
				(hier = RT_DOMAIN(nlp->nl_domind)->de_hierarchy) != LINK_N_A
				&&
				i > hier	/* Wrong place in hierarchy */
			)
				return false;	/* Can't resolve this address */

			Trace2(2, "FindAddress discard home domain \"%s\"", cpp[1]);
		}

		/*
		**	Recognised home domain hierarchy,
		**	so the node name is unique.
		*/

		*cp = '\0';

		FreeAddress(address);

		Trace2(2, "FindAddress with unique node name \"%s\"", dest);
	}

	if
	(
		!FindNode(dest, pt_msg, nlp)
		&&
		(
			!FindDomain(dest, nlp)
			||
			nlp->nl_link == (NodeCount-1)
		)
	)
		return false;

	return true;
}
