/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)TimeString.c	1.1 84/06/12
*/

/*
**	Return time in form "nnnXnnY" where X&Y can be any of 'd','h','m','s'.
*/

#include	"global.h"


static bool	zero;		/* TRUE if value printed is zero */
static char *	ptn();



char *
TimeString(time)
	register ulong	time;
{
	register int	trac;
	register int	sepc;
	register int	divn;
	static char	s[8];

	sepc = 'm';
	trac = 's';
	divn = 60;

	if ( time > 3599 )	/* more than 60 mins. */
	{
		trac = sepc;
		sepc = 'h';
		time /= 60;

		if ( time > 10080 )	/* more than 1 week */
		{
			trac = sepc;
			sepc = 'd';
			divn = 24;
			time /= 60;

			if ( time > 23999 )	/* more than 1000 days */
				trac = 0;
		}
	}

	zero = true;

	if ( trac == 0 )
	{
		time /= divn;
		(void)ptn(time, s, 6);
		s[6] = sepc;
	}
	else
	{
		(void)ptn(time/divn, s, 3);
		s[3] = zero ? ' ' : sepc;
		(void)ptn(time%divn, &s[4], 2);
		s[6] = zero ? '0' : trac;
	}

	s[7] = '\0';

	for ( trac = 0 ; s[trac] == ' ' ; trac++ );

	return &s[trac];
}



/*
**	Put a decimal number into string with leading spaces.
*/

static char *
ptn(t, s, n)
	register ulong	t;
	register char *	s;
	register int	n;
{
	if ( --n )
		s = ptn(t/10, s, n);

	if ( (t %= 10) || !zero )
	{
		zero = false;
		*s++ = t + '0';
	}
	else
		*s++ = ' ';

	return s;
}
