/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)DaemonActive.c	1.5 85/07/25
*/

/*
**	Return true if daemon for given link is active
*/

#define	FILE_CONTROL

#include	"global.h"
#include	"debug.h"

#include	"command.h"
#include	"spool.h"
#include	"Stream.h"

#include	<errno.h>

#if	KILL_0 != 1
#include	<signal.h>
#endif	KILL_0 != 1



bool
DaemonActive(path, calling)
	char *		path;
	bool		calling;
{
	register int	fd;
	register int	i;
	char *		statusfile;
	NN_state	nnstate;

	statusfile = concat(path, "/", STATUSFILE, NULLSTR);

	Trace3(1, "DaemonActive(%s) -> \"%s\"", path, statusfile);

	if ( access(statusfile, 4) == SYSERROR )
	{
		free(statusfile);
		return false;
	}

	for ( i = 0 ; i < 3 ; i++ )
	{
		if ( (fd = open(statusfile, O_READ)) != SYSERROR )
		{
			if ( read(fd, (char *)&nnstate, sizeof nnstate) == sizeof nnstate )
			{
				(void)close(fd);
				free(statusfile);

				if ( strcmp(StreamSCCSID, nnstate.version) != STREQUAL )
				{
					Warn("\"status\" file version mismatch");
					return false;
				}

				if ( nnstate.procid == 0 )
					return false;

				Trace2(2, "DaemonActive pid %d", nnstate.procid);

				if
				(
					kill(nnstate.procid, SIG0) == SYSERROR
					&&
					errno != EPERM
				)
					return false;

				if ( nnstate.procstate == PROC_CALLING )
					return calling;

				return true;
			}

			(void)close(fd);
		}

		(void)sleep(1);
	}

	if ( fd != SYSERROR )
		(void)close(fd);

	free(statusfile);

	return false;
}
