/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)address.h	1.3 85/05/04
*/

/*
**	Address types:
**
**	The following leading characters in a destination address string
**	identify the address type.
*/

#define	ATYP_MULTICAST	','
#define	ATYP_BROADCAST	'*'
#define	ATYP_EXPLICIT	'!'
#define	ATYP_GROUP	'&'

/*
**	Anything else is a single address.
*/

#define	DOMAIN_SEP	'.'		/* Character to separate domains in address */

#define	EXCL_HIER	0x4000		/* Value used to exclude domains only mentioned in hierarchy */
#define	INCL_HIER	0

/*
**	Addresses may take the following forms:-
**
**	address		::=	group | explicit | multicast | broadcast | destination
**	group		::=	<&>{explicit|multicast|broadcast|destination}<&>...
**	explicit	::=	<!>{multicast|broadcast|destination}<!>...
**	multicast	::=	<,>{broadcast|destination}<,>...
**	broadcast	::=	<*>[<.>{<*>|domain}]
**	destination	::=	node[<.>domain]
*/

/*
**	Structure for containing parts of an address
*/

typedef struct
{
	char **	ad_strings;	/* Pointers to parts */
	short	ad_domains;	/* Count of domain parts */
}
	Address;

#define	ad_node	ad_strings[0]	/* The first string is always the node name */

/*
**	Externals
*/

extern char *	HomeNode;

extern Address	*SplitAddress();
extern void	FreeAddress();

extern bool
		DestReached(),
		DoRoute(),
		HomeAddress(),
		HomeDomain();
