/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID %W% %E%
*/

/*
**	Send data/control to remote
*/

#include	"global.h"

#include	"Pconfig.h"
#include	"Packet.h"
#include	"Channel.h"
#include	"Pstats.h"
#include	"Proto.h"
#include	"Debug.h"



/*
**	Find an empty packet,
**	 fill it with data from the channel,
**	 and queue it for transmission.
**	Mark the channel active.
**
**	Assumes "channel" is in range.
*/

int
Psend(channel)
	int		channel;
{
	register Chn_p	chnp = &Channels[channel];
	register Pks_p	pksp = chnp->chn_nxpkt;
	register int	i;

	if ( chnp->chn_xstate != CHNS_RESET && chnp->chn_rstate != CHNS_RESET )
	for ( i = Pnbufs ; --i >= 0 ; )
	{
		if ( pksp->pks_state == XPS_NULL )
		{
			if ( (i = chnp->chn_xbfc) <= 0 )
			{
				if ( (i = (*PfillPkt)(channel, chnp->chn_xbuf, PBufMax)) <= 0 )
					return i;
				
				chnp->chn_xbfp = chnp->chn_xbuf;
				chnp->chn_xbfc = i;
			}

			if ( i > PXsize )
				i = PXsize;
			
			bcopy(chnp->chn_xbfp, pksp->pks_pkt.pkt_data, i);

			chnp->chn_xbfp += i;
			chnp->chn_xbfc -= i;

			Psendpkt
			(
				pksp,
				(PKTDATATYP << PKTTYP_S)
				 | (channel << PKTCHN_S)
				 | ((chnp->chn_xseq++ & PKTSEQ_M) << PKTSEQ_S),
				i
			);

			chnp->chn_xstate = CHNS_ACTIVE;
			return i;
		}

		if ( ++pksp >= &chnp->chn_xpkts[Pnbufs] )
			pksp = chnp->chn_xpkts;
	}

	return 0;
}



/*
**	Find an empty packet,
**	 fill it with control data from the channel,
**	 and queue it for transmission.
**	Mark the channel active.
*/

int
Psendc(channel, data, size)
	int		channel;
	char *		data;
	int		size;
{
	register int	i;
	register Chn_p	chnp = &Channels[channel];
	register Pks_p	pksp = chnp->chn_nxpkt;

	if
	(
		(unsigned)channel >= Pnchans
		||
		channel < Pfchan
		||
		size <= 0
		||
		(*data & CONTROL)
		||
		size > PXmax
	)
		return -1;					/* Illegal control packet */

	if
	(
		chnp->chn_xstate != CHNS_RESET
		&&
		chnp->chn_xbfc <= 0
		&&
		chnp->chn_rstate != CHNS_RESET
	)
	for ( i = Pnbufs ; --i >= 0 ; )
	{
		if ( pksp->pks_state == XPS_NULL )
		{
			bcopy(data, pksp->pks_pkt.pkt_data, size);

			Psendpkt
			(
				pksp,
				(PKTCNTLTYP << PKTTYP_S)
				 | (channel << PKTCHN_S)
				 | ((chnp->chn_xseq++ & PKTSEQ_M) << PKTSEQ_S),
				size
			);

			chnp->chn_xstate = CHNS_ACTIVE;
			return 1;
		}

		if ( ++pksp >= &chnp->chn_xpkts[Pnbufs] )
			pksp = chnp->chn_xpkts;
	}

	return 0;
}




/*
**	Add header and CRC to a data packet and queue it for transmission
*/

void
Psendpkt(pksp, hdr, size)
	register Pks_p	pksp;
	int		hdr;
	register int	size;
{
	pksp->pks_pkt.pkt_hdr[PKTHDR] = PprotoT|hdr;
	pksp->pks_pkt.pkt_hdr[PKTSIZE0] = size;
	pksp->pks_pkt.pkt_hdr[PKTSIZE1] = size >> 8;

	size += PKTHDRZ;

	pksp->pks_size = size;
	pksp->pks_xtime = 0;
	pksp->pks_state = XPS_WAIT;

	(*PqPkt)((char *)&pksp->pks_pkt, size);

	Logpkt(&pksp->pks_pkt, PLOGOUT);
	PSTATS(PS_XPKTS);
	Plastidle = 0;
}




/*
**	Add header and CRC to a control packet and queue it for transmission.
**	Assumes that only RESET packets have a size of 4.
*/

void
PsendCpkt(hdr, size, data)
	int		hdr;
	register int	size;
	char		data;
{
	Cntlpkt		cpkt;

	cpkt.cpk_hdr[PKTHDR] = PprotoT|hdr;

	cpkt.cpk_hdr[PKTSIZE0] = size;
	cpkt.cpk_hdr[PKTSIZE1] = size >> 8;

	switch ( size )
	{
	case 4:	cpkt.cpk_data[3] = PXsize >> 8;
		cpkt.cpk_data[2] = PXsize;
		cpkt.cpk_data[1] = Pnbufs;
	case 1:	cpkt.cpk_data[0] = data;
	}

	size += PKTHDRZ;

	(*PqCpkt)((char *)&cpkt, size);

	Logpkt((Pkt_p)&cpkt, PLOGOUT);
	PSTATS(PS_XPKTS);
	Plastidle = 0;
}
