#!/bin/sh -p
#
#	Search files in _bad directory, and prompt for action.
#
trap 'rm -f current; exit 0' 1 2 15

for i in `ls -tr [012]*`
do
	ln $i current
	echo `ls -l $i` [current]
	vis $i | MORE= more
	filedone=false
	until $filedone
	do
		echo 'Vis workfile (v), Move to link (m), Pass to receiver (p),\nRemove (r), Next (n), Shell (!<command>) ? \c'
		read reply
		case $reply
		in
		m|move)
			echo "Directory ? ../\c"
			read dir
			mv $i ../$dir
			filedone=true
			;;
		n|next)
			filedone=true
			;;
		p|pass)
			echo "arrived on link ? \c"
			read link
			/etc/su daemon -c "../_lib/receiver -L -l${link} -t100 $i"
			filedone=true
			;;
		r|remove|d|dp)
			rm $i
			filedone=true
			;;
		v|vis)
			echo "../_work/*\c"
			read work
			vis ../_work/*$work | MORE= more
			filedone=false
			;;
		!*)
			reply=`expr "$reply" : '!\(.*\)' | sed -e 's/%/'"$i"'/g'`
			echo "$reply"
			trap '' 2 3
			sh -c "$reply"
			trap 'rm -f current; exit 0' 2 3
			;;
		'')
			exit 0
			;;
		*)
			echo "[$i] Valid commands are m,n,p,r,v and !."
			;;
		esac
	done
	rm -f current
done
