/*
**	caller
**
**	Interacts with target system to setup a virtual circuit.
**
**	Bob Kummerfeld.
*/

static char	sccsid[]	= "@(#)caller.c	1.7 84/10/10";

#include	"global.h"

#include	"caller.h"



char *		Name;
char		input[LINESIZE+1];
char *		delim		= ":\n";
struct patlist *current;
struct patlist *cp;



main(argc, argv)
	int	argc;
	char	*argv[];
{
	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	init(argc, argv);

	for (;;)
	{
		if (cp->pattern == NULLSTR)
			reset();

		if (match(input, cp->pattern))
			(*cp->func)();
		else
			next();
	}
}



match(s, pat)
	char	*s;
	char	*pat;
{
	char	*cpat;
	int	result;

	if ((cpat = regcmp(pat, 0)) == NULLSTR)
	{
		out("fail cannot compile pattern - "); outend(pat);
		exit(1);
	}

	result = regex(cpat, s);
	free(cpat);
	return result;
}



getinput()
{
	register int	i;

	for (i = 0; i < LINESIZE; )
	{
		char	c;

		if (read(0, &c, 1) <= 0)
		{
			strcpy(input, EOFSTR);
			return;
		}

		if ( (c &= 0x7f) == 0 )
			continue;

		input[i++] = c;

		if (strchr(delim, c))
			break;
	}

	input[i] = '\0';
}



/*
**	output a string
**
*/

out(s)
	char	*s;
{
	write(1, s, strlen(s));
}



outend(s)
	char	*s;
{
	write(1, s, strlen(s)+1);
}



state(p)
	struct	patlist	*p;
{
	current = p;
	cp = current;
}



next()
{
	cp++;	/* move to next pattern */
}



reset()
{
	cp = current;
	getinput();
}



/*
**	Extract arguments from passed file,
**	and pass them back via the passed function
**	to look like program invoked arguments.
*/

bool
readargs(file, funcp)
	char *		file;
	int		(*funcp)();
{
	register char *	ap;
	VarArgs		va;

	if ( (ap = ReadFile(file)) == NULLSTR )
		return false;

	FIRSTARG(&va) = Name;
	SplitArg(&va, ap);
	(*funcp)(NARGS(&va), &ARG(&va, 0));
	free(ap);

	return true;
}



/*
**	Clean up after Error()
*/

void
finish(err)
	int	err;
{
	char	numb[12];

	sprintf(numb, "%d", err);
	out("fail error type "); outend(numb);

	exit(1);
}
