/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)SplitArg.c	1.3 84/10/26
*/

/*
**	Split argument into separate "VarArg" entries on white space.
*/

#include	"global.h"



void
SplitArg(to, arg)
	VarArgs *	to;
	register char *	arg;
{
	register char *	cp;
	static char	delim[]	= " \t\n";

	arg += strspn(arg, delim);

	while ( (cp = strpbrk(arg, delim)) != NULLSTR )
	{
		register int	c = *cp;

		*cp = '\0';
		NEXTARG(to) = newstr(arg);
		*cp++ = c;
		arg = cp + strspn(cp, delim);
	}

	if ( *arg )
		NEXTARG(to) = newstr(arg);
}
