/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)GetErrFile.c	1.6 84/10/30
*/

/*
**	Read in an error file created by 'Execute', remove it,
**	and return a pointer to a string containing error message.
*/

#define	FILE_CONTROL
#define	STAT_CALL

#include	"global.h"
#include	"debug.h"


#define	MAX_ERR_LEN	2000

static char	Str1[]		= "Bad exit status ";
static char	Str2[]		= " signal ";
static char	Str3[]		= " from:-\n\"";
static char	Str4[]		= "\"\nstderr <<EOF\n";
static char	Str5[]		= "EOF\n";
static char	StrCore[]	= " (core dumped)";


char *
GetErrFile(va, status, fd)
	VarArgs *	va;
	int		status;
	int		fd;
{
	register int	size;
	register char *	cp;
	register char **cpp;
	struct stat	statb;
	char *		errs;
	char		number[4];

	size = 2;	/* for terminating '\n' + '\0' */

	if ( fstat(fd, &statb) == SYSERROR )
		statb.st_size = 0;
	else
	{
		if ( statb.st_size > MAX_ERR_LEN )
			statb.st_size = MAX_ERR_LEN;
		size += (int)statb.st_size;
	}

	DODEBUG(if(status==0&&statb.st_size==0){(void)close(fd);return NULLSTR;})

	size += sizeof Str1 + sizeof Str2 + sizeof Str3 + sizeof Str4 + sizeof Str5 + sizeof number * 2 + sizeof StrCore;

	for ( cpp = &ARG(va, 0) ; *cpp != NULLSTR ; cpp++ )
		size += strlen(*cpp) + 1;

	errs = cp = Malloc(size);

	cp = strcpyend(cp, Str1);
	(void)sprintf(number, "%d", (status>>8)&0xff);
	cp = strcpyend(cp, number);
	if ( status & 0xff )
	{
		cp = strcpyend(cp, Str2);
		(void)sprintf(number, "%d", status&0x7f);
		cp = strcpyend(cp, number);
		if ( status & 0x80 )
			cp = strcpyend(cp, StrCore);
	}
	cp = strcpyend(cp, Str3);

	for ( cpp = &ARG(va, 0) ; *cpp != NULLSTR ; cpp++ )
	{
		cp = strcpyend(cp, *cpp);
		*cp++ = ' ';
	}

	cp = strcpyend(cp, Str4);

	if ( (size = statb.st_size) > 0 )
	{
		(void)lseek(fd, (long)0, 0);
		(void)read(fd, cp, size);

		for ( ; size-- ; cp++ )
			if ( *cp == '\0' )
				*cp = ' ';
		
		--cp;
		if ( *cp++ != '\n' )
			*cp++ = '\n';
	}

	(void)close(fd);

	(void)strcpy(cp, Str5);

	return errs;
}



/*
**	Strip debugging info. from error string
*/

char *
StripErrString(errs)
	char *	errs;
{
	register char *	cp1;
	register char *	cp2;

	if ( (cp2 = MatchString(errs, Str4)) != NULLSTR )
	{
		do
		{
			cp1 = cp2;
			cp1 += strlen(Str4);
		}
		while
			( (cp2 = MatchString(cp1, Str4)) != NULLSTR );

		if ( (cp2 = MatchString(cp1, Str5)) == NULLSTR )
			return newstr(cp1);

		return newnstr(cp1, cp2-cp1);
	}

	return newstr(errs);
}
