#! /bin/sh

#
# Daily SunIII statistics summary	- run from cron just befre midnight
#

#
# default directories (if not explicitly set)
#
: ${BINDIR=/usr/local}
: ${SPOOLDIR=/usr/spool/ACSnet}
: ${LIBDIR=$SPOOLDIR/_lib}
: ${STATSDIR=$SPOOLDIR/_stats}

#
# misc shorthands
#
A=$LIBDIR/statssum.awk
Y=Summary.yesterday
T=/tmp/SunSum.$$

cd $STATSDIR
umask 037
PATH=$BINDIR:/bin:/usr/bin

#
# find out about the date
#
set -$- `date`
day=$1		# 3 char name - day of week
mon=$2		# 3 char name - month of year
date=$3		# 1 or 2 digits - day of month
year=$6		# 4 digits - year

#
# next, work out which week of the month this is
#	nb: my definition of a week, is 7 consecutive
#	days, starting on a Sunday.  Partial week (from
#	1st of month to 1st Sat in month) counts as week 1
#
case $day in
	Sun)	d=6;;
	Mon)	d=5;;
	Tue)	d=4;;
	Wed)	d=3;;
	Thu)	d=2;;
	Fri)	d=1;;
	Sat)	d=0;;
esac
week=wk"`expr '(' $date + $d + 6 ')' / 7`"

#
# Collect current stats, save today's bulk data, truncate it for new day
#
acsstate -X
cp Accumulated Accum.last
> Accumulated

#
# Summarise  (nb: don't mind long filename - it works on all systems)
#	(its called 'yesterday' as that's what it will soon be)
#	(stats.dummy is just so awk can find at least 1 stats* file)
#
> stats.dummy
rm -f $Y
awk -F: -f $A Accum.last stats* >$Y
rm -f stats*

#
# Now build the periodic summaries
#
trap 'rm -f $T; exit' 0 1 2 3 15

[ -r Summary ] || > Summary
awk -F: -f $A Summary $Y >$T; cp $T Summary

#
# If there is no data for this year, then we need to start it
#
if [ ! -r Summary.$year ]; then
	> Summary.$year
fi

awk -F: -f $A Summary.$year $Y >$T; cp $T Summary.$year

#
# Sim, if this is the first of the month, then discard last
# year's data for this month (if there was any)
#
if [ $date -eq 1 -o ! -r Summary.$mon ]; then 
	> Summary.$mon
fi

awk -F: -f $A Summary.$mon $Y >$T; cp $T Summary.$mon

#
# And same for week of month.
#	(new week starts on 1st of month, or any Sunday)
#
if [ $date -eq 1 -o $day = Sun -o ! -r Summary.$week ]; then
	> Summary.$week
fi

awk -F: -f $A Summary.$week $Y >$T; cp $T Summary.$week

#
# daily summaries (in 2 guises) are simply links to today's data
#
rm -f Summary.$date Summary.$day
ln $Y Summary.$date
ln $Y Summary.$day

# dat's all folks
