#!/bin/sh
NODE=$1
TZ=EST-10 export TZ

#NB  The administrator must have an account (or mail alias/forwarding address)
#    on both the Unix machine and the VMS machine

ADMIN=$2

HOME=/usr/spool/ACSnet/$NODE export HOME
PATH=/usr/spool/ACSnet/_lib:$PATH export PATH
cd $HOME
rm -f core
exec > mail.out 2>&1 
set -x
failed=false

#	Test for uucp connections

device=`sed -e "s!^.* -d/dev/\(tty..\).*\\$!\1!" < relayargs`

if [ -f /usr/spool/uucp/LCK..${device} ]
then
	echo Mail lock set on line /dev/${device} >> mail.lock.out
	LNAME=vmsrelay mail $ADMIN < mail.lock.out
	exit 1
fi

if [ -r mail.lock ]
then
	echo Mail lock set >> mail.lock.out
	LNAME=vmsrelay mail $ADMIN < mail.lock.out
	if [ -s mail.lock ]
	then
		rm mail.lock
		exit 1
	fi
	echo LOCK TRIED > mail.lock
	exit 1
else
	cp /dev/null mail.lock
fi

cp /dev/null logfile
cp /dev/null sneakfile
cp /dev/null mail.lock.out

#	Receive mail

if nice --10 VMS_mailer -rmail.from$NODE $NODE
then
	# Success
	VMS_sendmail $NODE < mail.from$NODE
else
	failed=true
fi
if [ -s mail.from$NODE ]
then
	mv mail.from$NODE vms_log/f`VMS_mkname`$NODE
fi

#	Send mail

cp /dev/null mail.to$NODE

if [ -s mail.failed ]
then
	cat mail.failed > mail.to$NODE
	rm mail.failed
fi

for i in to*
do
	cat $i && rm -f $i
done >> mail.to$NODE

if [ -s mail.to$NODE ]
then
	# Mail to send
	if nice --10 VMS_mailer -smail.to$NODE $NODE
	then
		# Success
		mv mail.to$NODE vms_log/t`VMS_mkname`$NODE
	else
		# Failed
		cp mail.to$NODE mail.failed
		failed=true
	fi
fi
if [ $failed = true ]
then
	zzz=vms_log/log`VMS_mkname`
	cat mail.out logfile > $zzz
	LNAME=vmsrelay mail $ADMIN < mail.out
	rm mail.lock
	exit 1
fi
if [ -s sneakfile ]
then
	LNAME=vmsrelay mail $ADMIN < sneakfile
fi
rm mail.lock
