/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)node.h	1.14 88/09/05
*/

/*
**	Network topology header.
*/

/*
**	Hashing parameters
*/

#if	CRC_HASH == 1
#define	HASH_SIZE	128
#define	HASH_MASK	(HASH_SIZE-1)	/* Only define this if HASH_SIZE is a power of 2 */
#define	HASHSTRING	"CRC-16"
#else	CRC_HASH == 1
#define	HASH_SIZE	127
#define	HASH(H,C)	(H)+=(H)+(C)
#define	HASHSTRING	"H += H + C"
#endif	CRC_HASH == 1

/*
**	Forward references
*/

typedef struct Domain *	Dom_p;
typedef struct Entry *	Ent_p;
typedef struct Link *	Link_p;

/*
**	Domain header
*/

typedef struct
{
	Dom_p	d_head;
	Dom_p *	d_tail;
	Dom_p	d_last;
	int	d_count;
}
			DomHead;

/*
**	Handlers for links to this node
*/

typedef struct
{
	char *	h_spooler;
	char *	h_connector;
	char *	h_caller;
	char *	h_filter;
}
			Hndl;

/*
**	Node descriptor
*/

typedef struct
{
	Link_p	n_l_first;		/* Header for links list */
	Link_p*	n_l_last;
	DomHead	n_domains;		/* First domain is primary */
	Hndl *	n_handlers;		/* Handlers if non-standard */
	char *	n_comment;		/* Comment from statefile */
	char *	n_hierarchy;		/* Remembered hierarchy */
	Time_t	n_state;		/* Date of last state message */
#	if	NODE_STATS == 1
	Time_t	n_date;			/* Date last active */
	ulong	n_recvd;		/* Bytes received from this node */
	ulong	n_sent;			/* Bytes sent to this node */
	ulong	n_passto;		/* Bytes to this node routed via us */
	ulong	n_passfrom;		/* Bytes from this node routed via us */
#	endif	NODE_STATS
	ulong	n_dist;			/* Distance from Home used in routing calculation */
	short	n_tolinks;		/* Links to this node */
	short	n_fromlinks;		/* Links from this node */
}
			Node;

/*
**	Node-node data descriptor
*/

typedef struct
{
	States	d_states;		/* Up/down/... */
	Ushort	d_cost;			/* Notional seconds per 1K bytes */
	ulong	d_speed;		/* Notional speed in bytes/second */
#	if	LINK_STATS == 1
	ulong	d_time;			/* Elapsed time taken by ... */
	ulong	d_bytes;		/*  bytes transferred on this link */
#	endif	LINK_STATS
}
			Data;

/*
**	Node-node link descriptor
*/

typedef struct Link
{
	Link_p	l_next;
	Ent_p	l_entry;
	Data *	l_data;
}
			Link;

/*
**	Possible descriptors for Entry
*/

typedef union
{
	Node *	t_node;			/* Data for a node */
	char *	t_value;		/* Value for an alias */
	char *	t_handler;		/* Handler for a domain */
}
			Type;

#define	e_handler	e_data.t_handler
#define	e_node		e_data.t_node
#define	e_value		e_data.t_value
#define	e_next		e_route		/* Linked list of exported aliases */

/*
**	An entry in a hash table
*/

typedef struct Entry
{
	Type	e_data;			/* Value of entry */
	Ent_p	e_great;		/* Branches of binary tree */
	Ent_p	e_less;
	Ent_p	e_route;		/* Shortest path */
	States	e_states;		/* State of node/domain/alias */
	short	e_index;		/* Index in sorted list for this entry */
	char	e_name[NODE_NAME_SIZE+1];
}
			Entry;

/*
**	Domain membership descriptor
*/

typedef struct Domain
{
#	if	OLD_CC != 0
	States	d_states;
#	endif	OLD_CC
	Dom_p	d_next;
	Dom_p	d_previous;
	Entry *	d_entry;
#	if	OLD_CC == 0
	States	d_states;
#	endif	OLD_CC
}
			Domain;
/*
**	Type allocator
*/

#ifdef	Talloc
#undef	Talloc
#endif
#define	Talloc(type)	(type *)strclr(Malloc(sizeof(type)),sizeof(type))

/*
**	Data declarations
*/

extern int		AliasCount;
Extern Entry *		AliasHash[HASH_SIZE];
Extern Entry **		AliasList;
Extern DomHead		DomHier;
extern int		DomainCount;
Extern Entry *		DomainHash[HASH_SIZE];
Extern Entry **		DomainList;
Extern int		EdgeCount;
Extern DomHead		ForeignHier;
Extern Entry *		Home;
extern int		NodeCount;
Extern Entry *		NodeHash[HASH_SIZE];
Extern Entry **		NodeList;
Extern Entry *		XAliases;

/*
**	Function declarations
*/

extern Entry *		AddDomain();
extern void		CheckHierarchy();
extern void		CheckLinkDomains();
extern void		CheckSourceDomains();
extern void		ClearRoute();
extern void		ClearState();
extern void		ClearDomains();
extern char *		DomString();
extern Entry *		Enter();
extern int		HashName();
extern Link **		IsLinked();
extern Entry *		Lookup();
extern Data *		MakeLink();
extern void		MakeList();
extern void		SetDomains();
extern void		SetHierarchy();
extern void		MakeRoute();
extern void		Unlink();
