/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
**
**	SCCSID @(#)MakeList.c	1.8 86/02/10
*/

/*
**	Make a sorted list of entries from a hash table.
**
**	If table is "NodeHash", then sort the links for each node into order.
**
**		N.B: The `Home' node is NOT included in "NodeList",
**		     so "NodeList" contains `NodeCount-1' nodes.
*/

#include	"global.h"
#include	"debug.h"
#include	"state.h"

#include	"node.h"


static Entry **	List;
static Entry ** Listp;
static bool	Nodes;
static bool	Aliases;

static void	MLfromTree();
int		MLcompare();



void
MakeList(count, listp, table)
	register int		count;
	Entry ***		listp;
	Entry **		table;
{
	register Entry **	epp;
	register Entry **	end;

	if ( count == 0 )
		return;

	if ( table == NodeHash )
	{
		/*
		**	Home is not placed in list
		*/

		Home->e_index = -1;

		if ( --count == 0 )
		{
			Home->e_route = (Entry *)0;
			return;
		}

		Nodes = true;
		Aliases = false;
	}
	else
	{
		Nodes = false;

		if ( table == AliasHash )
			Aliases = true;
		else
			Aliases = false;
	}

	if ( *listp != (Entry **)0 )
		free((char *)*listp);
	
	*listp = List = Listp = (Entry **)Malloc(count * sizeof(Entry *));

	for ( epp = table, end = &epp[HASH_SIZE] ; epp < end ; epp++ )
		if ( *epp != (Entry *)0 )
			MLfromTree(*epp);
	
	DODEBUG(if((Listp-List)!=count)Fatal3("Bad count in MakeList = %d (should be %d)",count,(Listp-List)));

	if ( count > 1 )
		qsort((char *)List, count, sizeof(Entry *), MLcompare);
	
	for ( epp = Listp ; --count >= 0 ; )
		(*--epp)->e_index = count;
}


static void
MLfromTree(ep)
	Entry *		ep;
{
	register Node *	np;
	register Link *	lp;
	register Link**	lpp;
	register bool	rescan;

	if ( ep->e_great != (Entry *)0 )
		MLfromTree(ep->e_great);

	if ( ep->e_less != (Entry *)0 )
		MLfromTree(ep->e_less);

	if ( !(ep->e_states & S_FOUND) )
		return;

	if ( !Aliases )
		ep->e_route = (Entry *)0;

	if ( Nodes )
	{
		np = ep->e_node;

		if ( np->n_l_first != (Link *)0 )
		{
			/*
			**	Sort the links
			*/

			do
			{
				rescan = false;

				for
				(
					lpp = &np->n_l_first ;
					(lp = *lpp)->l_next != (Link *)0 ;
					lpp = &(*lpp)->l_next
				)
					if
					(
						strccmp
						(
							lp->l_entry->e_name,
							lp->l_next->l_entry->e_name
						)
					  >
						0
					)
					{
						*lpp = lp->l_next;
						lp->l_next = lp->l_next->l_next;
						(*lpp)->l_next = lp;
						rescan = true;
					}
			}
				while ( rescan );

			np->n_l_last = &lp->l_next;
		}

		if ( ep != Home )
			*Listp++ = ep;
	}
	else
		*Listp++ = ep;

	return;
}



int
MLcompare(epp1, epp2)
	char *	epp1;
	char *	epp2;
{
	return strccmp((*(Entry **)epp1)->e_name, (*(Entry **)epp2)->e_name);
}
