/*
**	Copyright (c) 1984 Piers Lauder, University of Sydney
**
**	Warning: Distribution of this software without written
**		 permission is prohibited.
*/

static char	sccsid[]	= "89/01/09 @(#)main.c	1.66";

/*
**	Startup for node-node daemon
*/

#define	FILE_CONTROL
#define	STDIO
#define	TIMES
#define	NEED_HZ

#include	"global.h"
#include	"command.h"
#include	"debug.h"

#include	"Passwd.h"
#include	"spool.h"

#include	<signal.h>
#include	<errno.h>

#include	"Stream.h"
#include	"driver.h"
#undef	Extern
#define	Extern
#include	"daemon.h"


#if	DEBUG >= 1
char *	Usage	= "[-[B[<timeout>]][C][F][I][N][P[<level>]][R][T[<level>]][U][X]]\n\
	[-b<buffers>] [-c<channels>] [-d<device>] [-e<tracefile>]\n\
	[-f<first channel>] [-h<homenode>] [-i<intra-packet delay>]\n\
	[-m<multipath>] [-p<devspeed>] [-q<min speed>] [-r<routedir>]\n\
	[-s<speed>] [-t<directory>] [-z<packet size>] linkdir";
#endif

/*
**	Filenames that must be set up
*/

char *	BadHandler	= BADHANDLER;		/* Name of bad message handler process */
char *	Console		= CONSOLE;		/* Network error device */
char *	Daemondir;				/* Directory in Spooldir for daemon command files */
char *	Device;					/* Device special file for link */
char *	Logfile		= LOGFILE;		/* Name of logfile */
char *	MessageHandler	= RECEIVER;		/* Name of message handler process */
char *	NewstateHandler	= NEWSTATEHANDLER;	/* Name of state change process */
char *	ParamsFile	= NNDPARAMS;		/* File name for start-up parameters */
char *	Spooldir	= SPOOLDIR();		/* Name of spool directory where network directories are kept */
char *	Statusfile	= STATUSFILE;		/* File name for state info. */
char	Template[STREAMIDZ+1];			/* Last component of node-node command file name */
char *	Workdir		= WORKDIR();		/* Directory for temporary files */

/*
**	Flags that can be set on invokation.
**
**	(Others declared in "daemon.h".)
*/

long	BlockCount;				/* Writes BLOCKED */
int	DevSpeed;				/* Magic number for device speed setting */
int	Fstream;				/* First channel in use */
bool	HalfDuplex;				/* True if daemon in half-duplex mode */
int	HoldAcks;				/* Overrides protocol's ACK window */
bool	IgnoreOldPid;				/* Ignore any pid in old state file */
int	IntraPktDelay;				/* Maximum delay inside packets */
long	MinSpeed;				/* Minimum speed prepared to accept */
int	Nbufs		= 3;			/* Window size */
bool	NoFork;					/* Don't fork! (used by NNshell) */
int	Nstreams	= NSTREAMS;		/* Number of channels in use */
int	PktZ;					/* Max. size of packet on link */
long	Speed		= 960/4;		/* Minimum effective bytes per second for link */
int	Traceflag;				/* Global tracing control */
bool	UseCrc		= true;			/* Use CRC error detection */
bool	UseFd1;					/* Virtual circuit established on fd 1 */
bool	XonXoff;				/* Enable XON/XOFF flow control */

/*
**	Miscellaneous
*/

char *	DevNull		= "/dev/null";
bool	Pausing;
bool	Starting	= true;
char *	CantOpen	= "cannot open \"%s\"";
char *	FinishReason	= "FINISHED";
ulong	MesgNumber;

#if	DEBUG >= 1
extern int	Ptraceflag;
extern FILE *	PtraceFd;

char *	Params;
char *	ParamsP;
#endif	DEBUG

void	CpuStats(), Pprintstats(), Update(), args(), driver(), finish(),
	mesg(), stats(), usage();
int	changetrace(), terminate();
bool	open_remote();




void
main(argc, argv)
	int	argc;
	char *	argv[];
{
	char *	cp;
	int	pid;

	if ( (Name = strrchr(*argv, '/')) != NULLSTR )
		Name++;
	else
		Name = *argv;

	DODEBUG(Params = ParamsP = Malloc(1000));

	args(argc, argv);

	if ( LinkDir == NULLSTR )
	{
		usage("no target specified");
		exit(1);
	}

	if ( HomeNode == NULLSTR )
		HomeNode = NodeName();

	(void)sprintf(Template, "%c%-*.*s", SMALL_ID, sizeof Template - 2, sizeof Template - 2, Name);

	if ( Daemondir == NULLSTR )
		Daemondir = LinkDir;

	if
	(
		chdir(Spooldir) == SYSERROR
		||
		chdir(Daemondir) == SYSERROR
	)
	{
		Syserror("%s%s inaccessible", Spooldir, Daemondir);
		exit(1);
	}

	if ( (cp = ReadFile(ParamsFile)) != NULLSTR )
	{
		VarArgs	va;

		FIRSTARG(&va) = Name;
		SplitArg(&va, cp);
		args(NARGS(&va), &ARG(&va, 0));
		free((char *)cp);
	}

	if ( Cook && BufferOutput > 1 )		/* one byte smaller for \r */
		BufferOutput--;

#	ifdef	MULTIPATH
	if ( MultiPath != NULLSTR && chdir(MultiPath) == SYSERROR )
	{
		Syserror("sub-dir \"%s\" inaccessible", MultiPath);
		exit(1);
	}
#	endif	MULTIPATH

	if ( BatchMode )
	{
		UseFd1 = true;

		DevSpeed = SetRaw(1, DevSpeed, 1, 0, (bool)(XonXoff&&Cook));

		if ( BatchTime == 0 )
			BatchTime = BATCH_TIMEOUT;
	}
	else
	{
		if ( Device == NULLSTR )
			Device = concat(DEVNET(), LinkDir, MultiPath, NULLSTR);
		else
		if ( Device[0] == '\0' )
			UseFd1 = true;
	}

	(void)umask(022);

#	ifdef	NICEDAEMON
	/*
	**	This won't work if not root,
	**	so other programs that "setuid(ACSNETUID)" must nice up first.
	*/

	if ( geteuid() == 0 )
		(void)nice(NICEDAEMON);
#	endif	NICEDAEMON

	SetUser(ACSNETUID, ACSNETGID);

	Pid = getpid();

	/*
	**	Call ReadState() to initialise the statefile.
	*/

	if ( (pid = ReadState()) > 0 && pid != Pid && !IgnoreOldPid )
	{
		if
		(
			NNstate.procstate != PROC_CALLING
			&&
			kill(pid, SIG0) != SYSERROR
		)
		{
			Error("daemon for %s already active", LinkDir);
			exit(1);
		}
	}

	/*
	**	Close all the std open fds.
	*/

	(void)fclose(stdin);

	if ( !UseFd1 )
	{
		if ( access(Device, 06) == SYSERROR )
		{
			Syserror(CantOpen, Device);
			exit(1);
		}

		(void)fclose(stdout);
	}

	while ( freopen(Logfile, "a", stderr) == NULL )
		if ( unlink(Logfile) == SYSERROR )
		{
			if ( freopen(Console, "w", stderr) != NULL )
				Syserror(CantOpen, Logfile);
			exit(1);
		}

#	if	BSD4 >= 2
	setlinebuf(stderr);
#	endif	BSD4 >= 2

#	if	FCNTL == 1 && O_APPEND != 0
#	if	O_APPEND_BUG
	if ( !isatty(fileno(stderr)) )
#	endif
	(void)fcntl
	(
		fileno(stderr),
		F_SETFL,
		fcntl(fileno(stderr), F_GETFL, 0) | O_APPEND
	);
#	endif

	/*
	**	Fork, if necessary.
	*/

#	if	PGRP == 1
	if ( Pid != getpgrp() && !NoFork )
#	else	PGRP
	if ( !NoFork )
#	endif	PGRP
		switch ( fork() )
		{
		default:
			exit(0);	/* Parent returns */
		
		case 0:
			Pid = getpid();	/* Child continues */
#			if	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
			(void)cleartty();
#			else	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
#			if	PGRP == 1
			(void)setpgrp();
#			endif	PGRP
#			endif	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
			break;

		case SYSERROR:
			Syserror("cannot fork");
			exit(1);
		}

	NNstate.procid = Pid;
	LastTime = time((long *)0);
	NNstate.starttime = LastTime;
	NNstate.lasttime = LastTime;
	NNstate.activetime = 0;

#	if	KILL_0 != 1 && SIG0 != SIGINT
	(void)signal(SIG0, SIG_IGN);	/* To allow interrogation for existence */
#	endif	KILL_0 != 1 && SIG0 != SIGINT

#	if	V8 == 1
	(void)signal(SIGHUP, terminate);
	(void)signal(SIGPIPE, SIG_IGN);
#	else
	if ( UseFd1 )
		(void)signal(SIGHUP, terminate );
	else
		(void)signal(SIGHUP, SIG_IGN );
#	endif

	(void)signal(SIGINT, SIG_IGN);
#	if	SIGERROR != SIGQUIT
	(void)signal(SIGQUIT, SIG_IGN);
#	endif
	(void)signal(SIGTERM, terminate);

#	if	DEBUG >= 1
	(void)signal(SIGTRCON, changetrace);
	(void)signal(SIGTRCOFF, changetrace);
#	else	DEBUG >= 1
	(void)signal(SIGTRCON, SIG_IGN);
	(void)signal(SIGTRCOFF, SIG_IGN);
#	endif	DEBUG >= 1

	(void)signal(SIGERROR, finish);

	mesg("STARTED");
	DODEBUG(Mesg(LinkDir, "%s\n", Params); free(Params));

	if ( UseFd1 )
		RemoteFd = 1;
	else
		RemoteFd = SYSERROR;

	if ( Cook )
		Write = RCwrite;
	else
	if ( BufferOutput )
		Write = Rwrite;
	else
		Write = write;

	Starting = false;

	driver();

	finish(0);
}



/*
**	Process arguments
*/

void
args(argc, argv)
	register int	argc;
	register char *	argv[];
{
	while ( --argc > 0 )
	{
		DODEBUG(*ParamsP++ = ' '; ParamsP = strcpyend(ParamsP, argv[1]));

		if ( **++argv == '-' )
		{
			register int	c;
			register int	n;

			while ( c = *++*argv )
			{
				switch ( c )
				{
				case 'B':
					BatchMode = true;
					if ( (BatchTime = atol(++*argv)) > 0 )
						break;
					--*argv;
					continue;

				case 'C':
					Cook = true;
					continue;

				case 'F':
					NoFork = true;
					continue;

				case 'H':
					HalfDuplex = true;
					if ( (HoldAcks = atoi(++*argv)) > 0 )
						break;
					--*argv;
					continue;

				case 'I':
					IgnoreOldPid = true;	
					continue;

				case 'N':
					NoAdjust = true;
					continue;

				case 'P':
#					if	DEBUG >= 1
					if ( (Ptraceflag = atoi(++*argv)) <= 0 )
						Ptraceflag = 1;
#					else	DEBUG
					++*argv;
#					endif	DEBUG
					break;

				case 'R':
					UseCrc = false;
					continue;

				case 'T':
					if ( (Traceflag = atoi(++*argv)) <= 0 )
						Traceflag = 1;
					break;

				case 'U':
					ContinuousUpdate = true;
					continue;

				case 'X':
					XonXoff = true;
					continue;

				case 'b':
					if ( (Nbufs = atoi(++*argv)) <= 0 )
					{
						usage("bad buffer count %s", *argv);
						return;
					}
					break;

				case 'a':
					ParamsFile = ++*argv;
					goto break2;

				case 'c':
					if
					(
						(Nstreams = atoi(++*argv)) <= 0
						||
						Nstreams > NSTREAMS
					)
					{
						usage("bad channel count %s", *argv);
						return;
					}
					break;

				case 'd':
					Device = ++*argv;
					goto break2;

				case 'e':
#					if	DEBUG >= 1
					if ( (TraceFd = fopen(++*argv, "w")) == NULL )
					{
						usage("can't open \"%s\" for trace output", *argv);
						return;
					}
					PtraceFd = TraceFd;
#					else	DEBUG
					++*argv;
#					endif	DEBUG
					goto break2;

				case 'f':
					if
					(
						(Fstream = atoi(++*argv)) < 0
						||
						Fstream >= NSTREAMS
					)
					{
						usage("bad first channel request %s", *argv);
						return;
					}
					break;

				case 'h':
					HomeNode = ++*argv;
					goto break2;

				case 'i':
					if ( (IntraPktDelay = atoi(++*argv)) < 0 )
					{
						usage("bad intra-packet delay %s", *argv);
						return;
					}
					break;

				case 'm':
#					ifdef	MULTIPATH
					MultiPath = ++*argv;
					goto break2;
#					else	MULTIPATH
					usage("multi-path option unavailable");
					return;
#					endif	MULTIPATH

				case 'o':
					if
					(
						(BufferOutput = atoi(++*argv)) <= 0
						||
						BufferOutput > PBUFSIZE
					)
					{
						usage("bad output buffer size: must be in range 1 to %d", PBUFSIZE);
						return;
					}
					break;

				case 'p':
					if ( (DevSpeed = atoi(++*argv)) < 0 )
					{
						usage("bad device speed %s", *argv);
						return;
					}
					break;

				case 'q':
					if ( (MinSpeed = atoi(++*argv)) < 0 )
					{
						usage("bad minimum speed %s", *argv);
						return;
					}
					break;
					
				case 'r':
					RouteDir = ++*argv;
					goto break2;

				case 's':
					if ( (n = atoi(++*argv)) <= 0 )
					{
						usage("bad speed %s", *argv);
						return;
					}
					Speed = n;
					break;

				case 't':
					Daemondir = ++*argv;
					goto break2;

				case 'w':
					HoldAcks = atoi(++*argv);
					break;

				case 'z':
					if ( (PktZ = atoi(++*argv)) <= 0 )
					{
						usage("bad packet size %s", *argv);
						return;
					}
					break;

				default:
					usage("unrecognised flag '%c'", c);
					return;
				}

				while ( (c = **argv) <= '9' && c >= '0' )
					++*argv;
				--*argv;
			}

break2:			;
		}
		else
			LinkDir = *argv;
	}

	if ( Fstream >= Nstreams )
		Nstreams += Fstream - Nstreams + 1;
}



/*
**	Open link to remote node
*/

bool
open_remote()
{
	Update(up_opening);

	if ( !UseFd1 && RemoteFd == SYSERROR )
		while ( (RemoteFd = open(Device, O_RDWR|O_EXCL)) == SYSERROR )
			Syserror(CantOpen, Device);

	/*
	**	Put circuit in RAW mode.
	**	(For SYSTEM xx:- VMIN = min read, VTIME = infinite.)
	*/

	if ( !UseFd1 )
		DevSpeed = SetRaw(RemoteFd, DevSpeed, 1, 0, (bool)(XonXoff&&Cook));

#	if	V8 == 1
	{
		extern int	buf_ld;

		/*
		**	Push the buffering line-discipline,
		**	to make "select" more effective,
		**	and provide extra buffering.
		**
		**	"buf_ld" should have settable time/size (default is .1/16).
		*/

		if ( ioctl(RemoteFd, FIOLOOKLD, (char *)0) != buf_ld )
			(void)ioctl(RemoteFd, FIOPUSHLD, (char *)&buf_ld);
	}

	(void)ioctl(RemoteFd, TIOCSPGRP, (char *)0);
#	endif

	return true;
}



void
close_remote()
{
	if ( RemoteFd != SYSERROR )
	{
		(void)close(RemoteFd);
		RemoteFd = SYSERROR;
	}

#	if	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
	(void)cleartty();
#	endif	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
}




void
finish(error)
	int	error;
{
	static bool	finishing;

	ALARM_OFF();

	if ( finishing )
	{
		if ( !error )
			return;

		Fatal1("recursing in finish");
	}

	finishing = true;

	if ( !Starting && Pid == getpid() )
	{
		extern void	Pflush();

		Pflush();

		if ( error && !UseFd1 )
		{
			register FILE *	fd;

			if ( error != SYSERROR )
				NewState(LINK_DOWN, true);

			close_remote();

			if ( (fd = fopen(Console, "w")) != NULL )
			{
				(void)fprintf
				(
					 fd
#					ifdef	MULTIPATH
					,"\r\n%s for \"%s\" %s%s%s/%s%s%s%s%d%s\r\n"
#					else	MULTIPATH
					,"\r\n%s for \"%s\" %s%s%s/%s%s%d%s\r\n"
#					endif	MULTIPATH
					,Name
					,LinkDir
					,"SYSTEM ERROR: please tail \""
					,Spooldir
					,Daemondir
#					ifdef	MULTIPATH
					,MultiPath!=NULLSTR?"/":""
					,MultiPath!=NULLSTR?MultiPath:""
#					endif	MULTIPATH
					,Logfile
					,"\" to find problem,\r\nfix it, then \"kill "
					,Pid
					,"\" to terminate the daemon"
				);

				(void)fclose(fd);
			}

			Update(up_error);
			stats("ERROR");

			Pausing = true;
			(void)sleep(60*30);	/* Don't wait too long */
		}
		else
		{
			if ( error == SIGERROR )
				FinishReason = "router ERROR";
			if ( error == 0 )
				check_router();
			Update(up_finish);
			stats(FinishReason);
		}

		DODEBUG(if(error)(void)kill(Pid, SIGIOT));	/* Dump a core */
	}

	if ( Starting )
		(void)sleep(10);	/* Depress bad invokation loops */

	(void)exit(error);
}



/*
**	Print out statistics
*/

void
stats(string)
	char *	string;
{
	Time_t	elapsed;

	mesg(string);
#	if	NND_STATS
	if ( NNstate.starttime > 0 )
		elapsed = time((long *)0) - NNstate.starttime;
	else
		elapsed = 0;

	(void)fprintf
	(
		 stderr
		,"%ld bytes in %ld messages in %ld seconds,\naverage active transfer rate: %ld bytes/second,\noverall transfer rate: %ld bytes/second.\n"
		,NNstate.allbytes
		,NNstate.allmessages
		,elapsed
		,(NNstate.activetime>0)?NNstate.allbytes/NNstate.activetime:0L
		,(elapsed>0)?NNstate.allbytes/elapsed:0L
	);
#	endif	NND_STATS
#	if	PROTO_STATS
	Pprintstats(stderr);
#	endif	PROTO_STATS
#	if	NND_STATS
	if ( BlockCount )
		(void)fprintf(stderr, "%9ld writes BLOCKED\n", BlockCount);
	CpuStats();
#	endif	NND_STATS
	(void)fflush(stderr);
}



/*
**	Explain usage
*/

#if	VARARGS
void
usage(va_alist)
	va_dcl
{
	va_list		ap;
	register char 	*s;

	va_start(ap);
	s = va_arg(ap, char *);
	VMesg("bad arguments", s, ap);
	va_end(ap);
#	if	DEBUG >= 1
	(void)fprintf(stderr, "\nUsage is \"%s %s\"\n", Name, Usage);
#	else	DEBUG
	putc('\n', stderr);
#	endif	DEBUG
	(void)sleep(10);	/* Depress bad invokation loops */
	exit(1);
}
#else
/*VARARGS1*/
void
usage(s, a1)
	char *	s;
	char *	a1;
{
	Mesg("bad arguments", s, a1);
#	if	DEBUG >= 1
	(void)fprintf(stderr, "\nUsage is \"%s %s\"\n", Name, Usage);
#	else	DEBUG
	putc('\n', stderr);
#	endif	DEBUG
	(void)sleep(10);	/* Depress bad invokation loops */
	exit(1);
}
#endif



/*
**	Start/Stop messages in logfile.
*/

void
mesg(s)
	char *	s;
{
	Mesg(LinkDir, "Vn=\"%s\" (pid=%d) %s\n", Version, Pid, s);
	(void)fflush(stderr);
}



/*
**	Catch system termination signal.
*/

int
terminate(sig)
	int	sig;
{
	(void)signal(sig, SIG_IGN);

	if ( !Pausing )
	{
		if ( sig == SIGHUP )
			FinishReason = "HANGUP";
		else
			FinishReason = "TERMINATED";
		Finish = true;
		return;
	}

	Update(up_finish);
	exit(1);
}



/*
**	Close all files except 'stderr' for child process.
**
**	(Called from routines in "children.c".)
*/

void
closeall()
{
	register int	i;

	if ( Alarm )
	{
		ALARM_OFF();
		Warn("Alarm set at call to closeall()");
	}

	(void)signal(SIGHUP, SIG_IGN);
	(void)signal(SIGTERM, SIG_IGN);

	while ( fileno(stderr) != 2 )
	{
		(void)close(2);

		while ( (i = dup(fileno(stderr))) == SYSERROR )
		{
			Syserror("Can't dup log file descriptor");
			if ( BatchMode )
				finish(SYSERROR);
		}

		fileno(stderr) = i;
	}

	(void)close(0);

	while ( open(DevNull, O_RDWR) == SYSERROR )
	{
		Syserror(DevNull); /* (you wouldn't believe how silly some systems can be...) */
		if ( BatchMode )
			finish(SYSERROR);
	}

	(void)close(1);
	(void)dup(0);

	for ( i = 3 ; close(i) != SYSERROR || i < 9 ; i++ );
		/* There can be up to 9 files open */

#	ifdef	NICEHANDLERS
#	ifdef	NICEDAEMON
	(void)nice(NICEHANDLERS-(NICEDAEMON));
#	else	NICEDAEMON
	(void)nice(NICEHANDLERS);
#	endif	NICEDAEMON
#	endif	NICEHANDLERS
}



#if	NND_STATS
/*
**	Print out system cpu stats.
*/

#if	BSD4 > 1 || (BSD4 == 1 && BSD4V == 'c')

#include <sys/time.h>
#include <sys/resource.h>

void
CpuStats()
{
	struct rusage dus;
	struct rusage cus;

	(void) getrusage(RUSAGE_SELF, &dus);
	(void) getrusage(RUSAGE_CHILDREN, &cus);

	(void)fprintf
	(
		stderr,
"Usages:    user + sys = tot  io(i+o)   pf(min+maj) nswp sigs cs(iv+v)\n"
/*
"Children: NNNNN NNNNN NNNNN NNNNN+NNNNN NNNNN+NNNNN NNN NNNN NNN+NNN\n"
*/
	);

	(void)fprintf
	(
		stderr,
		"Daemon:   %5ld %5ld %5ld %5ld+%-5ld %5ld+%-5ld %3ld %4ld %3ld+%ld\n",
		dus.ru_utime.tv_sec + (dus.ru_utime.tv_usec >= 500000),
		dus.ru_stime.tv_sec + (dus.ru_stime.tv_usec >= 500000),
		((dus.ru_utime.tv_sec + dus.ru_stime.tv_sec) * 10 + 5 +
		  ((dus.ru_utime.tv_usec + dus.ru_stime.tv_usec) / 100000)) /10,
		dus.ru_inblock,
		dus.ru_oublock,
		dus.ru_minflt,
		dus.ru_majflt,
		dus.ru_nswap,
		dus.ru_nsignals,
		dus.ru_nivcsw,
		dus.ru_nvcsw
	);

	(void)fprintf
	(
		stderr,
		"Children: %5ld %5ld %5ld %5ld+%-5ld %5ld+%-5ld %3ld %4ld %3ld+%ld\n",
		cus.ru_utime.tv_sec + (cus.ru_utime.tv_usec >= 500000),
		cus.ru_stime.tv_sec + (cus.ru_stime.tv_usec >= 500000),
		((cus.ru_utime.tv_sec + cus.ru_stime.tv_sec) * 10 + 5 +
		  ((cus.ru_utime.tv_usec + cus.ru_stime.tv_usec) / 100000)) /10,
		cus.ru_inblock,
		cus.ru_oublock,
		cus.ru_minflt,
		cus.ru_majflt,
		cus.ru_nswap,
		cus.ru_nsignals,
		cus.ru_nivcsw,
		cus.ru_nvcsw
	);

	(void)fprintf
	(
		stderr,
		"Totals:   %5ld %5ld %5ld %5ld+%-5ld %5ld+%-5ld %3ld %4ld %3ld+%ld\n",
				/* rounding here is sloppy but close */
		((cus.ru_utime.tv_sec + dus.ru_utime.tv_sec) * 10 + 5 +
		  ((cus.ru_utime.tv_usec + dus.ru_utime.tv_usec) / 100000)) /10,
		((cus.ru_stime.tv_sec + dus.ru_stime.tv_sec) * 10 + 5 +
		  ((cus.ru_stime.tv_usec + dus.ru_stime.tv_usec) / 100000)) /10,
		((cus.ru_utime.tv_sec + cus.ru_stime.tv_sec +
		  dus.ru_utime.tv_sec + dus.ru_stime.tv_sec) * 10 + 5 +
		  ((cus.ru_utime.tv_usec + cus.ru_stime.tv_usec +
		    dus.ru_utime.tv_usec + dus.ru_stime.tv_usec) / 100000)) /10,
		cus.ru_inblock + dus.ru_inblock,
		cus.ru_oublock + dus.ru_oublock,
		cus.ru_minflt + dus.ru_minflt,
		cus.ru_majflt + dus.ru_majflt,
		cus.ru_nswap + dus.ru_nswap,
		cus.ru_nsignals + dus.ru_nsignals,
		cus.ru_nivcsw + dus.ru_nivcsw,
		cus.ru_nvcsw + dus.ru_nvcsw
	);
}

#else	BSD4 ...

void
CpuStats()
{
	Timesbuf	tbuf;

	(void)times(&tbuf);

	(void)fprintf
	(
		 stderr,
		"Cpu secs: sys %ld, user %ld, child sys %ld, child user %ld. Total: %ld secs\n",
		(tbuf.tms_stime + HZ-1)/HZ,
		(tbuf.tms_utime + HZ-1)/HZ,
		(tbuf.tms_cstime + HZ-1)/HZ,
		(tbuf.tms_cutime + HZ-1)/HZ,
		(tbuf.tms_stime + tbuf.tms_utime + tbuf.tms_cstime + tbuf.tms_cutime + HZ-1)/HZ
	);
}
#endif	BSD4 ...
#endif	NND_STATS



#if	DEBUG >= 1
int
changetrace(sig)
	int	sig;
{
	(void)signal(sig, changetrace);

	switch ( sig )
	{
	case SIGTRCON:
		Traceflag++;
		Ptraceflag++;
		mesg("TRACEON");
#		if	PROTO_STATS
		Pprintstats(stderr);
		(void)fflush(stderr);
#		endif	PROTO_STATS
		break;

	case SIGTRCOFF:
		Traceflag = 0;
		Ptraceflag = 0;
		mesg("TRACEOFF");
#		if	PROTO_STATS
		Pprintstats(stderr);
		(void)fflush(stderr);
#		endif	PROTO_STATS
	}
}
#endif	DEBUG >= 1


#if	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )

#include <sgtty.h>

cleartty()
{
	register fd;

	(void)setpgrp(0, 0);

	if ( (fd = open("/dev/tty", 0)) < 0 )
		return;

	(void)ioctl(fd, TIOCNOTTY, (char *)0);
	(void)close(fd);
}
#endif	BSD4 > 1 || ( BSD4 == 1 && BSD4V >= 'c' )
